/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.asn1;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Lengths;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.IntegerContainer;
import com.rsa.asn1.OIDContainer;
import com.rsa.asn1.OctetStringContainer;
import com.rsa.asn1.SequenceContainer;

public class AlgorithmID {
    public static final String berDecodeAlgID(byte[] byArray, int n2, int n3, EncodedContainer encodedContainer) throws ASN_Exception {
        int n4 = AlgorithmID.a(byArray, n2);
        return AlgorithmID.a(byArray, n4, n3, encodedContainer);
    }

    public static final int findNextOffset(byte[] byArray, int n2, int n3) throws ASN_Exception {
        int n4 = AlgorithmID.a(byArray, n2);
        n4 += AlgorithmID.a(byArray, n4, n3, null, null);
        return n4;
    }

    public static final byte[] derEncodeAlgID(String string, int n2, byte[] byArray, int n3, int n4) throws ASN_Exception {
        return AlgorithmID.derEncodeAlgID(string, n2, byArray, n3, n4, true);
    }

    public static final byte[] derEncodeAlgID(String string, int n2, byte[] byArray, int n3, int n4, boolean bl2) throws ASN_Exception {
        SequenceContainer sequenceContainer = new SequenceContainer(0, true, 0);
        EndContainer endContainer = new EndContainer();
        OIDContainer oIDContainer = new OIDContainer(0, true, 0, string, n2);
        boolean bl3 = byArray != null;
        int n5 = bl2 ? 5 : 0;
        EncodedContainer encodedContainer = new EncodedContainer(130816, bl3, n5, byArray, n3, n4);
        ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, oIDContainer, encodedContainer, endContainer};
        Object var13_13 = null;
        return ASN1.derEncode(aSN1ContainerArray);
    }

    private static int a(byte[] byArray, int n2) throws ASN_Exception {
        if (byArray == null) {
            throw new ASN_Exception("AlgorithmID.findAlgID: encoding should not be null.");
        }
        if (n2 < 0) {
            throw new ASN_Exception("AlgorithmID.findAlgID: offset should not be less than 0.");
        }
        while (n2 < byArray.length) {
            if (byArray[n2] != 48) {
                ++n2;
                continue;
            }
            int n3 = ASN1Lengths.determineLengthLen(byArray, n2 + 1);
            if (byArray[n2 + 1 + n3] == 6) {
                return n2;
            }
            n2 += 1 + n3;
        }
        throw new ASN_Exception("AlgorithmID.findAlgID: Could not find the OID");
    }

    private static String a(byte[] byArray, int n2, int n3, EncodedContainer encodedContainer) throws ASN_Exception {
        OIDContainer oIDContainer = new OIDContainer(0, n3);
        AlgorithmID.a(byArray, n2, n3, encodedContainer, oIDContainer);
        return oIDContainer.transformation;
    }

    private static int a(byte[] byArray, int n2, int n3, EncodedContainer encodedContainer, OIDContainer oIDContainer) throws ASN_Exception {
        SequenceContainer sequenceContainer = new SequenceContainer(0);
        EndContainer endContainer = new EndContainer();
        OIDContainer oIDContainer2 = oIDContainer == null ? new OIDContainer(0, n3) : oIDContainer;
        EncodedContainer encodedContainer2 = encodedContainer == null ? new EncodedContainer(130816) : encodedContainer;
        ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, oIDContainer2, encodedContainer2, endContainer};
        int n4 = ASN1.berDecode(byArray, n2, aSN1ContainerArray);
        if (oIDContainer != null && oIDContainer2.transformation == null) {
            throw new ASN_Exception("No Crypto-J transformation found for the specified OID");
        }
        if (oIDContainer2.transformation.equalsIgnoreCase("PBES2")) {
            SequenceContainer sequenceContainer2 = new SequenceContainer(0);
            SequenceContainer sequenceContainer3 = new SequenceContainer(0);
            OIDContainer oIDContainer3 = new OIDContainer(0, n3);
            SequenceContainer sequenceContainer4 = new SequenceContainer(0);
            OctetStringContainer octetStringContainer = new OctetStringContainer(0);
            IntegerContainer integerContainer = new IntegerContainer(0);
            IntegerContainer integerContainer2 = new IntegerContainer(65536);
            SequenceContainer sequenceContainer5 = new SequenceContainer(131072);
            OIDContainer oIDContainer4 = new OIDContainer(0, n3);
            EncodedContainer encodedContainer3 = new EncodedContainer(130816);
            EndContainer endContainer2 = new EndContainer();
            EndContainer endContainer3 = new EndContainer();
            EndContainer endContainer4 = new EndContainer();
            SequenceContainer sequenceContainer6 = new SequenceContainer(0);
            OIDContainer oIDContainer5 = new OIDContainer(0, n3);
            EncodedContainer encodedContainer4 = new EncodedContainer(130816);
            EndContainer endContainer5 = new EndContainer();
            EndContainer endContainer6 = new EndContainer();
            ASN1Container[] aSN1ContainerArray2 = new ASN1Container[]{sequenceContainer2, sequenceContainer3, oIDContainer3, sequenceContainer4, octetStringContainer, integerContainer, integerContainer2, sequenceContainer5, oIDContainer4, encodedContainer3, endContainer2, endContainer3, endContainer4, sequenceContainer6, oIDContainer5, encodedContainer4, endContainer5, endContainer6};
            int n5 = encodedContainer2.dataOffset;
            ASN1.berDecode(byArray, n5, aSN1ContainerArray2);
            StringBuffer stringBuffer = new StringBuffer("PBE/");
            String string = "SHA1";
            if (oIDContainer4.dataPresent) {
                String string2 = oIDContainer4.transformation;
                if (string2 == null) {
                    throw new ASN_Exception("Unknown HMAC/Digest algorithm specified in PKCS5v2 BER");
                }
                if (!string2.equalsIgnoreCase("HMAC/SHA1") && !string2.equalsIgnoreCase("HMAC/SHA1a")) {
                    if (string2.equalsIgnoreCase("HMAC/SHA256")) {
                        string = "SHA256";
                    } else {
                        throw new ASN_Exception("Unknown HMAC/Digest algorithm specified in PKCS5v2 BER");
                    }
                }
            }
            stringBuffer.append(string);
            stringBuffer.append("/");
            int n6 = oIDContainer5.transformation.lastIndexOf(47);
            stringBuffer.append(oIDContainer5.transformation.substring(0, n6 + 1));
            stringBuffer.append("PKCS5V2PBE");
            oIDContainer2.transformation = stringBuffer.toString();
        }
        return n4;
    }
}

