/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert;

import com.rsa.asn1.ASN1Lengths;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.AlgorithmID;
import com.rsa.asn1.OIDList;
import com.rsa.certj.CertJ;
import com.rsa.certj.cert.CertificateException;
import com.rsa.jsafe.JSAFE_Exception;
import com.rsa.jsafe.JSAFE_MessageDigest;
import com.rsa.jsafe.JSAFE_PrivateKey;
import com.rsa.jsafe.JSAFE_PublicKey;
import com.rsa.jsafe.JSAFE_Signature;
import java.io.Serializable;
import java.security.SecureRandom;

public abstract class Certificate
implements Cloneable,
Serializable {
    public static final int RSA_WITH_SHA1_PKCS = 0;
    public static final int RSA_WITH_SHA1_ISO_OIW = 1;
    public static final int DSA_WITH_SHA1_X930 = 2;
    public static final int DSA_WITH_SHA1_X957 = 3;
    protected byte[] subjectPublicKeyInfo;
    protected byte[] signatureAlgorithmBER;
    protected int signatureAlgorithmFormat = -1;
    protected byte[] signature;
    protected String theDevice;
    protected String[] theDeviceList;
    private CertJ a = null;

    public final void setCertJ(CertJ certJ) {
        this.a = certJ;
    }

    public final CertJ getCertJ() {
        return this.a;
    }

    public String getSignatureAlgorithm() throws CertificateException {
        try {
            if (this.signatureAlgorithmBER == null) {
                throw new CertificateException("Object not set with signature algorithm.");
            }
            return AlgorithmID.berDecodeAlgID(this.signatureAlgorithmBER, 0, 1, null);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CertificateException("Invalid Signature Algorithm.(" + aSN_Exception.getMessage() + ")");
        }
    }

    public byte[] getSignatureAlgorithmDER() throws CertificateException {
        if (this.signatureAlgorithmBER == null) {
            throw new CertificateException("Object not set with signature algorithm.");
        }
        return (byte[])this.signatureAlgorithmBER.clone();
    }

    public abstract byte[] getSignature() throws CertificateException;

    public String getDevice() throws CertificateException {
        if (this.theDevice == null) {
            throw new CertificateException("Object not set with a device.");
        }
        return this.theDevice;
    }

    public String[] getDeviceList() throws CertificateException {
        if (this.theDeviceList == null) {
            throw new CertificateException("Object not set with a device.");
        }
        String[] stringArray = new String[this.theDeviceList.length];
        for (int i2 = 0; i2 < this.theDeviceList.length; ++i2) {
            stringArray[i2] = this.theDeviceList[i2];
        }
        return stringArray;
    }

    public void setSignatureStandard(int n2) {
        this.signatureAlgorithmFormat = n2;
    }

    public int getSignatureStandard() {
        return this.signatureAlgorithmFormat;
    }

    public String getSignatureFormat(String string) {
        if (string == null) {
            return null;
        }
        switch (this.signatureAlgorithmFormat) {
            case 0: {
                if (string.equals("SHA1/RSA/PKCS1Block01Pad")) {
                    return "RSAWithSHA1PKCS";
                }
                return null;
            }
            case 1: {
                if (string.equals("SHA1/RSA/PKCS1Block01Pad")) {
                    return "RSAWithSHA1ISO_OIW";
                }
                return null;
            }
            case 2: {
                if (string.equals("SHA1/DSA") || string.equals("SHA1/DSA/NoPad")) {
                    return "DSAWithSHA1X930";
                }
                return null;
            }
            case 3: {
                if (string.equals("SHA1/DSA") || string.equals("SHA1/DSA/NoPad")) {
                    return "DSAWithSHA1X957";
                }
                return null;
            }
        }
        if (string.equals("SHA1/DSA")) {
            return "SHA1/DSA/NoPad";
        }
        return null;
    }

    public void setSubjectPublicKey(JSAFE_PublicKey jSAFE_PublicKey) throws CertificateException {
        if (jSAFE_PublicKey == null) {
            throw new CertificateException("Public key is null.");
        }
        this.clearSignature();
        try {
            String string = null;
            string = this.signatureAlgorithmFormat == 3 && jSAFE_PublicKey.getAlgorithm().compareTo("DSA") == 0 ? "DSAPublicKeyX957BER" : jSAFE_PublicKey.getAlgorithm() + "PublicKeyBER";
            byte[][] byArray = jSAFE_PublicKey.getKeyData(string);
            this.subjectPublicKeyInfo = byArray[0];
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            throw new CertificateException("Could not read the public key.");
        }
    }

    public void setSubjectPublicKey(byte[] byArray, int n2) throws CertificateException {
        if (byArray == null) {
            throw new CertificateException("Public key encoding is null.");
        }
        this.clearSignature();
        JSAFE_PublicKey jSAFE_PublicKey = null;
        try {
            jSAFE_PublicKey = JSAFE_PublicKey.getInstance(byArray, n2, "Java");
            this.setSubjectPublicKey(jSAFE_PublicKey);
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            throw new CertificateException("Could not read the public key.");
        }
        finally {
            if (jSAFE_PublicKey != null) {
                jSAFE_PublicKey.clearSensitiveData();
            }
        }
    }

    public JSAFE_PublicKey getSubjectPublicKey(String string) throws CertificateException {
        if (string == null) {
            throw new CertificateException("Device is null.");
        }
        if (this.subjectPublicKeyInfo == null) {
            throw new CertificateException("Object not set with public key.");
        }
        try {
            return JSAFE_PublicKey.getInstance(this.subjectPublicKeyInfo, 0, string);
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            throw new CertificateException("Cannot retrieve the public key: " + jSAFE_Exception.getMessage());
        }
    }

    public byte[] getSubjectPublicKeyBER() throws CertificateException {
        if (this.subjectPublicKeyInfo == null) {
            throw new CertificateException("Object not set with public key.");
        }
        return (byte[])this.subjectPublicKeyInfo.clone();
    }

    public byte[] getUniqueID() {
        try {
            JSAFE_PublicKey jSAFE_PublicKey = this.getSubjectPublicKey(this.theDevice);
            byte[][] byArray = jSAFE_PublicKey.getKeyData();
            JSAFE_MessageDigest jSAFE_MessageDigest = JSAFE_MessageDigest.getInstance("MD5", this.theDevice);
            jSAFE_MessageDigest.digestInit();
            for (int i2 = 0; i2 < byArray.length; ++i2) {
                jSAFE_MessageDigest.digestUpdate(byArray[i2], 0, byArray[i2].length);
            }
            return jSAFE_MessageDigest.digestFinal();
        }
        catch (JSAFE_Exception jSAFE_Exception) {
        }
        catch (CertificateException certificateException) {
            // empty catch block
        }
        return null;
    }

    public abstract void signCertificate(String var1, String var2, JSAFE_PrivateKey var3, SecureRandom var4) throws CertificateException;

    public void signCertificate(byte[] byArray, int n2, String string, JSAFE_PrivateKey jSAFE_PrivateKey, SecureRandom secureRandom) throws CertificateException {
        if (byArray == null || string == null || jSAFE_PrivateKey == null) {
            throw new CertificateException("Specified values are null.");
        }
        try {
            int n3 = 1 + ASN1Lengths.determineLengthLen(byArray, n2 + 1) + ASN1Lengths.determineLength(byArray, n2 + 1);
            String string2 = OIDList.getTrans(byArray, n2, n3, 1);
            this.signCertificate(string2, string, jSAFE_PrivateKey, secureRandom);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CertificateException("Cannot sign cert:" + aSN_Exception.getMessage());
        }
    }

    public abstract boolean verifyCertificateSignature(String var1, JSAFE_PublicKey var2, SecureRandom var3) throws CertificateException;

    public boolean verifyCertificateSignature(String string, byte[] byArray, int n2, SecureRandom secureRandom) throws CertificateException {
        if (string == null || byArray == null) {
            throw new CertificateException("Specified values are null.");
        }
        try {
            JSAFE_PublicKey jSAFE_PublicKey = JSAFE_PublicKey.getInstance(byArray, n2, string);
            return this.verifyCertificateSignature(string, jSAFE_PublicKey, secureRandom);
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            throw new CertificateException("Cannot verify: " + jSAFE_Exception.getMessage());
        }
    }

    public boolean verifyCertificateSignature(String string, Certificate certificate, SecureRandom secureRandom) throws CertificateException {
        if (string == null || certificate == null) {
            throw new CertificateException("Specified values are null.");
        }
        JSAFE_PublicKey jSAFE_PublicKey = certificate.getSubjectPublicKey(string);
        return this.verifyCertificateSignature(string, jSAFE_PublicKey, secureRandom);
    }

    protected byte[] performSignature(String string, String string2, JSAFE_PrivateKey jSAFE_PrivateKey, SecureRandom secureRandom, byte[] byArray, int n2, int n3) throws CertificateException {
        if (string == null || string2 == null || jSAFE_PrivateKey == null || byArray == null) {
            throw new CertificateException("Specified values are null.");
        }
        JSAFE_Signature jSAFE_Signature = null;
        try {
            jSAFE_Signature = JSAFE_Signature.getInstance(string, string2);
            if (this.a == null) {
                jSAFE_Signature.signInit(jSAFE_PrivateKey, null, secureRandom, null);
            } else {
                jSAFE_Signature.signInit(jSAFE_PrivateKey, null, secureRandom, this.a.getPKCS11Sessions());
            }
            jSAFE_Signature.signUpdate(byArray, n2, n3);
            byte[] byArray2 = jSAFE_Signature.signFinal();
            return byArray2;
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            throw new CertificateException("Could not sign the certificate: " + jSAFE_Exception.getMessage());
        }
        finally {
            if (jSAFE_Signature != null) {
                jSAFE_Signature.clearSensitiveData();
            }
        }
    }

    protected boolean performSignatureVerification(String string, JSAFE_PublicKey jSAFE_PublicKey, SecureRandom secureRandom, byte[] byArray, int n2, int n3, byte[] byArray2, int n4, int n5) throws CertificateException {
        if (string == null || jSAFE_PublicKey == null || byArray == null || byArray2 == null) {
            throw new CertificateException("Specified values are null.");
        }
        JSAFE_Signature jSAFE_Signature = null;
        try {
            jSAFE_Signature = JSAFE_Signature.getInstance(this.signatureAlgorithmBER, 0, string);
            if (this.a == null) {
                jSAFE_Signature.verifyInit(jSAFE_PublicKey, null, secureRandom, null);
            } else {
                jSAFE_Signature.verifyInit(jSAFE_PublicKey, null, secureRandom, this.a.getPKCS11Sessions());
            }
            jSAFE_Signature.verifyUpdate(byArray, n2, n3);
            boolean bl2 = jSAFE_Signature.verifyFinal(byArray2, n4, n5);
            return bl2;
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            throw new CertificateException("Could not verify the certificate: " + jSAFE_Exception.getMessage());
        }
        finally {
            if (jSAFE_Signature != null) {
                jSAFE_Signature.clearSensitiveData();
            }
        }
    }

    protected void clearSignature() {
        this.signature = null;
        this.theDevice = null;
        this.theDeviceList = null;
    }

    protected void clearComponents() {
        this.clearSignature();
        this.signatureAlgorithmBER = null;
        this.subjectPublicKeyInfo = null;
    }
}

