/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.attributes;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.PrintStringContainer;
import com.rsa.asn1.SetContainer;
import com.rsa.certj.cert.AttributeException;
import com.rsa.certj.cert.attributes.X501Attribute;
import java.io.Serializable;

public class CountryOfResidence
extends X501Attribute
implements Cloneable,
Serializable {
    private String a = new String();
    ASN1Template b;

    public CountryOfResidence() {
        super(22, "countryOfResidence");
    }

    public CountryOfResidence(String string) throws AttributeException {
        this();
        this.setCountry(string);
    }

    protected void decodeValue(byte[] byArray, int n2) throws AttributeException {
        if (byArray == null) {
            throw new AttributeException("Encoding is null.");
        }
        this.reset();
        try {
            SetContainer setContainer = new SetContainer(0);
            EndContainer endContainer = new EndContainer();
            PrintStringContainer printStringContainer = new PrintStringContainer(0);
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{setContainer, printStringContainer, endContainer};
            ASN1.berDecode(byArray, n2, aSN1ContainerArray);
            this.a = printStringContainer.getValueAsString();
        }
        catch (ASN_Exception aSN_Exception) {
            throw new AttributeException("Could not BER decode CountryOfResidence.");
        }
    }

    public void setCountry(String string) throws AttributeException {
        if (string != null) {
            if (string.length() != 2) {
                throw new AttributeException("Country of Residence should be 2 characters long.");
            }
            this.reset();
            this.a = string;
        }
    }

    public String getCountry() {
        if (this.a == null) {
            return null;
        }
        return this.a;
    }

    protected int derEncodeValueInit() {
        this.b = null;
        if (this.a == null) {
            return 0;
        }
        try {
            SetContainer setContainer = new SetContainer(0, true, 0);
            PrintStringContainer printStringContainer = new PrintStringContainer(0, true, 0, this.a, 2, 2);
            EndContainer endContainer = new EndContainer();
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{setContainer, printStringContainer, endContainer};
            this.b = new ASN1Template(aSN1ContainerArray);
            return this.b.derEncodeInit();
        }
        catch (ASN_Exception aSN_Exception) {
            return 0;
        }
    }

    protected int derEncodeValue(byte[] byArray, int n2) {
        if (byArray == null) {
            return 0;
        }
        if (this.b == null && this.derEncodeValueInit() == 0) {
            return 0;
        }
        int n3 = 0;
        try {
            n3 = this.b.derEncode(byArray, n2);
            this.asn1Template = null;
            return n3;
        }
        catch (ASN_Exception aSN_Exception) {
            this.asn1Template = null;
            return 0;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        CountryOfResidence countryOfResidence = new CountryOfResidence();
        if (this.a != null) {
            countryOfResidence.a = this.a;
        }
        super.copyValues(countryOfResidence);
        return countryOfResidence;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof CountryOfResidence)) {
            return false;
        }
        CountryOfResidence countryOfResidence = (CountryOfResidence)object;
        return this.a.equalsIgnoreCase(countryOfResidence.a);
    }

    protected void reset() {
        super.reset();
        this.a = null;
        this.b = null;
    }
}

