/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.crmf;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Lengths;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.ChoiceContainer;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.OfContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.certj.CertJ;
import com.rsa.certj.crmf.CRMFException;
import com.rsa.certj.crmf.CertRequest;
import com.rsa.certj.crmf.CertTemplate;
import com.rsa.certj.crmf.ProofOfPossession;
import com.rsa.certj.crmf.RegInfo;
import com.rsa.certj.spi.path.CertPathCtx;
import com.rsa.jsafe.JSAFE_PrivateKey;
import com.rsa.jsafe.JSAFE_PublicKey;
import java.io.Serializable;
import java.util.Vector;

public class CertReqMessages
implements Cloneable,
Serializable {
    private Vector[] a = this.a(3);
    private int b;
    private ASN1Template c = null;
    private CertPathCtx d;
    private CertJ e;
    private JSAFE_PublicKey f = null;
    private JSAFE_PrivateKey g = null;

    public CertReqMessages() {
    }

    public CertReqMessages(CertRequest certRequest, ProofOfPossession proofOfPossession, RegInfo regInfo) throws CRMFException {
        this.addCertReqMsg(certRequest, proofOfPossession, regInfo);
    }

    public void addCertReqMsg(CertRequest certRequest, ProofOfPossession proofOfPossession, RegInfo regInfo) throws CRMFException {
        if (certRequest == null) {
            throw new CRMFException("Cert Request is NULL.");
        }
        this.a[0].addElement(certRequest);
        if (proofOfPossession != null) {
            this.a[1].addElement(proofOfPossession);
        } else {
            this.a[1].addElement(null);
        }
        if (regInfo != null) {
            this.a[2].addElement(regInfo);
        } else {
            this.a[2].addElement(null);
        }
    }

    public void decodeCertReqMessages(byte[] byArray, int n2, int n3) throws CRMFException {
        if (byArray == null) {
            throw new CRMFException("CertReqMessages Encoding is null.");
        }
        this.b = n3;
        try {
            OfContainer ofContainer = new OfContainer(n3, 12288, new EncodedContainer(12288));
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{ofContainer};
            ASN1.berDecode(byArray, n2, aSN1ContainerArray);
            int n4 = ofContainer.getContainerCount();
            for (int i2 = 0; i2 < n4; ++i2) {
                ProofOfPossession proofOfPossession;
                ASN1Container aSN1Container = ofContainer.containerAt(i2);
                SequenceContainer sequenceContainer = new SequenceContainer(0);
                EndContainer endContainer = new EndContainer();
                EncodedContainer encodedContainer = new EncodedContainer(12288);
                ChoiceContainer choiceContainer = new ChoiceContainer(65536);
                EncodedContainer encodedContainer2 = new EncodedContainer(8455424);
                EncodedContainer encodedContainer3 = new EncodedContainer(8466433);
                EncodedContainer encodedContainer4 = new EncodedContainer(10616578);
                EncodedContainer encodedContainer5 = new EncodedContainer(10616579);
                EncodedContainer encodedContainer6 = new EncodedContainer(77824);
                ASN1Container[] aSN1ContainerArray2 = new ASN1Container[]{sequenceContainer, encodedContainer, choiceContainer, encodedContainer2, encodedContainer3, encodedContainer4, encodedContainer5, endContainer, encodedContainer6, endContainer};
                ASN1.berDecode(aSN1Container.data, aSN1Container.dataOffset, aSN1ContainerArray2);
                CertRequest certRequest = new CertRequest();
                certRequest.setEnvironment(this.e, this.d, this.f, this.g);
                certRequest.decodeCertRequest(encodedContainer.data, encodedContainer.dataOffset, 0);
                this.a[0].addElement(certRequest);
                if (encodedContainer2.dataPresent) {
                    proofOfPossession = new ProofOfPossession(0);
                    proofOfPossession.decodeProofOfPossession(encodedContainer2.data, encodedContainer2.dataOffset, 65536);
                    this.a[1].addElement(proofOfPossession);
                } else if (encodedContainer3.dataPresent) {
                    proofOfPossession = new ProofOfPossession(1);
                    CertTemplate certTemplate = certRequest.getCertTemplate();
                    if (certTemplate == null) {
                        throw new CRMFException("Invalid CertRequest: CertTemplate is missing.");
                    }
                    if (certTemplate.getSubjectName() != null && certTemplate.getSubjectPublicKey() != null) {
                        proofOfPossession.setCertRequest(certRequest);
                    }
                    proofOfPossession.decodeProofOfPossession(encodedContainer3.data, encodedContainer3.dataOffset, 65536);
                    this.a[1].addElement(proofOfPossession);
                } else if (encodedContainer4.dataPresent) {
                    proofOfPossession = new ProofOfPossession(2);
                    proofOfPossession.setEnvironment(this.e, this.f, this.g);
                    proofOfPossession.decodeProofOfPossession(encodedContainer4.data, encodedContainer4.dataOffset, 65536);
                    this.a[1].addElement(proofOfPossession);
                } else if (encodedContainer5.dataPresent) {
                    proofOfPossession = new ProofOfPossession();
                    proofOfPossession.setEnvironment(this.e, this.f, this.g);
                    proofOfPossession.decodeProofOfPossession(encodedContainer5.data, encodedContainer5.dataOffset, 65536);
                    this.a[1].addElement(proofOfPossession);
                } else {
                    this.a[1].addElement(null);
                }
                if (encodedContainer6.dataPresent) {
                    this.a[2].addElement(new RegInfo(encodedContainer6.data, encodedContainer6.dataOffset, 0));
                    continue;
                }
                this.a[2].addElement(null);
            }
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CRMFException("Could not BER decode the cert request messages. " + aSN_Exception.getMessage());
        }
    }

    private Vector[] a(int n2) {
        Vector[] vectorArray = new Vector[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            vectorArray[i2] = new Vector();
        }
        return vectorArray;
    }

    public void setEnvironment(CertJ certJ, CertPathCtx certPathCtx, JSAFE_PublicKey jSAFE_PublicKey, JSAFE_PrivateKey jSAFE_PrivateKey) {
        this.e = certJ;
        this.d = certPathCtx;
        if (jSAFE_PublicKey != null) {
            this.f = jSAFE_PublicKey;
        }
        if (jSAFE_PrivateKey != null) {
            this.g = jSAFE_PrivateKey;
        }
    }

    public CertRequest getCertRequest(int n2) throws CRMFException {
        if (n2 < this.a[0].size()) {
            if (this.a[0].elementAt(n2) == null) {
                return null;
            }
            return (CertRequest)this.a[0].elementAt(n2);
        }
        throw new CRMFException("Invalid index for CertRequest.");
    }

    public ProofOfPossession getPOP(int n2) throws CRMFException {
        if (n2 < this.a[1].size()) {
            if (this.a[1].elementAt(n2) == null) {
                return null;
            }
            return (ProofOfPossession)this.a[1].elementAt(n2);
        }
        throw new CRMFException("Invalid index for ProofOfPossession.");
    }

    public RegInfo getRegInfo(int n2) throws CRMFException {
        if (n2 < this.a[2].size()) {
            if (this.a[2].elementAt(n2) == null) {
                return null;
            }
            return (RegInfo)this.a[2].elementAt(n2);
        }
        throw new CRMFException("Invalid index for RegInfo.");
    }

    public int getCertReqMsgCount() {
        return this.a[0].size();
    }

    public static int getNextBEROffset(byte[] byArray, int n2) throws CRMFException {
        if (byArray == null) {
            throw new CRMFException("CertReqMessages Encoding is null.");
        }
        if (byArray[n2] == 0 && byArray[n2 + 1] == 0) {
            return n2 + 2;
        }
        try {
            return n2 + 1 + ASN1Lengths.determineLengthLen(byArray, n2 + 1) + ASN1Lengths.determineLength(byArray, n2 + 1);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CRMFException("Unable to determine length of the BER" + aSN_Exception.getMessage());
        }
    }

    public int getDERLen(int n2) throws CRMFException {
        return this.b(n2);
    }

    public int getDEREncoding(byte[] byArray, int n2, int n3) throws CRMFException {
        if (byArray == null) {
            throw new CRMFException("Specified CertReqMessages array is null.");
        }
        int n4 = 0;
        try {
            if (this.c == null || this.b != n3) {
                this.getDERLen(n3);
            }
            n4 = this.c.derEncode(byArray, n2);
            this.c = null;
        }
        catch (ASN_Exception aSN_Exception) {
            this.c = null;
            throw new CRMFException("Unable to encode CertReqMessages." + aSN_Exception.getMessage());
        }
        return n4;
    }

    private int b(int n2) throws CRMFException {
        this.b = n2;
        Vector<OfContainer> vector = new Vector<OfContainer>();
        try {
            OfContainer ofContainer = new OfContainer(n2, true, 0, 12288, new EncodedContainer(12288));
            vector.addElement(ofContainer);
            int n3 = this.a[0].size();
            for (int i2 = 0; i2 < n3; ++i2) {
                int n4 = ((CertRequest)this.a[0].elementAt(i2)).getDERLen(0);
                byte[] byArray = new byte[n4];
                n4 = ((CertRequest)this.a[0].elementAt(i2)).getDEREncoding(byArray, 0, 0);
                boolean bl2 = false;
                int n5 = 0;
                byte[] byArray2 = null;
                int n6 = -1;
                if (this.a[1].elementAt(i2) != null) {
                    bl2 = true;
                    n5 = ((ProofOfPossession)this.a[1].elementAt(i2)).getDERLen(65536);
                    byArray2 = new byte[n5];
                    n5 = ((ProofOfPossession)this.a[1].elementAt(i2)).getDEREncoding(byArray2, 0, 65536);
                    n6 = ((ProofOfPossession)this.a[1].elementAt(i2)).getPOPType();
                }
                boolean bl3 = false;
                int n7 = 0;
                byte[] byArray3 = null;
                if (this.a[2].elementAt(i2) != null) {
                    bl3 = true;
                    n7 = ((RegInfo)this.a[2].elementAt(i2)).getDERLen(0);
                    byArray3 = new byte[n7];
                    n7 = ((RegInfo)this.a[2].elementAt(i2)).getDEREncoding(byArray3, 0, 0);
                }
                SequenceContainer sequenceContainer = new SequenceContainer(0, true, 0);
                EndContainer endContainer = new EndContainer();
                EncodedContainer encodedContainer = new EncodedContainer(12288, true, 0, byArray, 0, n4);
                EncodedContainer encodedContainer2 = null;
                encodedContainer2 = n6 == 0 ? new EncodedContainer(0x800500, bl2, 0, byArray2, 0, n5) : (n6 == 1 ? new EncodedContainer(8400897, bl2, 0, byArray2, 0, n5) : (n6 == 2 ? new EncodedContainer(10498050, bl2, 0, byArray2, 0, n5) : (n6 == 3 ? new EncodedContainer(0xA03003, bl2, 0, byArray2, 0, n5) : new EncodedContainer(65536, false, 0, null, 0, 0))));
                EncodedContainer encodedContainer3 = new EncodedContainer(77824, bl3, 0, byArray3, 0, n7);
                ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, encodedContainer, encodedContainer2, encodedContainer3, endContainer};
                this.c = new ASN1Template(aSN1ContainerArray);
                int n8 = this.c.derEncodeInit();
                byte[] byArray4 = new byte[n8];
                n8 = this.c.derEncode(byArray4, 0);
                EncodedContainer encodedContainer4 = new EncodedContainer(0, true, 0, byArray4, 0, n8);
                ofContainer.addContainer(encodedContainer4);
            }
            Object[] objectArray = new ASN1Container[vector.size()];
            vector.copyInto(objectArray);
            this.c = new ASN1Template((ASN1Container[])objectArray);
            return this.c.derEncodeInit();
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CRMFException(aSN_Exception.getMessage());
        }
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof CertReqMessages)) {
            return false;
        }
        CertReqMessages certReqMessages = (CertReqMessages)object;
        int n2 = this.a.length;
        int n3 = certReqMessages.a.length;
        if (n2 != n3) {
            return false;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            int n4;
            int n5 = this.a[i2].size();
            if (n5 != (n4 = certReqMessages.a[i2].size())) {
                return false;
            }
            for (int i3 = 0; i3 < n5; ++i3) {
                if (this.a[i2].elementAt(i3) == null) {
                    if (certReqMessages.a[i2].elementAt(i3) == null) continue;
                    return false;
                }
                if (certReqMessages.a[i2].elementAt(i3) == null) {
                    return false;
                }
                if (this.a[i2].elementAt(i3).equals(certReqMessages.a[i2].elementAt(i3))) continue;
                return false;
            }
        }
        return true;
    }

    public Object clone() throws CloneNotSupportedException {
        CertReqMessages certReqMessages = new CertReqMessages();
        certReqMessages.setEnvironment(this.e, this.d, this.f, this.g);
        for (int i2 = 0; i2 < this.a.length; ++i2) {
            for (int i3 = 0; i3 < this.a[i2].size(); ++i3) {
                certReqMessages.a[i2].addElement(this.a[i2].elementAt(i3));
            }
        }
        certReqMessages.b = this.b;
        try {
            if (this.c != null) {
                certReqMessages.b(this.b);
            }
        }
        catch (CRMFException cRMFException) {
            throw new CloneNotSupportedException(cRMFException.getMessage());
        }
        return certReqMessages;
    }
}

