/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.crmf;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.BooleanContainer;
import com.rsa.asn1.ChoiceContainer;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.OctetStringContainer;
import com.rsa.certj.CertJUtils;
import com.rsa.certj.crmf.CRMFException;
import com.rsa.certj.crmf.Control;
import com.rsa.certj.crmf.EncryptedKey;
import java.io.Serializable;

public class PKIArchiveOptions
extends Control
implements Cloneable,
Serializable {
    private EncryptedKey a = null;
    private byte[] b = null;
    private boolean c = false;
    ASN1Template d;
    private int e = 0;

    public PKIArchiveOptions() {
        this.controlTypeFlag = 3;
        ((Control)this).a = new byte[Control.OID_LIST[3].length];
        System.arraycopy(Control.OID_LIST[3], 0, ((Control)this).a, 0, ((Control)this).a.length);
        this.controlTypeString = "PKIArchiveOptions";
    }

    protected void decodeValue(byte[] byArray, int n2) throws CRMFException {
        if (byArray == null) {
            throw new CRMFException("PKIArchiveOptions Encoding is null.");
        }
        try {
            ChoiceContainer choiceContainer = new ChoiceContainer(0);
            EndContainer endContainer = new EndContainer();
            EncodedContainer encodedContainer = new EncodedContainer(0xA0FF00);
            OctetStringContainer octetStringContainer = new OctetStringContainer(0x800001);
            BooleanContainer booleanContainer = new BooleanContainer(0x800002);
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{choiceContainer, encodedContainer, octetStringContainer, booleanContainer, endContainer};
            ASN1.berDecode(byArray, n2, aSN1ContainerArray);
            if (encodedContainer.dataPresent) {
                this.a = new EncryptedKey(Control.theCertJ, Control.theCertPathCtx, this.pubKey, this.privKey);
                this.a.decodeEncryptedKey(encodedContainer.data, encodedContainer.dataOffset, 0xA00000);
            } else if (octetStringContainer.dataPresent) {
                this.b = new byte[octetStringContainer.dataLen];
                System.arraycopy(octetStringContainer.data, octetStringContainer.dataOffset, this.b, 0, octetStringContainer.dataLen);
            } else if (booleanContainer.dataPresent) {
                this.c = booleanContainer.value;
            }
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CRMFException("Could not BER decode PKIArchiveOptions." + aSN_Exception.getMessage());
        }
    }

    public void setEncryptedKey(EncryptedKey encryptedKey) throws CRMFException {
        if (encryptedKey == null) {
            throw new CRMFException("Specified EncryptedKey is null.");
        }
        try {
            this.a = (EncryptedKey)encryptedKey.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new CRMFException(cloneNotSupportedException.getMessage());
        }
    }

    public EncryptedKey getEncryptedKey() {
        if (this.a == null) {
            return null;
        }
        try {
            return (EncryptedKey)this.a.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public void setParameters(byte[] byArray, int n2, int n3) throws CRMFException {
        if (byArray == null || n3 <= 0 || n2 < 0) {
            throw new CRMFException("Specified parameters are null.");
        }
        this.b = new byte[n3];
        System.arraycopy(byArray, n2, this.b, 0, n3);
    }

    public byte[] getParameters() {
        if (this.b == null) {
            return null;
        }
        byte[] byArray = new byte[this.b.length];
        System.arraycopy(this.b, 0, byArray, 0, this.b.length);
        return byArray;
    }

    public void setArchivePrivateKey(boolean bl2) {
        this.c = bl2;
    }

    public boolean getArchivePrivateKey() {
        return this.c;
    }

    protected int derEncodeValueInit() throws CRMFException {
        this.d = null;
        try {
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            byte[] byArray = null;
            int n2 = 0;
            int n3 = 0;
            if (this.a != null) {
                n2 = this.a.getDERLen(0xA00000);
                byArray = new byte[n2];
                n2 = this.a.getDEREncoding(byArray, 0, 0xA00000);
                bl2 = true;
            } else if (this.b != null) {
                bl3 = true;
                n3 = this.b.length;
            } else {
                bl4 = true;
            }
            ChoiceContainer choiceContainer = new ChoiceContainer(0, 0);
            EndContainer endContainer = new EndContainer();
            EncodedContainer encodedContainer = new EncodedContainer(0xA00000, bl2, 0, byArray, 0, n2);
            OctetStringContainer octetStringContainer = new OctetStringContainer(0x800001, bl3, 0, this.b, 0, n3);
            BooleanContainer booleanContainer = new BooleanContainer(0x800002, bl4, 0, this.c);
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{choiceContainer, encodedContainer, octetStringContainer, booleanContainer, endContainer};
            this.d = new ASN1Template(aSN1ContainerArray);
            return this.d.derEncodeInit();
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CRMFException("Cannot encode PKIArchiveOptions control. " + aSN_Exception.getMessage());
        }
    }

    protected int derEncodeValue(byte[] byArray, int n2) throws CRMFException {
        if (byArray == null) {
            throw new CRMFException("Passed in array is null in PKIArchiveOptions control.");
        }
        if (this.d == null && this.derEncodeValueInit() == 0) {
            throw new CRMFException("Cannot encode PKIArchiveOptions control.");
        }
        int n3 = 0;
        try {
            n3 = this.d.derEncode(byArray, n2);
            this.asn1Template = null;
            return n3;
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CRMFException("Cannot encode PKIArchiveOptions control." + aSN_Exception.getMessage());
        }
    }

    public Object clone() throws CloneNotSupportedException {
        PKIArchiveOptions pKIArchiveOptions = new PKIArchiveOptions();
        try {
            if (Control.theCertJ != null) {
                pKIArchiveOptions.setEnvironment(Control.theCertJ, Control.theCertPathCtx, this.pubKey, this.privKey);
            }
        }
        catch (CRMFException cRMFException) {
            throw new CloneNotSupportedException(cRMFException.getMessage());
        }
        if (this.a != null) {
            pKIArchiveOptions.a = (EncryptedKey)this.a.clone();
        }
        if (this.b != null) {
            pKIArchiveOptions.b = new byte[this.b.length];
            System.arraycopy(this.b, 0, pKIArchiveOptions.b, 0, this.b.length);
        }
        pKIArchiveOptions.c = this.c;
        pKIArchiveOptions.e = this.e;
        super.copyValues(pKIArchiveOptions);
        return pKIArchiveOptions;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof PKIArchiveOptions)) {
            return false;
        }
        PKIArchiveOptions pKIArchiveOptions = (PKIArchiveOptions)object;
        if (pKIArchiveOptions.c != this.c) {
            return false;
        }
        if (this.a != null ? !this.a.equals(pKIArchiveOptions.a) : pKIArchiveOptions.a != null) {
            return false;
        }
        return CertJUtils.byteArraysEqual(this.b, pKIArchiveOptions.b);
    }
}

