/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe;

import com.rsa.jsafe.JA_DESKey;
import com.rsa.jsafe.JSAFE_InvalidKeyException;
import com.rsa.jsafe.JSAFE_InvalidParameterException;
import com.rsa.jsafe.JSAFE_InvalidUseException;
import com.rsa.jsafe.JSAFE_Obfuscator;
import com.rsa.jsafe.JSAFE_SecretKey;
import java.io.Serializable;
import java.security.SecureRandom;

public class JA_3DES_EDEKey
extends JSAFE_SecretKey
implements Cloneable,
Serializable {
    private JA_DESKey a;
    private JA_DESKey b;
    private JA_DESKey c;
    private static final int d = 64;
    private static final int e = 192;
    private static final int f = 8;
    private static final int g = 16;
    private static final int h = 24;
    private int i;

    public JA_3DES_EDEKey() {
        super("3DES_EDE", 64, 192);
    }

    public void generateInit(int[] nArray, SecureRandom secureRandom) throws JSAFE_InvalidParameterException, JSAFE_InvalidUseException {
        int[] nArray2 = new int[]{192};
        this.i = 24;
        if (nArray != null) {
            if (nArray.length > 1) {
                throw new JSAFE_InvalidParameterException("Wrong number of parameters: Expected 1 for 3DES key generation");
            }
            switch (nArray[0]) {
                case 56: 
                case 64: {
                    nArray2[0] = 64;
                    this.i = 8;
                    break;
                }
                case 112: 
                case 128: {
                    nArray2[0] = 128;
                    this.i = 16;
                    break;
                }
                case 168: 
                case 192: {
                    this.i = 24;
                    break;
                }
                default: {
                    throw new JSAFE_InvalidParameterException("Incorrect 3DES key length.");
                }
            }
        }
        super.generateInit(nArray2, secureRandom);
    }

    boolean a(byte[] byArray) {
        if (byArray.length != 24 && this.i == 24) {
            return true;
        }
        if (byArray.length != 16 && this.i == 16) {
            return true;
        }
        for (int i2 = 0; i2 < JA_DESKey.a.length; ++i2) {
            int n2;
            for (n2 = 0; n2 < 8 && byArray[n2] == JA_DESKey.a[i2][n2]; ++n2) {
            }
            if (n2 == 8) {
                return true;
            }
            if (this.i >= 16) {
                for (n2 = 0; n2 < 8 && byArray[n2 + 8] == JA_DESKey.a[i2][n2]; ++n2) {
                }
                if (n2 == 8) {
                    return true;
                }
            }
            if (this.i != 24) continue;
            for (n2 = 0; n2 < 8 && byArray[n2 + 16] == JA_DESKey.a[i2][n2]; ++n2) {
            }
            if (n2 != 8) continue;
            return true;
        }
        return false;
    }

    public void generate() throws JSAFE_InvalidParameterException {
        byte[] byArray = null;
        int n2 = (this.k + 7) / 8;
        if (this.k < 0) {
            throw new JSAFE_InvalidParameterException("Cannot generate, object not initialized.");
        }
        byArray = new byte[n2];
        int n3 = 0;
        boolean bl2 = true;
        do {
            if (++n3 > 100) {
                throw new JSAFE_InvalidParameterException("Invalid key length.");
            }
            ((JSAFE_SecretKey)this).e.nextBytes(byArray);
            int n4 = this.k % 8;
            if (n4 == 0) continue;
            n4 = 8 - n4;
            byArray[0] = (byte)((byArray[0] & 0xFF) >>> n4);
        } while (bl2 = this.a(byArray));
        try {
            this.setSecretKeyData(byArray, 0, byArray.length);
        }
        catch (JSAFE_InvalidKeyException jSAFE_InvalidKeyException) {
            throw new JSAFE_InvalidParameterException("Invalid Key Length for Generation.");
        }
        finally {
            JSAFE_Obfuscator.c(byArray);
        }
    }

    int a(int n2) {
        switch (n2) {
            case -1: {
                return 192;
            }
            case 1: {
                return 64;
            }
            case 2: {
                return 128;
            }
            case 3: {
                return 192;
            }
        }
        return -1;
    }

    public void setSecretKeyData(byte[] byArray, int n2, int n3) throws JSAFE_InvalidKeyException {
        if (this.m != null) {
            JSAFE_Obfuscator.b(this.m, this.l);
            this.l = null;
            this.m = null;
        }
        this.m = new byte[24];
        switch (n3) {
            case 8: {
                System.arraycopy(byArray, n2, this.m, 0, n3);
                System.arraycopy(byArray, n2, this.m, n3, n3);
                System.arraycopy(byArray, n2, this.m, n3 * 2, n3);
                break;
            }
            case 16: {
                System.arraycopy(byArray, n2, this.m, 0, n3 / 2);
                System.arraycopy(byArray, n2 + n3 / 2, this.m, n3 / 2, n3 / 2);
                System.arraycopy(byArray, n2, this.m, n3, n3 / 2);
                break;
            }
            case 24: {
                System.arraycopy(byArray, n2, this.m, 0, n3);
                break;
            }
            default: {
                throw new JSAFE_InvalidKeyException("Invalid key length");
            }
        }
        if (this.a == null) {
            this.a = new JA_DESKey();
        }
        if (this.b == null) {
            this.b = new JA_DESKey();
        }
        if (this.c == null) {
            this.c = new JA_DESKey();
        }
        this.a.setSecretKeyData(this.m, 0, 8);
        this.b.setSecretKeyData(this.m, 8, 8);
        this.c.setSecretKeyData(this.m, 16, 8);
        this.l = JSAFE_Obfuscator.b(this.m);
        this.l.c();
    }

    public byte[] getSecretKeyData() {
        byte[] byArray = this.a.getSecretKeyData();
        byte[] byArray2 = this.b.getSecretKeyData();
        byte[] byArray3 = this.c.getSecretKeyData();
        int n2 = byArray.length + byArray2.length + byArray3.length;
        byte[] byArray4 = new byte[n2];
        int n3 = 0;
        System.arraycopy(byArray, 0, byArray4, n3, byArray.length);
        JSAFE_Obfuscator.c(byArray);
        System.arraycopy(byArray2, 0, byArray4, n3 += byArray.length, byArray2.length);
        JSAFE_Obfuscator.c(byArray2);
        System.arraycopy(byArray3, 0, byArray4, n3 += byArray2.length, byArray3.length);
        JSAFE_Obfuscator.c(byArray2);
        n3 += byArray3.length;
        return byArray4;
    }

    public Object clone() throws CloneNotSupportedException {
        JA_3DES_EDEKey jA_3DES_EDEKey = (JA_3DES_EDEKey)super.clone();
        if (this.a != null) {
            jA_3DES_EDEKey.a = (JA_DESKey)this.a.clone();
        }
        if (this.b != null) {
            jA_3DES_EDEKey.b = (JA_DESKey)this.b.clone();
        }
        if (this.c != null) {
            jA_3DES_EDEKey.c = (JA_DESKey)this.c.clone();
        }
        return jA_3DES_EDEKey;
    }

    protected JA_DESKey e() {
        try {
            return (JA_DESKey)this.a.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    protected JA_DESKey f() {
        try {
            return (JA_DESKey)this.b.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    protected JA_DESKey g() {
        try {
            return (JA_DESKey)this.c.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public void clearSensitiveData() {
        super.clearSensitiveData();
        if (this.a != null) {
            this.a.clearSensitiveData();
        }
        if (this.b != null) {
            this.b.clearSensitiveData();
        }
        if (this.c != null) {
            this.c.clearSensitiveData();
        }
        this.c = null;
        this.b = null;
        this.a = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() {
        try {
            this.clearSensitiveData();
        }
        finally {
            super.finalize();
        }
    }
}

