/*
 * Decompiled with CFR 0.152.
 */
package llvm;

import llvm.BasicBlock;
import llvm.Instruction;
import llvm.TerminatorInst;
import llvm.Use;
import llvm.Value;
import llvm.llvmJNI;

public class BranchInst
extends TerminatorInst {
    private long swigCPtr;

    protected BranchInst(long l2, boolean bl2) {
        super(llvmJNI.SWIGBranchInstUpcast(l2), bl2);
        this.swigCPtr = l2;
    }

    protected static long getCPtr(BranchInst branchInst) {
        return branchInst == null ? 0L : branchInst.swigCPtr;
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                llvmJNI.delete_BranchInst(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public static BranchInst Create(BasicBlock basicBlock, Instruction instruction) {
        long l2 = llvmJNI.BranchInst_Create__SWIG_0(BasicBlock.getCPtr(basicBlock), basicBlock, Instruction.getCPtr(instruction), instruction);
        return l2 == 0L ? null : new BranchInst(l2, false);
    }

    public static BranchInst Create(BasicBlock basicBlock) {
        long l2 = llvmJNI.BranchInst_Create__SWIG_1(BasicBlock.getCPtr(basicBlock), basicBlock);
        return l2 == 0L ? null : new BranchInst(l2, false);
    }

    public static BranchInst Create(BasicBlock basicBlock, BasicBlock basicBlock2, Value value, Instruction instruction) {
        long l2 = llvmJNI.BranchInst_Create__SWIG_2(BasicBlock.getCPtr(basicBlock), basicBlock, BasicBlock.getCPtr(basicBlock2), basicBlock2, Value.getCPtr(value), value, Instruction.getCPtr(instruction), instruction);
        return l2 == 0L ? null : new BranchInst(l2, false);
    }

    public static BranchInst Create(BasicBlock basicBlock, BasicBlock basicBlock2, Value value) {
        long l2 = llvmJNI.BranchInst_Create__SWIG_3(BasicBlock.getCPtr(basicBlock), basicBlock, BasicBlock.getCPtr(basicBlock2), basicBlock2, Value.getCPtr(value), value);
        return l2 == 0L ? null : new BranchInst(l2, false);
    }

    public static BranchInst Create(BasicBlock basicBlock, BasicBlock basicBlock2) {
        long l2 = llvmJNI.BranchInst_Create__SWIG_4(BasicBlock.getCPtr(basicBlock), basicBlock, BasicBlock.getCPtr(basicBlock2), basicBlock2);
        return l2 == 0L ? null : new BranchInst(l2, false);
    }

    public static BranchInst Create(BasicBlock basicBlock, BasicBlock basicBlock2, Value value, BasicBlock basicBlock3) {
        long l2 = llvmJNI.BranchInst_Create__SWIG_5(BasicBlock.getCPtr(basicBlock), basicBlock, BasicBlock.getCPtr(basicBlock2), basicBlock2, Value.getCPtr(value), value, BasicBlock.getCPtr(basicBlock3), basicBlock3);
        return l2 == 0L ? null : new BranchInst(l2, false);
    }

    public Value getOperand(long l2) {
        long l3 = llvmJNI.BranchInst_getOperand(this.swigCPtr, this, l2);
        return l3 == 0L ? null : new Value(l3, false);
    }

    public void setOperand(long l2, Value value) {
        llvmJNI.BranchInst_setOperand(this.swigCPtr, this, l2, Value.getCPtr(value), value);
    }

    public Use op_begin() {
        long l2 = llvmJNI.BranchInst_op_begin__SWIG_0(this.swigCPtr, this);
        return l2 == 0L ? null : new Use(l2, false);
    }

    public Use op_end() {
        long l2 = llvmJNI.BranchInst_op_end__SWIG_0(this.swigCPtr, this);
        return l2 == 0L ? null : new Use(l2, false);
    }

    public long getNumOperands() {
        return llvmJNI.BranchInst_getNumOperands(this.swigCPtr, this);
    }

    public boolean isUnconditional() {
        return llvmJNI.BranchInst_isUnconditional(this.swigCPtr, this);
    }

    public boolean isConditional() {
        return llvmJNI.BranchInst_isConditional(this.swigCPtr, this);
    }

    public Value getCondition() {
        long l2 = llvmJNI.BranchInst_getCondition(this.swigCPtr, this);
        return l2 == 0L ? null : new Value(l2, false);
    }

    public void setCondition(Value value) {
        llvmJNI.BranchInst_setCondition(this.swigCPtr, this, Value.getCPtr(value), value);
    }

    public void setUnconditionalDest(BasicBlock basicBlock) {
        llvmJNI.BranchInst_setUnconditionalDest(this.swigCPtr, this, BasicBlock.getCPtr(basicBlock), basicBlock);
    }

    public long getNumSuccessors() {
        return llvmJNI.BranchInst_getNumSuccessors(this.swigCPtr, this);
    }

    public BasicBlock getSuccessor(long l2) {
        long l3 = llvmJNI.BranchInst_getSuccessor(this.swigCPtr, this, l2);
        return l3 == 0L ? null : new BasicBlock(l3, false);
    }

    public void setSuccessor(long l2, BasicBlock basicBlock) {
        llvmJNI.BranchInst_setSuccessor(this.swigCPtr, this, l2, BasicBlock.getCPtr(basicBlock), basicBlock);
    }

    public static boolean classof(BranchInst branchInst) {
        return llvmJNI.BranchInst_classof__SWIG_0(BranchInst.getCPtr(branchInst), branchInst);
    }

    public static boolean classof(Instruction instruction) {
        return llvmJNI.BranchInst_classof__SWIG_1(Instruction.getCPtr(instruction), instruction);
    }

    public static boolean classof(Value value) {
        return llvmJNI.BranchInst_classof__SWIG_2(Value.getCPtr(value), value);
    }

    public static BranchInst dyn_cast(TerminatorInst terminatorInst) {
        long l2 = llvmJNI.BranchInst_dyn_cast(TerminatorInst.getCPtr(terminatorInst), terminatorInst);
        return l2 == 0L ? null : new BranchInst(l2, false);
    }
}

