/*
 * Decompiled with CFR 0.152.
 */
package llvm;

import llvm.BasicBlock;
import llvm.Instruction;
import llvm.Twine;
import llvm.Type;
import llvm.Use;
import llvm.Value;
import llvm.llvmJNI;

public class CmpInst
extends Instruction {
    private long swigCPtr;

    protected CmpInst(long l2, boolean bl2) {
        super(llvmJNI.SWIGCmpInstUpcast(l2), bl2);
        this.swigCPtr = l2;
    }

    protected static long getCPtr(CmpInst cmpInst) {
        return cmpInst == null ? 0L : cmpInst.swigCPtr;
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                llvmJNI.delete_CmpInst(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public static CmpInst Create(Instruction.OtherOps otherOps, int n2, Value value, Value value2, Twine twine, Instruction instruction) {
        long l2 = llvmJNI.CmpInst_Create__SWIG_0(otherOps.swigValue(), n2, Value.getCPtr(value), value, Value.getCPtr(value2), value2, Twine.getCPtr(twine), twine, Instruction.getCPtr(instruction), instruction);
        return l2 == 0L ? null : new CmpInst(l2, false);
    }

    public static CmpInst Create(Instruction.OtherOps otherOps, int n2, Value value, Value value2, Twine twine) {
        long l2 = llvmJNI.CmpInst_Create__SWIG_1(otherOps.swigValue(), n2, Value.getCPtr(value), value, Value.getCPtr(value2), value2, Twine.getCPtr(twine), twine);
        return l2 == 0L ? null : new CmpInst(l2, false);
    }

    public static CmpInst Create(Instruction.OtherOps otherOps, int n2, Value value, Value value2) {
        long l2 = llvmJNI.CmpInst_Create__SWIG_2(otherOps.swigValue(), n2, Value.getCPtr(value), value, Value.getCPtr(value2), value2);
        return l2 == 0L ? null : new CmpInst(l2, false);
    }

    public static CmpInst Create(Instruction.OtherOps otherOps, int n2, Value value, Value value2, Twine twine, BasicBlock basicBlock) {
        long l2 = llvmJNI.CmpInst_Create__SWIG_3(otherOps.swigValue(), n2, Value.getCPtr(value), value, Value.getCPtr(value2), value2, Twine.getCPtr(twine), twine, BasicBlock.getCPtr(basicBlock), basicBlock);
        return l2 == 0L ? null : new CmpInst(l2, false);
    }

    public Instruction.OtherOps getOpcodeEnum() {
        return Instruction.OtherOps.swigToEnum(llvmJNI.CmpInst_getOpcodeEnum(this.swigCPtr, this));
    }

    public Predicate getPredicate() {
        return Predicate.swigToEnum(llvmJNI.CmpInst_getPredicate(this.swigCPtr, this));
    }

    public void setPredicate(Predicate predicate) {
        llvmJNI.CmpInst_setPredicate(this.swigCPtr, this, predicate.swigValue());
    }

    public static boolean isFPPredicate(Predicate predicate) {
        return llvmJNI.CmpInst_isFPPredicate__SWIG_0(predicate.swigValue());
    }

    public static boolean isIntPredicate(Predicate predicate) {
        return llvmJNI.CmpInst_isIntPredicate__SWIG_0(predicate.swigValue());
    }

    public boolean isFPPredicate() {
        return llvmJNI.CmpInst_isFPPredicate__SWIG_1(this.swigCPtr, this);
    }

    public boolean isIntPredicate() {
        return llvmJNI.CmpInst_isIntPredicate__SWIG_1(this.swigCPtr, this);
    }

    public Predicate getInversePredicate() {
        return Predicate.swigToEnum(llvmJNI.CmpInst_getInversePredicate__SWIG_0(this.swigCPtr, this));
    }

    public static Predicate getInversePredicate(Predicate predicate) {
        return Predicate.swigToEnum(llvmJNI.CmpInst_getInversePredicate__SWIG_1(predicate.swigValue()));
    }

    public Predicate getSwappedPredicate() {
        return Predicate.swigToEnum(llvmJNI.CmpInst_getSwappedPredicate__SWIG_0(this.swigCPtr, this));
    }

    public static Predicate getSwappedPredicate(Predicate predicate) {
        return Predicate.swigToEnum(llvmJNI.CmpInst_getSwappedPredicate__SWIG_1(predicate.swigValue()));
    }

    public Value getOperand(long l2) {
        long l3 = llvmJNI.CmpInst_getOperand(this.swigCPtr, this, l2);
        return l3 == 0L ? null : new Value(l3, false);
    }

    public void setOperand(long l2, Value value) {
        llvmJNI.CmpInst_setOperand(this.swigCPtr, this, l2, Value.getCPtr(value), value);
    }

    public Use op_begin() {
        long l2 = llvmJNI.CmpInst_op_begin__SWIG_0(this.swigCPtr, this);
        return l2 == 0L ? null : new Use(l2, false);
    }

    public Use op_end() {
        long l2 = llvmJNI.CmpInst_op_end__SWIG_0(this.swigCPtr, this);
        return l2 == 0L ? null : new Use(l2, false);
    }

    public long getNumOperands() {
        return llvmJNI.CmpInst_getNumOperands(this.swigCPtr, this);
    }

    public void swapOperands() {
        llvmJNI.CmpInst_swapOperands(this.swigCPtr, this);
    }

    public boolean isCommutative() {
        return llvmJNI.CmpInst_isCommutative(this.swigCPtr, this);
    }

    public boolean isEquality() {
        return llvmJNI.CmpInst_isEquality(this.swigCPtr, this);
    }

    public boolean isSigned() {
        return llvmJNI.CmpInst_isSigned__SWIG_0(this.swigCPtr, this);
    }

    public boolean isUnsigned() {
        return llvmJNI.CmpInst_isUnsigned__SWIG_0(this.swigCPtr, this);
    }

    public boolean isTrueWhenEqual() {
        return llvmJNI.CmpInst_isTrueWhenEqual__SWIG_0(this.swigCPtr, this);
    }

    public boolean isFalseWhenEqual() {
        return llvmJNI.CmpInst_isFalseWhenEqual__SWIG_0(this.swigCPtr, this);
    }

    public static boolean isUnsigned(int n2) {
        return llvmJNI.CmpInst_isUnsigned__SWIG_1(n2);
    }

    public static boolean isSigned(int n2) {
        return llvmJNI.CmpInst_isSigned__SWIG_1(n2);
    }

    public static boolean isOrdered(int n2) {
        return llvmJNI.CmpInst_isOrdered(n2);
    }

    public static boolean isUnordered(int n2) {
        return llvmJNI.CmpInst_isUnordered(n2);
    }

    public static boolean isTrueWhenEqual(int n2) {
        return llvmJNI.CmpInst_isTrueWhenEqual__SWIG_1(n2);
    }

    public static boolean isFalseWhenEqual(int n2) {
        return llvmJNI.CmpInst_isFalseWhenEqual__SWIG_1(n2);
    }

    public static boolean classof(CmpInst cmpInst) {
        return llvmJNI.CmpInst_classof__SWIG_0(CmpInst.getCPtr(cmpInst), cmpInst);
    }

    public static boolean classof(Instruction instruction) {
        return llvmJNI.CmpInst_classof__SWIG_1(Instruction.getCPtr(instruction), instruction);
    }

    public static boolean classof(Value value) {
        return llvmJNI.CmpInst_classof__SWIG_2(Value.getCPtr(value), value);
    }

    public static Type makeCmpResultType(Type type) {
        long l2 = llvmJNI.CmpInst_makeCmpResultType(Type.getCPtr(type), type);
        return l2 == 0L ? null : new Type(l2, false);
    }

    public static CmpInst dyn_cast(Instruction instruction) {
        long l2 = llvmJNI.CmpInst_dyn_cast(Instruction.getCPtr(instruction), instruction);
        return l2 == 0L ? null : new CmpInst(l2, false);
    }

    public static final class Predicate {
        public static final Predicate FCMP_FALSE = new Predicate("FCMP_FALSE", llvmJNI.CmpInst_FCMP_FALSE_get());
        public static final Predicate FCMP_OEQ = new Predicate("FCMP_OEQ", llvmJNI.CmpInst_FCMP_OEQ_get());
        public static final Predicate FCMP_OGT = new Predicate("FCMP_OGT", llvmJNI.CmpInst_FCMP_OGT_get());
        public static final Predicate FCMP_OGE = new Predicate("FCMP_OGE", llvmJNI.CmpInst_FCMP_OGE_get());
        public static final Predicate FCMP_OLT = new Predicate("FCMP_OLT", llvmJNI.CmpInst_FCMP_OLT_get());
        public static final Predicate FCMP_OLE = new Predicate("FCMP_OLE", llvmJNI.CmpInst_FCMP_OLE_get());
        public static final Predicate FCMP_ONE = new Predicate("FCMP_ONE", llvmJNI.CmpInst_FCMP_ONE_get());
        public static final Predicate FCMP_ORD = new Predicate("FCMP_ORD", llvmJNI.CmpInst_FCMP_ORD_get());
        public static final Predicate FCMP_UNO = new Predicate("FCMP_UNO", llvmJNI.CmpInst_FCMP_UNO_get());
        public static final Predicate FCMP_UEQ = new Predicate("FCMP_UEQ", llvmJNI.CmpInst_FCMP_UEQ_get());
        public static final Predicate FCMP_UGT = new Predicate("FCMP_UGT", llvmJNI.CmpInst_FCMP_UGT_get());
        public static final Predicate FCMP_UGE = new Predicate("FCMP_UGE", llvmJNI.CmpInst_FCMP_UGE_get());
        public static final Predicate FCMP_ULT = new Predicate("FCMP_ULT", llvmJNI.CmpInst_FCMP_ULT_get());
        public static final Predicate FCMP_ULE = new Predicate("FCMP_ULE", llvmJNI.CmpInst_FCMP_ULE_get());
        public static final Predicate FCMP_UNE = new Predicate("FCMP_UNE", llvmJNI.CmpInst_FCMP_UNE_get());
        public static final Predicate FCMP_TRUE = new Predicate("FCMP_TRUE", llvmJNI.CmpInst_FCMP_TRUE_get());
        public static final Predicate FIRST_FCMP_PREDICATE = new Predicate("FIRST_FCMP_PREDICATE", llvmJNI.CmpInst_FIRST_FCMP_PREDICATE_get());
        public static final Predicate LAST_FCMP_PREDICATE = new Predicate("LAST_FCMP_PREDICATE", llvmJNI.CmpInst_LAST_FCMP_PREDICATE_get());
        public static final Predicate BAD_FCMP_PREDICATE = new Predicate("BAD_FCMP_PREDICATE", llvmJNI.CmpInst_BAD_FCMP_PREDICATE_get());
        public static final Predicate ICMP_EQ = new Predicate("ICMP_EQ", llvmJNI.CmpInst_ICMP_EQ_get());
        public static final Predicate ICMP_NE = new Predicate("ICMP_NE", llvmJNI.CmpInst_ICMP_NE_get());
        public static final Predicate ICMP_UGT = new Predicate("ICMP_UGT", llvmJNI.CmpInst_ICMP_UGT_get());
        public static final Predicate ICMP_UGE = new Predicate("ICMP_UGE", llvmJNI.CmpInst_ICMP_UGE_get());
        public static final Predicate ICMP_ULT = new Predicate("ICMP_ULT", llvmJNI.CmpInst_ICMP_ULT_get());
        public static final Predicate ICMP_ULE = new Predicate("ICMP_ULE", llvmJNI.CmpInst_ICMP_ULE_get());
        public static final Predicate ICMP_SGT = new Predicate("ICMP_SGT", llvmJNI.CmpInst_ICMP_SGT_get());
        public static final Predicate ICMP_SGE = new Predicate("ICMP_SGE", llvmJNI.CmpInst_ICMP_SGE_get());
        public static final Predicate ICMP_SLT = new Predicate("ICMP_SLT", llvmJNI.CmpInst_ICMP_SLT_get());
        public static final Predicate ICMP_SLE = new Predicate("ICMP_SLE", llvmJNI.CmpInst_ICMP_SLE_get());
        public static final Predicate FIRST_ICMP_PREDICATE = new Predicate("FIRST_ICMP_PREDICATE", llvmJNI.CmpInst_FIRST_ICMP_PREDICATE_get());
        public static final Predicate LAST_ICMP_PREDICATE = new Predicate("LAST_ICMP_PREDICATE", llvmJNI.CmpInst_LAST_ICMP_PREDICATE_get());
        public static final Predicate BAD_ICMP_PREDICATE = new Predicate("BAD_ICMP_PREDICATE", llvmJNI.CmpInst_BAD_ICMP_PREDICATE_get());
        private static Predicate[] swigValues = new Predicate[]{FCMP_FALSE, FCMP_OEQ, FCMP_OGT, FCMP_OGE, FCMP_OLT, FCMP_OLE, FCMP_ONE, FCMP_ORD, FCMP_UNO, FCMP_UEQ, FCMP_UGT, FCMP_UGE, FCMP_ULT, FCMP_ULE, FCMP_UNE, FCMP_TRUE, FIRST_FCMP_PREDICATE, LAST_FCMP_PREDICATE, BAD_FCMP_PREDICATE, ICMP_EQ, ICMP_NE, ICMP_UGT, ICMP_UGE, ICMP_ULT, ICMP_ULE, ICMP_SGT, ICMP_SGE, ICMP_SLT, ICMP_SLE, FIRST_ICMP_PREDICATE, LAST_ICMP_PREDICATE, BAD_ICMP_PREDICATE};
        private static int swigNext = 0;
        private final int swigValue;
        private final String swigName;

        public final int swigValue() {
            return this.swigValue;
        }

        public String toString() {
            return this.swigName;
        }

        public static Predicate swigToEnum(int n2) {
            if (n2 < swigValues.length && n2 >= 0 && Predicate.swigValues[n2].swigValue == n2) {
                return swigValues[n2];
            }
            for (int i2 = 0; i2 < swigValues.length; ++i2) {
                if (Predicate.swigValues[i2].swigValue != n2) continue;
                return swigValues[i2];
            }
            throw new IllegalArgumentException("No enum " + Predicate.class + " with value " + n2);
        }

        private Predicate(String string) {
            this.swigName = string;
            this.swigValue = swigNext++;
        }

        private Predicate(String string, int n2) {
            this.swigName = string;
            this.swigValue = n2;
            swigNext = n2 + 1;
        }

        private Predicate(String string, Predicate predicate) {
            this.swigName = string;
            this.swigValue = predicate.swigValue;
            swigNext = this.swigValue + 1;
        }
    }
}

