/*
 * Decompiled with CFR 0.152.
 */
package llvm;

import llvm.BasicBlock;
import llvm.LLVMContext;
import llvm.SWIGTYPE_p_llvm__AssemblyAnnotationWriter;
import llvm.SWIGTYPE_p_llvm__StringMapEntryT_llvm__Value_p_t;
import llvm.StringRef;
import llvm.Twine;
import llvm.Type;
import llvm.Use;
import llvm.User;
import llvm.llvmJNI;
import llvm.raw_ostream;

public class Value {
    private long swigCPtr;
    protected boolean swigCMemOwn;

    protected Value(long l2, boolean bl2) {
        this.swigCMemOwn = bl2;
        this.swigCPtr = l2;
    }

    protected static long getCPtr(Value value) {
        return value == null ? 0L : value.swigCPtr;
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                llvmJNI.delete_Value(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public Value(Type type, long l2) {
        this(llvmJNI.new_Value(Type.getCPtr(type), type, l2), true);
    }

    public void dump() {
        llvmJNI.Value_dump(this.swigCPtr, this);
    }

    public void print(raw_ostream raw_ostream2, SWIGTYPE_p_llvm__AssemblyAnnotationWriter sWIGTYPE_p_llvm__AssemblyAnnotationWriter) {
        llvmJNI.Value_print__SWIG_0(this.swigCPtr, this, raw_ostream.getCPtr(raw_ostream2), raw_ostream2, SWIGTYPE_p_llvm__AssemblyAnnotationWriter.getCPtr(sWIGTYPE_p_llvm__AssemblyAnnotationWriter));
    }

    public void print(raw_ostream raw_ostream2) {
        llvmJNI.Value_print__SWIG_1(this.swigCPtr, this, raw_ostream.getCPtr(raw_ostream2), raw_ostream2);
    }

    public Type getType() {
        long l2 = llvmJNI.Value_getType(this.swigCPtr, this);
        return l2 == 0L ? null : new Type(l2, false);
    }

    public LLVMContext getContext() {
        return new LLVMContext(llvmJNI.Value_getContext(this.swigCPtr, this), false);
    }

    public boolean hasName() {
        return llvmJNI.Value_hasName(this.swigCPtr, this);
    }

    public SWIGTYPE_p_llvm__StringMapEntryT_llvm__Value_p_t getValueName() {
        long l2 = llvmJNI.Value_getValueName(this.swigCPtr, this);
        return l2 == 0L ? null : new SWIGTYPE_p_llvm__StringMapEntryT_llvm__Value_p_t(l2, false);
    }

    public StringRef getName() {
        return new StringRef(llvmJNI.Value_getName(this.swigCPtr, this), true);
    }

    public String getNameStr() {
        return llvmJNI.Value_getNameStr(this.swigCPtr, this);
    }

    public void setName(Twine twine) {
        llvmJNI.Value_setName(this.swigCPtr, this, Twine.getCPtr(twine), twine);
    }

    public void takeName(Value value) {
        llvmJNI.Value_takeName(this.swigCPtr, this, Value.getCPtr(value), value);
    }

    public void replaceAllUsesWith(Value value) {
        llvmJNI.Value_replaceAllUsesWith(this.swigCPtr, this, Value.getCPtr(value), value);
    }

    public void uncheckedReplaceAllUsesWith(Value value) {
        llvmJNI.Value_uncheckedReplaceAllUsesWith(this.swigCPtr, this, Value.getCPtr(value), value);
    }

    public boolean use_empty() {
        return llvmJNI.Value_use_empty(this.swigCPtr, this);
    }

    public User use_back() {
        long l2 = llvmJNI.Value_use_back__SWIG_0(this.swigCPtr, this);
        return l2 == 0L ? null : new User(l2, false);
    }

    public boolean hasOneUse() {
        return llvmJNI.Value_hasOneUse(this.swigCPtr, this);
    }

    public boolean hasNUses(long l2) {
        return llvmJNI.Value_hasNUses(this.swigCPtr, this, l2);
    }

    public boolean hasNUsesOrMore(long l2) {
        return llvmJNI.Value_hasNUsesOrMore(this.swigCPtr, this, l2);
    }

    public boolean isUsedInBasicBlock(BasicBlock basicBlock) {
        return llvmJNI.Value_isUsedInBasicBlock(this.swigCPtr, this, BasicBlock.getCPtr(basicBlock), basicBlock);
    }

    public long getNumUses() {
        return llvmJNI.Value_getNumUses(this.swigCPtr, this);
    }

    public void addUse(Use use) {
        llvmJNI.Value_addUse(this.swigCPtr, this, Use.getCPtr(use), use);
    }

    public long getValueID() {
        return llvmJNI.Value_getValueID(this.swigCPtr, this);
    }

    public long getRawSubclassOptionalData() {
        return llvmJNI.Value_getRawSubclassOptionalData(this.swigCPtr, this);
    }

    public boolean hasSameSubclassOptionalData(Value value) {
        return llvmJNI.Value_hasSameSubclassOptionalData(this.swigCPtr, this, Value.getCPtr(value), value);
    }

    public void intersectOptionalDataWith(Value value) {
        llvmJNI.Value_intersectOptionalDataWith(this.swigCPtr, this, Value.getCPtr(value), value);
    }

    public static boolean classof(Value value) {
        return llvmJNI.Value_classof(Value.getCPtr(value), value);
    }

    public Type getRawType() {
        long l2 = llvmJNI.Value_getRawType(this.swigCPtr, this);
        return l2 == 0L ? null : new Type(l2, false);
    }

    public Value stripPointerCasts() {
        long l2 = llvmJNI.Value_stripPointerCasts__SWIG_0(this.swigCPtr, this);
        return l2 == 0L ? null : new Value(l2, false);
    }

    public Value DoPHITranslation(BasicBlock basicBlock, BasicBlock basicBlock2) {
        long l2 = llvmJNI.Value_DoPHITranslation__SWIG_0(this.swigCPtr, this, BasicBlock.getCPtr(basicBlock), basicBlock, BasicBlock.getCPtr(basicBlock2), basicBlock2);
        return l2 == 0L ? null : new Value(l2, false);
    }

    public static final class ValueTy {
        public static final ValueTy ArgumentVal = new ValueTy("ArgumentVal");
        public static final ValueTy BasicBlockVal = new ValueTy("BasicBlockVal");
        public static final ValueTy FunctionVal = new ValueTy("FunctionVal");
        public static final ValueTy GlobalAliasVal = new ValueTy("GlobalAliasVal");
        public static final ValueTy GlobalVariableVal = new ValueTy("GlobalVariableVal");
        public static final ValueTy UndefValueVal = new ValueTy("UndefValueVal");
        public static final ValueTy BlockAddressVal = new ValueTy("BlockAddressVal");
        public static final ValueTy ConstantExprVal = new ValueTy("ConstantExprVal");
        public static final ValueTy ConstantAggregateZeroVal = new ValueTy("ConstantAggregateZeroVal");
        public static final ValueTy ConstantIntVal = new ValueTy("ConstantIntVal");
        public static final ValueTy ConstantFPVal = new ValueTy("ConstantFPVal");
        public static final ValueTy ConstantArrayVal = new ValueTy("ConstantArrayVal");
        public static final ValueTy ConstantStructVal = new ValueTy("ConstantStructVal");
        public static final ValueTy ConstantUnionVal = new ValueTy("ConstantUnionVal");
        public static final ValueTy ConstantVectorVal = new ValueTy("ConstantVectorVal");
        public static final ValueTy ConstantPointerNullVal = new ValueTy("ConstantPointerNullVal");
        public static final ValueTy MDNodeVal = new ValueTy("MDNodeVal");
        public static final ValueTy MDStringVal = new ValueTy("MDStringVal");
        public static final ValueTy NamedMDNodeVal = new ValueTy("NamedMDNodeVal");
        public static final ValueTy InlineAsmVal = new ValueTy("InlineAsmVal");
        public static final ValueTy PseudoSourceValueVal = new ValueTy("PseudoSourceValueVal");
        public static final ValueTy FixedStackPseudoSourceValueVal = new ValueTy("FixedStackPseudoSourceValueVal");
        public static final ValueTy InstructionVal = new ValueTy("InstructionVal");
        public static final ValueTy ConstantFirstVal = new ValueTy("ConstantFirstVal", llvmJNI.Value_ConstantFirstVal_get());
        public static final ValueTy ConstantLastVal = new ValueTy("ConstantLastVal", llvmJNI.Value_ConstantLastVal_get());
        private static ValueTy[] swigValues = new ValueTy[]{ArgumentVal, BasicBlockVal, FunctionVal, GlobalAliasVal, GlobalVariableVal, UndefValueVal, BlockAddressVal, ConstantExprVal, ConstantAggregateZeroVal, ConstantIntVal, ConstantFPVal, ConstantArrayVal, ConstantStructVal, ConstantUnionVal, ConstantVectorVal, ConstantPointerNullVal, MDNodeVal, MDStringVal, NamedMDNodeVal, InlineAsmVal, PseudoSourceValueVal, FixedStackPseudoSourceValueVal, InstructionVal, ConstantFirstVal, ConstantLastVal};
        private static int swigNext = 0;
        private final int swigValue;
        private final String swigName;

        public final int swigValue() {
            return this.swigValue;
        }

        public String toString() {
            return this.swigName;
        }

        public static ValueTy swigToEnum(int n2) {
            if (n2 < swigValues.length && n2 >= 0 && ValueTy.swigValues[n2].swigValue == n2) {
                return swigValues[n2];
            }
            for (int i2 = 0; i2 < swigValues.length; ++i2) {
                if (ValueTy.swigValues[i2].swigValue != n2) continue;
                return swigValues[i2];
            }
            throw new IllegalArgumentException("No enum " + ValueTy.class + " with value " + n2);
        }

        private ValueTy(String string) {
            this.swigName = string;
            this.swigValue = swigNext++;
        }

        private ValueTy(String string, int n2) {
            this.swigName = string;
            this.swigValue = n2;
            swigNext = n2 + 1;
        }

        private ValueTy(String string, ValueTy valueTy) {
            this.swigName = string;
            this.swigValue = valueTy.swigValue;
            swigNext = this.swigValue + 1;
        }
    }
}

