/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantDouble;
import org.apache.bcel.classfile.ConstantFloat;
import org.apache.bcel.classfile.ConstantInteger;
import org.apache.bcel.classfile.ConstantLong;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.ConstantString;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.Utility;
import org.apache.bcel.classfile.Visitor;

public final class ConstantValue
extends Attribute {
    private int constantvalue_index;

    public ConstantValue(ConstantValue c2) {
        this(c2.getNameIndex(), c2.getLength(), c2.getConstantValueIndex(), c2.getConstantPool());
    }

    ConstantValue(int name_index, int length, DataInputStream file, ConstantPool constant_pool) throws IOException {
        this(name_index, length, file.readUnsignedShort(), constant_pool);
    }

    public ConstantValue(int name_index, int length, int constantvalue_index, ConstantPool constant_pool) {
        super((byte)1, name_index, length, constant_pool);
        this.constantvalue_index = constantvalue_index;
    }

    public void accept(Visitor v2) {
        v2.visitConstantValue(this);
    }

    public final void dump(DataOutputStream file) throws IOException {
        super.dump(file);
        file.writeShort(this.constantvalue_index);
    }

    public final int getConstantValueIndex() {
        return this.constantvalue_index;
    }

    public final void setConstantValueIndex(int constantvalue_index) {
        this.constantvalue_index = constantvalue_index;
    }

    public final String toString() {
        String buf;
        Constant c2 = this.constant_pool.getConstant(this.constantvalue_index);
        switch (c2.getTag()) {
            case 5: {
                buf = "" + ((ConstantLong)c2).getBytes();
                break;
            }
            case 4: {
                buf = "" + ((ConstantFloat)c2).getBytes();
                break;
            }
            case 6: {
                buf = "" + ((ConstantDouble)c2).getBytes();
                break;
            }
            case 3: {
                buf = "" + ((ConstantInteger)c2).getBytes();
                break;
            }
            case 8: {
                int i2 = ((ConstantString)c2).getStringIndex();
                c2 = this.constant_pool.getConstant(i2, (byte)1);
                buf = "\"" + Utility.convertString(((ConstantUtf8)c2).getBytes()) + "\"";
                break;
            }
            default: {
                throw new IllegalStateException("Type of ConstValue invalid: " + c2);
            }
        }
        return buf;
    }

    public Attribute copy(ConstantPool _constant_pool) {
        ConstantValue c2 = (ConstantValue)this.clone();
        c2.constant_pool = _constant_pool;
        return c2;
    }
}

