/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.Node;
import org.apache.bcel.classfile.StackMapEntry;
import org.apache.bcel.classfile.Visitor;

public final class StackMap
extends Attribute
implements Node {
    private int map_length;
    private StackMapEntry[] map;

    public StackMap(int name_index, int length, StackMapEntry[] map, ConstantPool constant_pool) {
        super((byte)11, name_index, length, constant_pool);
        this.setStackMap(map);
    }

    StackMap(int name_index, int length, DataInputStream file, ConstantPool constant_pool) throws IOException {
        this(name_index, length, (StackMapEntry[])null, constant_pool);
        this.map_length = file.readUnsignedShort();
        this.map = new StackMapEntry[this.map_length];
        for (int i2 = 0; i2 < this.map_length; ++i2) {
            this.map[i2] = new StackMapEntry(file, constant_pool);
        }
    }

    public final void dump(DataOutputStream file) throws IOException {
        super.dump(file);
        file.writeShort(this.map_length);
        for (int i2 = 0; i2 < this.map_length; ++i2) {
            this.map[i2].dump(file);
        }
    }

    public final StackMapEntry[] getStackMap() {
        return this.map;
    }

    public final void setStackMap(StackMapEntry[] map) {
        this.map = map;
        this.map_length = map == null ? 0 : map.length;
    }

    public final String toString() {
        StringBuffer buf = new StringBuffer("StackMap(");
        for (int i2 = 0; i2 < this.map_length; ++i2) {
            buf.append(this.map[i2].toString());
            if (i2 >= this.map_length - 1) continue;
            buf.append(", ");
        }
        buf.append(')');
        return buf.toString();
    }

    public Attribute copy(ConstantPool _constant_pool) {
        StackMap c2 = (StackMap)this.clone();
        c2.map = new StackMapEntry[this.map_length];
        for (int i2 = 0; i2 < this.map_length; ++i2) {
            c2.map[i2] = this.map[i2].copy();
        }
        c2.constant_pool = _constant_pool;
        return c2;
    }

    public void accept(Visitor v2) {
        v2.visitStackMap(this);
    }

    public final int getMapLength() {
        return this.map_length;
    }
}

