/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.generic;

import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.bcel.generic.ClassGenException;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.LocalVariableInstruction;
import org.apache.bcel.generic.Type;
import org.apache.bcel.generic.Visitor;
import org.apache.bcel.util.ByteSequence;

public class IINC
extends LocalVariableInstruction {
    private boolean wide;
    private int c;

    IINC() {
    }

    public IINC(int n2, int c2) {
        this.opcode = (short)132;
        this.length = (short)3;
        this.setIndex(n2);
        this.setIncrement(c2);
    }

    public void dump(DataOutputStream out) throws IOException {
        if (this.wide) {
            out.writeByte(196);
        }
        out.writeByte(this.opcode);
        if (this.wide) {
            out.writeShort(this.n);
            out.writeShort(this.c);
        } else {
            out.writeByte(this.n);
            out.writeByte(this.c);
        }
    }

    private final void setWide() {
        this.wide = this.n > 255 || Math.abs(this.c) > 127;
        this.length = this.wide ? (short)6 : (short)3;
    }

    protected void initFromFile(ByteSequence bytes, boolean wide) throws IOException {
        this.wide = wide;
        if (wide) {
            this.length = (short)6;
            this.n = bytes.readUnsignedShort();
            this.c = bytes.readShort();
        } else {
            this.length = (short)3;
            this.n = bytes.readUnsignedByte();
            this.c = bytes.readByte();
        }
    }

    public String toString(boolean verbose) {
        return super.toString(verbose) + " " + this.c;
    }

    public final void setIndex(int n2) {
        if (n2 < 0) {
            throw new ClassGenException("Negative index value: " + n2);
        }
        this.n = n2;
        this.setWide();
    }

    public final int getIncrement() {
        return this.c;
    }

    public final void setIncrement(int c2) {
        this.c = c2;
        this.setWide();
    }

    public Type getType(ConstantPoolGen cp) {
        return Type.INT;
    }

    public void accept(Visitor v2) {
        v2.visitLocalVariableInstruction(this);
        v2.visitIINC(this);
    }
}

