/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.verifier;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.verifier.VerificationResult;
import org.apache.bcel.verifier.VerifierFactory;
import org.apache.bcel.verifier.statics.Pass1Verifier;
import org.apache.bcel.verifier.statics.Pass2Verifier;
import org.apache.bcel.verifier.statics.Pass3aVerifier;
import org.apache.bcel.verifier.structurals.Pass3bVerifier;

public class Verifier {
    private final String classname;
    private Pass1Verifier p1v;
    private Pass2Verifier p2v;
    private Map p3avs = new HashMap();
    private Map p3bvs = new HashMap();

    public VerificationResult doPass1() {
        if (this.p1v == null) {
            this.p1v = new Pass1Verifier(this);
        }
        return this.p1v.verify();
    }

    public VerificationResult doPass2() {
        if (this.p2v == null) {
            this.p2v = new Pass2Verifier(this);
        }
        return this.p2v.verify();
    }

    public VerificationResult doPass3a(int method_no) {
        String key = Integer.toString(method_no);
        Pass3aVerifier p3av = (Pass3aVerifier)this.p3avs.get(key);
        if (this.p3avs.get(key) == null) {
            p3av = new Pass3aVerifier(this, method_no);
            this.p3avs.put(key, p3av);
        }
        return p3av.verify();
    }

    public VerificationResult doPass3b(int method_no) {
        String key = Integer.toString(method_no);
        Pass3bVerifier p3bv = (Pass3bVerifier)this.p3bvs.get(key);
        if (this.p3bvs.get(key) == null) {
            p3bv = new Pass3bVerifier(this, method_no);
            this.p3bvs.put(key, p3bv);
        }
        return p3bv.verify();
    }

    Verifier(String fully_qualified_classname) {
        this.classname = fully_qualified_classname;
        this.flush();
    }

    public final String getClassName() {
        return this.classname;
    }

    public void flush() {
        this.p1v = null;
        this.p2v = null;
        this.p3avs.clear();
        this.p3bvs.clear();
    }

    public String[] getMessages() throws ClassNotFoundException {
        int i2;
        ArrayList<String> messages = new ArrayList<String>();
        if (this.p1v != null) {
            String[] p1m = this.p1v.getMessages();
            for (i2 = 0; i2 < p1m.length; ++i2) {
                messages.add("Pass 1: " + p1m[i2]);
            }
        }
        if (this.p2v != null) {
            String[] p2m = this.p2v.getMessages();
            for (i2 = 0; i2 < p2m.length; ++i2) {
                messages.add("Pass 2: " + p2m[i2]);
            }
        }
        Iterator p3as = this.p3avs.values().iterator();
        while (p3as.hasNext()) {
            Pass3aVerifier pv = (Pass3aVerifier)p3as.next();
            String[] p3am = pv.getMessages();
            int meth = pv.getMethodNo();
            for (int i3 = 0; i3 < p3am.length; ++i3) {
                messages.add("Pass 3a, method " + meth + " ('" + Repository.lookupClass(this.classname).getMethods()[meth] + "'): " + p3am[i3]);
            }
        }
        Iterator p3bs = this.p3bvs.values().iterator();
        while (p3bs.hasNext()) {
            Pass3bVerifier pv = (Pass3bVerifier)p3bs.next();
            String[] p3bm = pv.getMessages();
            int meth = pv.getMethodNo();
            for (int i4 = 0; i4 < p3bm.length; ++i4) {
                messages.add("Pass 3b, method " + meth + " ('" + Repository.lookupClass(this.classname).getMethods()[meth] + "'): " + p3bm[i4]);
            }
        }
        String[] ret = new String[messages.size()];
        for (int i5 = 0; i5 < messages.size(); ++i5) {
            ret[i5] = (String)messages.get(i5);
        }
        return ret;
    }

    public static void main(String[] args) {
        System.out.println("JustIce by Enver Haase, (C) 2001-2002.\n<http://bcel.sourceforge.net>\n<http://jakarta.apache.org/bcel>\n");
        for (int k2 = 0; k2 < args.length; ++k2) {
            try {
                int dotclasspos;
                if (args[k2].endsWith(".class") && (dotclasspos = args[k2].lastIndexOf(".class")) != -1) {
                    args[k2] = args[k2].substring(0, dotclasspos);
                }
                args[k2] = args[k2].replace('/', '.');
                System.out.println("Now verifying: " + args[k2] + "\n");
                Verifier v2 = VerifierFactory.getVerifier(args[k2]);
                VerificationResult vr = v2.doPass1();
                System.out.println("Pass 1:\n" + vr);
                vr = v2.doPass2();
                System.out.println("Pass 2:\n" + vr);
                if (vr == VerificationResult.VR_OK) {
                    JavaClass jc = Repository.lookupClass(args[k2]);
                    for (int i2 = 0; i2 < jc.getMethods().length; ++i2) {
                        vr = v2.doPass3a(i2);
                        System.out.println("Pass 3a, method number " + i2 + " ['" + jc.getMethods()[i2] + "']:\n" + vr);
                        vr = v2.doPass3b(i2);
                        System.out.println("Pass 3b, method number " + i2 + " ['" + jc.getMethods()[i2] + "']:\n" + vr);
                    }
                }
                System.out.println("Warnings:");
                String[] warnings = v2.getMessages();
                if (warnings.length == 0) {
                    System.out.println("<none>");
                }
                for (int j2 = 0; j2 < warnings.length; ++j2) {
                    System.out.println(warnings[j2]);
                }
                System.out.println("\n");
                v2.flush();
                Repository.clearCache();
                System.gc();
                continue;
            }
            catch (ClassNotFoundException e2) {
                e2.printStackTrace();
            }
        }
    }
}

