/*
 * Decompiled with CFR 0.152.
 */
package com.inprise.vbroker.compiler.ast;

import com.inprise.vbroker.compiler.ast.EnumNameNode;
import com.inprise.vbroker.compiler.ast.EnumNode;
import com.inprise.vbroker.compiler.ast.FieldNode;
import com.inprise.vbroker.compiler.ast.Node;
import com.inprise.vbroker.compiler.ast.PrimitiveNode;
import com.inprise.vbroker.compiler.ast.Type;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class UnionNode
extends FieldNode
implements Type {
    public static final UnionNode ERROR = new UnionNode();
    public Type _discriminator;
    public Vector _memberLabels = new Vector();
    public int _defaultIndex = -1;
    public boolean _explicitDefault;
    public boolean _implicitDefault;
    public Object _defaultValue;

    public UnionNode() {
        super(11);
    }

    public void addLabel() {
        if (this._defaultIndex != -1) {
            this.error("Comp.AST.duplicateDefaultLabel");
        } else {
            this.addLabel(null);
            this._defaultIndex = this._memberNames.size();
        }
    }

    public void addLabel(Object object) {
        if (this._memberNames.size() > this._memberLabels.size()) {
            this._memberLabels.addElement(new Vector());
        }
        if (this._memberNames.size() == this._memberLabels.size()) {
            this._memberLabels.addElement(new Vector());
        }
        if (object != null) {
            if (this.labelExists(object)) {
                this.error("Comp.AST.duplicateLabel", PrimitiveNode.format(object));
                return;
            }
            if (!this.verifyLabelTypeMatch(object)) {
                return;
            }
            ((Vector)this._memberLabels.elementAt(this._memberLabels.size() - 1)).addElement(object);
        }
    }

    public Object[] allLabels() {
        int n;
        int n2 = 0;
        int n3 = this._memberLabels.size();
        for (int i = 0; i < n3; ++i) {
            Vector vector = (Vector)this._memberLabels.elementAt(i);
            n = vector.size();
            for (int j = 0; j < n; ++j) {
                ++n2;
            }
        }
        Object[] objectArray = new Object[n2];
        int n4 = this._memberLabels.size();
        for (n3 = 0; n3 < n4; ++n3) {
            Vector vector = (Vector)this._memberLabels.elementAt(n3);
            int n5 = vector.size();
            for (n = 0; n < n5; ++n) {
                objectArray[--n2] = vector.elementAt(n);
            }
        }
        return objectArray;
    }

    public boolean badLabel(Object object) {
        this.error("Comp.AST.invalidLabelType", new Object[]{PrimitiveNode.format(object), ((Node)((Object)this._discriminator)).typeName()});
        return false;
    }

    private Object chooseDefaultLabelsValue() {
        Type type = this._discriminator.trueType();
        Node node = (Node)((Object)type);
        Object[] objectArray = this.allLabels();
        if (node._kind == 12) {
            int n;
            EnumNode enumNode = (EnumNode)node;
            Vector vector = enumNode._memberNames;
            int n2 = vector.size();
            Hashtable hashtable = new Hashtable(n2);
            for (n = 0; n < n2; ++n) {
                hashtable.put(vector.elementAt(n), vector.elementAt(n));
            }
            for (n = 0; n < objectArray.length; ++n) {
                hashtable.remove(((EnumNameNode)objectArray[n])._name);
            }
            Enumeration enumeration = hashtable.elements();
            return enumeration.nextElement();
        }
        long l = 0L;
        long l2 = 0L;
        int n = ((PrimitiveNode)node)._pkind;
        switch (n) {
            case 8: {
                l = 0L;
                l2 = 1L;
                break;
            }
            case 9: {
                l = 0L;
                l2 = 255L;
                break;
            }
            case 2: {
                l = -32768L;
                l2 = 32767L;
                break;
            }
            case 4: {
                l = 0L;
                l2 = 65534L;
                break;
            }
            case 3: {
                l = Integer.MIN_VALUE;
                l2 = Integer.MAX_VALUE;
                break;
            }
            case 5: {
                l = 0L;
                l2 = 0xFFFFFFFEL;
                break;
            }
            case 16: {
                l = Long.MIN_VALUE;
                l2 = Long.MAX_VALUE;
                break;
            }
            case 17: {
                l = 0L;
                l2 = 0xFFFFFFFEL;
                break;
            }
            default: {
                this._repository._ER.internalError("unexpected discriminator type in JUnionNode.chooseDefaultLabelsValue");
            }
        }
        block17: for (long i = l; i <= l2; ++i) {
            for (int j = 0; j < objectArray.length; ++j) {
                if (this.integralValue(objectArray[j]) == i) continue block17;
            }
            switch (n) {
                case 9: {
                    return new Character((char)i);
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 16: 
                case 17: {
                    return new Long(i);
                }
                case 8: {
                    return i == (long)0 ? Boolean.FALSE : Boolean.TRUE;
                }
            }
        }
        return Boolean.TRUE;
    }

    protected String createLabel(Object object) {
        if (this._discriminator.kind() == 12) {
            EnumNode enumNode = (EnumNode)this._discriminator;
            return enumNode._repository._mapper.fullName(enumNode, enumNode.toLiteral(object));
        }
        return this._discriminator.toLiteral(object);
    }

    public void defaultValueProcessing() {
        if (this.remainingDomainSpace() == 0L) {
            if (this._defaultIndex >= 0) {
                if (((Vector)this._memberLabels.elementAt(this._defaultIndex)).size() == 0) {
                    this.error("Comp.AST.unreachableDefault", this._fullName);
                } else {
                    this._repository._ER.warn("Comp.AST.spuriousDefault", this._fullName);
                    this._defaultIndex = -1;
                }
            }
        } else {
            this._defaultValue = this.chooseDefaultLabelsValue();
        }
        this._explicitDefault = this._defaultIndex >= 0;
        this._implicitDefault = !this._explicitDefault && this._defaultValue != null;
    }

    public void discriminator(Type type) {
        Node node = (Node)((Object)type.trueType());
        if (node._kind == 13) {
            switch (((PrimitiveNode)node)._pkind) {
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 8: 
                case 9: 
                case 16: 
                case 17: {
                    this._discriminator = (Type)((Object)node);
                    return;
                }
            }
        } else if (node._kind == 12) {
            this._discriminator = (Type)((Object)node);
            return;
        }
        this.error("Comp.AST.invalidSwitchType", node.typeName());
        this._discriminator = node._repository.LONG_TYPE;
    }

    public boolean finish(int n) {
        super.finish(n);
        this.defaultValueProcessing();
        return true;
    }

    private long integralValue(Object object) {
        if (object instanceof Boolean) {
            return object == Boolean.TRUE ? 1 : 0;
        }
        if (object instanceof Long) {
            return (Long)object;
        }
        if (object instanceof Integer) {
            return ((Integer)object).intValue();
        }
        if (object instanceof Short) {
            return ((Short)object).shortValue();
        }
        if (object instanceof Character) {
            return ((Character)object).charValue();
        }
        this._repository._ER.internalError("unexpected Object class in UnionNode.integralValue");
        return 0L;
    }

    public boolean labelExists(Object object) {
        int n = this._memberLabels.size();
        for (int i = 0; i < n; ++i) {
            Vector vector = (Vector)this._memberLabels.elementAt(i);
            int n2 = vector.size();
            for (int j = 0; j < n2; ++j) {
                if (!vector.elementAt(j).equals(object)) continue;
                return true;
            }
        }
        return false;
    }

    public long numRealLabels() {
        long l = 0L;
        int n = this._memberLabels.size();
        for (int i = 0; i < n; ++i) {
            l += (long)((Vector)this._memberLabels.elementAt(i)).size();
        }
        return l;
    }

    public static final boolean numberFits(long l, int n) {
        switch (n) {
            case 2: {
                return l >= -32768L && l <= 32767L;
            }
            case 3: {
                return l >= Integer.MIN_VALUE && l <= Integer.MAX_VALUE;
            }
            case 16: {
                return true;
            }
            case 4: {
                return l >= 0L && l <= 32767L;
            }
            case 5: {
                return l >= 0L && l <= Integer.MAX_VALUE;
            }
            case 17: {
                return l >= 0L && l <= Long.MAX_VALUE;
            }
        }
        return false;
    }

    public long remainingDomainSpace() {
        Node node = (Node)((Object)this._discriminator);
        if (node._kind == 12) {
            return (long)((EnumNode)this._discriminator)._memberNames.size() - this.numRealLabels();
        }
        PrimitiveNode primitiveNode = (PrimitiveNode)node;
        switch (primitiveNode._pkind) {
            case 2: 
            case 4: {
                return 65536L - this.numRealLabels();
            }
            case 3: 
            case 5: {
                return 0x100000000L - this.numRealLabels();
            }
            case 16: 
            case 17: {
                return 0x100000000L - this.numRealLabels();
            }
            case 9: {
                return 256L - this.numRealLabels();
            }
            case 8: {
                return 2L - this.numRealLabels();
            }
        }
        this._repository._ER.internalError("unexpected discriminator type in UnionNode.domainCovered");
        return 0L;
    }

    public boolean verifyLabelTypeMatch(Object object) {
        if (object instanceof Long) {
            if (!(this._discriminator instanceof PrimitiveNode)) {
                return this.badLabel(object);
            }
            int n = ((PrimitiveNode)this._discriminator)._pkind;
            switch (n) {
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 16: 
                case 17: {
                    if (UnionNode.numberFits((Long)object, n)) {
                        return true;
                    }
                    this.error("Comp.AST.numberOutOfRange", new Object[]{PrimitiveNode.format(object), ((Node)((Object)this._discriminator)).typeName()});
                    return false;
                }
            }
            return this.badLabel(object);
        }
        if (object instanceof Boolean) {
            return this._discriminator instanceof PrimitiveNode && ((PrimitiveNode)this._discriminator)._pkind == 8 ? true : this.badLabel(object);
        }
        if (object instanceof Character) {
            return this._discriminator instanceof PrimitiveNode && ((PrimitiveNode)this._discriminator)._pkind == 9 ? true : this.badLabel(object);
        }
        if (object instanceof EnumNameNode) {
            EnumNameNode enumNameNode = (EnumNameNode)object;
            if (enumNameNode._definingEnum == this._discriminator) {
                return true;
            }
            if (this._discriminator instanceof EnumNode) {
                this.error("Comp.AST.badEnumName", new Object[]{enumNameNode._name, ((EnumNode)this._discriminator)._name});
                return false;
            }
            return this.badLabel(object);
        }
        return this.badLabel(object);
    }
}

