/*
 * Decompiled with CFR 0.152.
 */
package com.inprise.vbroker.compiler.frontends.idl;

import com.inprise.vbroker.compiler.ast.AttributeNode;
import com.inprise.vbroker.compiler.ast.ContainedNode;
import com.inprise.vbroker.compiler.ast.ExceptionNode;
import com.inprise.vbroker.compiler.ast.FieldNode;
import com.inprise.vbroker.compiler.ast.InheritableNode;
import com.inprise.vbroker.compiler.ast.InterfaceNode;
import com.inprise.vbroker.compiler.ast.Node;
import com.inprise.vbroker.compiler.ast.OperationNode;
import com.inprise.vbroker.compiler.ast.RepositoryNode;
import com.inprise.vbroker.compiler.ast.ValueBoxNode;
import com.inprise.vbroker.compiler.ast.ValueNode;
import com.inprise.vbroker.compiler.frontends.idl.ASCII_CharStream;
import com.inprise.vbroker.compiler.frontends.idl.ErrorFormat;
import com.inprise.vbroker.compiler.frontends.idl.IdlFeOptions;
import com.inprise.vbroker.compiler.frontends.idl.ParseException;
import com.inprise.vbroker.compiler.frontends.idl.PragmaParserConstants;
import com.inprise.vbroker.compiler.frontends.idl.PragmaParserTokenManager;
import com.inprise.vbroker.compiler.frontends.idl.Scope;
import com.inprise.vbroker.compiler.frontends.idl.Token;
import com.inprise.vbroker.compiler.frontends.idl.TokenMgrError;
import com.inprise.vbroker.compiler.util.ErrorReporter;
import com.inprise.vbroker.compiler.util.PrintER;
import com.inprise.vbroker.compiler.util.QName;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public final class PragmaParser
implements PragmaParserConstants {
    private static final boolean _Debug = false;
    private static final boolean _Trace = false;
    ErrorReporter _ER;
    IdlFeOptions _options;
    RepositoryNode _repository;
    Scope _scope;
    String _input;
    private String _lastScopedName;
    private QName _lastScopedQName;
    private ContainedNode _hintNode;
    private String _hintFieldName;
    private Vector _hintNames = new Vector();
    private Vector _hintValues = new Vector();
    private int _reportingLevel;
    public PragmaParserTokenManager token_source;
    ASCII_CharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    public boolean lookingAhead = false;
    private boolean jj_semLA;
    private int jj_gen;
    private final int[] jj_la1 = new int[12];
    private final int[] jj_la1_0 = new int[]{2040, 131072, 49152, 49152, 51200, 2048, 51200, 4096, 131072, 16384, 16384, 49152};
    private final JJCalls[] jj_2_rtns = new JJCalls[2];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private Vector jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    public PragmaParser() {
        this(new StringReader(""));
    }

    public PragmaParser(PragmaParserTokenManager pragmaParserTokenManager) {
        int n;
        this.token_source = pragmaParserTokenManager;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (n = 0; n < 12; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    public PragmaParser(InputStream inputStream) {
        int n;
        this.jj_input_stream = new ASCII_CharStream(inputStream, 1, 1);
        this.token_source = new PragmaParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (n = 0; n < 12; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    public PragmaParser(Reader reader) {
        int n;
        this.jj_input_stream = new ASCII_CharStream(reader, 1, 1);
        this.token_source = new PragmaParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (n = 0; n < 12; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    public void ReInit(PragmaParserTokenManager pragmaParserTokenManager) {
        int n;
        this.token_source = pragmaParserTokenManager;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (n = 0; n < 12; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    public void ReInit(InputStream inputStream) {
        int n;
        this.jj_input_stream.ReInit(inputStream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (n = 0; n < 12; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    public void ReInit(Reader reader) {
        int n;
        this.jj_input_stream.ReInit(reader, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (n = 0; n < 12; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    public final void directive() throws ParseException {
        this.jj_consume_token(1);
        this.jj_consume_token(2);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 3: {
                this.prefix();
                break;
            }
            case 4: {
                this.version();
                break;
            }
            case 5: {
                this.repId();
                break;
            }
            case 6: {
                this.originalNameForAttributeSet();
                break;
            }
            case 7: {
                this.originalNameForAttributeGet();
                break;
            }
            case 8: {
                this.originalName();
                break;
            }
            case 9: {
                this.pseudo();
                break;
            }
            case 10: {
                this.toolHints();
                break;
            }
            default: {
                this.jj_la1[0] = this.jj_gen;
                this.unrecognizedPragma();
            }
        }
        this.jj_consume_token(0);
    }

    public final void disable_tracing() {
    }

    private void doPragmaOriginalName(ContainedNode containedNode, String string, boolean bl) {
        if (this._options._backCompatMapping) {
            return;
        }
        if (containedNode == InterfaceNode.ERROR) {
            containedNode = this.getContainer();
        }
        if (containedNode == null) {
            this.error("cantLocateNodeForRename");
            return;
        }
        switch (containedNode._kind) {
            case 4: {
                ((ExceptionNode)containedNode)._originalName = string;
                break;
            }
            case 7: {
                ((OperationNode)containedNode)._originalName = string;
                break;
            }
            case 2: {
                if (bl) {
                    AttributeNode attributeNode = (AttributeNode)containedNode;
                    if (attributeNode._readOnly) {
                        this.error("cantRenameSetterOnReadOnlyAttribute");
                        return;
                    }
                    attributeNode._mutatorName = string;
                    break;
                }
                ((AttributeNode)containedNode)._accessorName = string;
                break;
            }
            default: {
                this.error("invalidTypeForRename");
            }
        }
    }

    public final void enable_tracing() {
    }

    private void error(String string) {
        if (this._lastScopedQName != null) {
            this._ER.error("Comp.FE.IDL.".concat(String.valueOf(String.valueOf(string))), this._lastScopedQName.fullName());
        } else {
            this._ER.error("Comp.FE.IDL.".concat(String.valueOf(String.valueOf(string))), this._lastScopedName);
        }
    }

    public final ParseException generateParseException() {
        int n;
        int n2;
        this.jj_expentries.removeAllElements();
        boolean[] blArray = new boolean[23];
        for (n2 = 0; n2 < 23; ++n2) {
            blArray[n2] = false;
        }
        if (this.jj_kind >= 0) {
            blArray[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (n2 = 0; n2 < 12; ++n2) {
            if (this.jj_la1[n2] != this.jj_gen) continue;
            for (n = 0; n < 32; ++n) {
                if ((this.jj_la1_0[n2] & 1 << n) == 0) continue;
                blArray[n] = true;
            }
        }
        for (n2 = 0; n2 < 23; ++n2) {
            if (!blArray[n2]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = n2;
            this.jj_expentries.addElement(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] nArrayArray = new int[this.jj_expentries.size()][];
        for (n = 0; n < this.jj_expentries.size(); ++n) {
            nArrayArray[n] = (int[])this.jj_expentries.elementAt(n);
        }
        return new ParseException(this.token, nArrayArray, PragmaParserConstants.tokenImage);
    }

    private ContainedNode getContainer() {
        Node node = (Node)((Object)this._scope._def);
        if (node._kind == 17) {
            this._ER.error("Comp.FE.IDL.cantOnRepository");
            return null;
        }
        ContainedNode containedNode = (ContainedNode)node;
        this._lastScopedName = containedNode._fullName;
        return containedNode;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int n) {
        Token token = this.lookingAhead ? this.jj_scanpos : this.token;
        for (int i = 0; i < n; ++i) {
            token = token.next != null ? token.next : (token.next = this.token_source.getNextToken());
        }
        return token;
    }

    public final void hint() throws ParseException {
        Token token = null;
        Token token2 = this.jj_consume_token(15);
        this.jj_consume_token(13);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 17: {
                token = this.jj_consume_token(17);
                break;
            }
            default: {
                this.jj_la1[8] = this.jj_gen;
            }
        }
        this._hintNames.addElement(token2.image);
        this._hintValues.addElement(token == null ? null : token.image);
    }

    public final void hintList() throws ParseException {
        this.hint();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 12: {
                    break;
                }
                default: {
                    this.jj_la1[7] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(12);
            this.hint();
        }
    }

    private final boolean jj_2_1(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean bl = !this.jj_3_1();
        this.jj_save(0, n);
        return bl;
    }

    private final boolean jj_2_2(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean bl = !this.jj_3_2();
        this.jj_save(1, n);
        return bl;
    }

    private final boolean jj_3R_4() {
        if (this.jj_3R_6()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_5() {
        if (this.jj_scan_token(14)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_6() {
        if (this.jj_scan_token(15)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(13)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_1() {
        if (this.jj_3R_4()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_2() {
        Token token;
        block5: {
            if (this.jj_scan_token(15)) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
            if (this.jj_3R_5()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
            do {
                token = this.jj_scanpos;
                if (this.jj_3R_5()) break block5;
            } while (this.jj_la != 0 || this.jj_scanpos != this.jj_lastpos);
            return false;
        }
        this.jj_scanpos = token;
        return false;
    }

    private void jj_add_error_token(int n, int n2) {
        if (n2 >= 100) {
            return;
        }
        if (n2 == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = n;
        } else if (this.jj_endpos != 0) {
            int n3;
            this.jj_expentry = new int[this.jj_endpos];
            for (n3 = 0; n3 < this.jj_endpos; ++n3) {
                this.jj_expentry[n3] = this.jj_lasttokens[n3];
            }
            n3 = 0;
            Enumeration enumeration = this.jj_expentries.elements();
            while (enumeration.hasMoreElements()) {
                int[] nArray = (int[])enumeration.nextElement();
                if (nArray.length != this.jj_expentry.length) continue;
                n3 = 1;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (nArray[i] == this.jj_expentry[i]) continue;
                    n3 = 0;
                    break;
                }
                if (n3 == 0) continue;
            }
            if (n3 == 0) {
                this.jj_expentries.addElement(this.jj_expentry);
            }
            if (n2 != 0) {
                this.jj_endpos = n2;
                this.jj_lasttokens[this.jj_endpos - 1] = n;
            }
        }
    }

    private final Token jj_consume_token(int n) throws ParseException {
        Token token = this.token;
        this.token = token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == n) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls jJCalls = this.jj_2_rtns[i];
                    while (jJCalls != null) {
                        if (jJCalls.gen < this.jj_gen) {
                            jJCalls.first = null;
                        }
                        jJCalls = jJCalls.next;
                    }
                }
            }
            return this.token;
        }
        this.token = token;
        this.jj_kind = n;
        throw this.generateParseException();
    }

    private final int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private final void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 2; ++i) {
            JJCalls jJCalls = this.jj_2_rtns[i];
            do {
                if (jJCalls.gen <= this.jj_gen) continue;
                this.jj_la = jJCalls.arg;
                this.jj_lastpos = this.jj_scanpos = jJCalls.first;
                switch (i) {
                    case 0: {
                        this.jj_3_1();
                        break;
                    }
                    case 1: {
                        this.jj_3_2();
                    }
                }
            } while ((jJCalls = jJCalls.next) != null);
        }
        this.jj_rescan = false;
    }

    private final void jj_save(int n, int n2) {
        JJCalls jJCalls = this.jj_2_rtns[n];
        while (jJCalls.gen > this.jj_gen) {
            if (jJCalls.next == null) {
                jJCalls = jJCalls.next = new JJCalls();
                break;
            }
            jJCalls = jJCalls.next;
        }
        jJCalls.gen = this.jj_gen + n2 - this.jj_la;
        jJCalls.first = this.token;
        jJCalls.arg = n2;
    }

    private final boolean jj_scan_token(int n) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int n2 = 0;
            Token token = this.token;
            while (token != null && token != this.jj_scanpos) {
                ++n2;
                token = token.next;
            }
            if (token != null) {
                this.jj_add_error_token(n, n2);
            }
        }
        return this.jj_scanpos.kind != n;
    }

    public final void objectSpecifier() throws ParseException {
        Token token = null;
        this._hintNode = InterfaceNode.ERROR;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 11: {
                this.jj_consume_token(11);
                token = this.jj_consume_token(15);
                this._hintFieldName = token.image;
                break;
            }
            case 14: 
            case 15: {
                this._hintNode = this.scopedName();
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 11: {
                        this.jj_consume_token(11);
                        token = this.jj_consume_token(15);
                        break;
                    }
                    default: {
                        this.jj_la1[5] = this.jj_gen;
                    }
                }
                this._hintFieldName = token == null ? null : token.image;
                break;
            }
            default: {
                this.jj_la1[6] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void originalName() throws ParseException {
        ContainedNode containedNode = InterfaceNode.ERROR;
        this.jj_consume_token(8);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 14: 
            case 15: {
                containedNode = this.scopedName();
                break;
            }
            default: {
                this.jj_la1[2] = this.jj_gen;
            }
        }
        Token token = this.jj_consume_token(17);
        this.doPragmaOriginalName(containedNode, token.image, false);
    }

    public final void originalNameForAttributeGet() throws ParseException {
        this.jj_consume_token(7);
        ContainedNode containedNode = this.scopedName();
        Token token = this.jj_consume_token(17);
        this.doPragmaOriginalName(containedNode, token.image, false);
    }

    public final void originalNameForAttributeSet() throws ParseException {
        this.jj_consume_token(6);
        ContainedNode containedNode = this.scopedName();
        Token token = this.jj_consume_token(17);
        this.doPragmaOriginalName(containedNode, token.image, true);
    }

    void parse(RepositoryNode repositoryNode, ErrorReporter errorReporter, String string, Scope scope, IdlFeOptions idlFeOptions) {
        this._repository = repositoryNode;
        this._ER = errorReporter;
        this._options = idlFeOptions;
        this._scope = scope;
        this._input = string;
        this.token_source._ER = errorReporter;
        this.ReInit(new StringReader(string));
        this._reportingLevel = 2;
        try {
            this.directive();
        }
        catch (ParseException parseException) {
            this.reportError("PragmaParserSyntaxError", ErrorFormat.formatExpectedLookaheadList(parseException.expectedTokenSequences, parseException.tokenImage, this._ER, true), parseException.currentToken.next.beginColumn);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.reportError(illegalArgumentException.getMessage(), null, this.token.beginColumn);
        }
        catch (TokenMgrError tokenMgrError) {
            this.reportError("PragmaParserLexicalError", null, ErrorFormat.getColumnFromLexerException(tokenMgrError.getMessage()));
        }
    }

    public final void prefix() throws ParseException {
        Token token = null;
        this.jj_consume_token(3);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 17: {
                token = this.jj_consume_token(17);
                break;
            }
            default: {
                this.jj_la1[1] = this.jj_gen;
            }
        }
        this._scope._prefix = token == null ? this._scope.defaultPrefix() : token.image;
    }

    public final void pseudo() throws ParseException {
        ContainedNode containedNode = InterfaceNode.ERROR;
        this.jj_consume_token(9);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 14: 
            case 15: {
                containedNode = this.scopedName();
                break;
            }
            default: {
                this.jj_la1[3] = this.jj_gen;
            }
        }
        if (containedNode == InterfaceNode.ERROR) {
            containedNode = this.getContainer();
        }
        if (containedNode == null) {
            this.error("cantLocateNodeForPseudo");
            return;
        }
        switch (containedNode._kind) {
            case 5: 
            case 20: {
                InheritableNode inheritableNode = containedNode;
                if (inheritableNode._bases != null && inheritableNode._bases.size() > 0) {
                    Enumeration enumeration = inheritableNode._bases.elements();
                    while (enumeration.hasMoreElements()) {
                        InheritableNode inheritableNode2 = (InheritableNode)enumeration.nextElement();
                        if (inheritableNode2._pseudo) continue;
                        this._ER.error("Comp.FE.IDL.pseudoHasRegularBase", new Object[]{inheritableNode._fullName, inheritableNode2._fullName});
                    }
                }
                if (containedNode._kind == 20 && ((ValueNode)containedNode)._custom) {
                    this.error("pseudoIsCustom");
                }
                inheritableNode._pseudo = true;
                break;
            }
            default: {
                this.error("invalidTypeForPseudo");
            }
        }
    }

    public final void repId() throws ParseException {
        this.jj_consume_token(5);
        ContainedNode containedNode = this.scopedName();
        Token token = this.jj_consume_token(17);
        if (containedNode == null) {
            this.error("cantLocateNodeForID");
        } else {
            String string = containedNode._repId;
            containedNode._repId = token.image;
            if (containedNode._repId.startsWith("IDL:")) {
                if (containedNode._repId.lastIndexOf(":") == 3) {
                    containedNode._version = "1.0";
                    containedNode._repId = containedNode.recomputeRepIdForVersionChange(containedNode._version);
                } else {
                    containedNode._version = containedNode._repId.substring(containedNode._repId.lastIndexOf(":") + 1);
                }
            } else if (!this._options._backCompatMapping && containedNode._repId.startsWith("RMI:")) {
                switch (containedNode._kind) {
                    case 5: {
                        ((InterfaceNode)containedNode)._style = (short)(((InterfaceNode)containedNode).checkForEJBStyle() ? 2 : 1);
                    }
                    case 20: {
                        ((InheritableNode)containedNode)._idlEntity = false;
                        break;
                    }
                    case 21: {
                        ((ValueBoxNode)containedNode)._idlEntity = false;
                        break;
                    }
                    case 4: {
                        ((ExceptionNode)containedNode)._idlEntity = false;
                        break;
                    }
                    default: {
                        this.error("invalidTypeForRMIRepId");
                    }
                }
            }
            containedNode._repository.replaceId(string, containedNode);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void reportError(String string, String[] stringArray, long l) {
        boolean bl;
        block7: {
            block8: {
                bl = ((PrintER)this._ER)._print;
                try {
                    ((PrintER)this._ER)._print = true;
                    if (this._reportingLevel == 0) break block7;
                    if (this._reportingLevel == 1) {
                        if (!this._ER.warn("Comp.FE.IDL.".concat(String.valueOf(String.valueOf(string))))) {
                            Object var7_5 = null;
                            ((PrintER)this._ER)._print = bl;
                            return;
                        }
                        ErrorFormat.showColumn(this._ER, this._input, l);
                        if (stringArray != null) {
                            ErrorFormat.showExpected(this._ER, stringArray, null);
                        }
                        break block7;
                    }
                    if (!this._ER.error("Comp.FE.IDL.".concat(String.valueOf(String.valueOf(string))))) {
                        break block8;
                    }
                    ErrorFormat.showColumn(this._ER, this._input, l);
                    if (stringArray != null) {
                        ErrorFormat.showExpected(this._ER, stringArray, null);
                    }
                    break block7;
                }
                catch (Throwable throwable) {
                    Object var7_8 = null;
                    ((PrintER)this._ER)._print = bl;
                    throw throwable;
                }
            }
            Object var7_6 = null;
            ((PrintER)this._ER)._print = bl;
            return;
        }
        Object var7_7 = null;
        ((PrintER)this._ER)._print = bl;
    }

    public final ContainedNode scopedName() throws ParseException {
        this._lastScopedName = null;
        this._lastScopedQName = null;
        if (this.jj_2_2(2)) {
            Token token = this.jj_consume_token(15);
            QName qName = new QName(token.image);
            block10: while (true) {
                this.jj_consume_token(14);
                token = this.jj_consume_token(15);
                qName.append(token.image);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 14: {
                        continue block10;
                    }
                }
                break;
            }
            this.jj_la1[9] = this.jj_gen;
            this._lastScopedQName = qName;
            return this._scope.use(qName);
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 15: {
                Token token = this.jj_consume_token(15);
                this._lastScopedName = token.image;
                return this._scope.use(token.image);
            }
            case 14: {
                this.jj_consume_token(14);
                Token token = this.jj_consume_token(15);
                QName qName = new QName(token.image);
                block11: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 14: {
                            break;
                        }
                        default: {
                            this.jj_la1[10] = this.jj_gen;
                            break block11;
                        }
                    }
                    this.jj_consume_token(14);
                    token = this.jj_consume_token(15);
                    qName.append(token.image);
                }
                this._lastScopedQName = qName;
                return this._repository.lookup(qName, true);
            }
        }
        this.jj_la1[11] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final void toolHints() throws ParseException {
        block14: {
            block13: {
                this._hintNames.setSize(0);
                this._hintValues.setSize(0);
                this._hintNode = InterfaceNode.ERROR;
                this._hintFieldName = null;
                this.jj_consume_token(10);
                if (this.jj_2_1(2)) {
                    this.hintList();
                } else {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 11: 
                        case 14: 
                        case 15: {
                            this.objectSpecifier();
                            this.hintList();
                            break;
                        }
                        default: {
                            this.jj_la1[4] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                }
                if (this._hintNode == InterfaceNode.ERROR) {
                    this._hintNode = this.getContainer();
                }
                if (this._hintNode == null) {
                    this.error("cantLocateNodeForHint");
                    return;
                }
                if (this._hintFieldName == null) break block13;
                switch (this._hintNode._kind) {
                    case 4: 
                    case 10: 
                    case 11: {
                        FieldNode fieldNode = (FieldNode)this._hintNode;
                        int n = this._hintNames.size();
                        for (int i = 0; i < n; ++i) {
                            fieldNode.annotateMember(this._hintFieldName, (String)this._hintNames.elementAt(i), (String)this._hintValues.elementAt(i));
                        }
                        break block14;
                    }
                    default: {
                        this.error("invalidTypeForFieldHint");
                        return;
                    }
                }
            }
            int n = this._hintNames.size();
            if (n > 0 && this._hintNode._annotations == null) {
                this._hintNode._annotations = new Hashtable(n);
            }
            for (int i = 0; i < n; ++i) {
                this._hintNode._annotations.put((String)this._hintNames.elementAt(i), (String)this._hintValues.elementAt(i));
            }
        }
    }

    void unrecognizedPragma() throws ParseException {
        this._reportingLevel = this._options._warnUnrecognizedPragmas ? 1 : 0;
    }

    public final void version() throws ParseException {
        this.jj_consume_token(4);
        ContainedNode containedNode = this.scopedName();
        Token token = this.jj_consume_token(16);
        if (containedNode == null) {
            this.error("cantLocateNodeForVersion");
            return;
        }
        String string = containedNode._repId;
        containedNode._version = token.image;
        containedNode._repId = containedNode.recomputeRepIdForVersionChange(containedNode._version);
        containedNode._repository.replaceId(string, containedNode);
    }

    static {
        _Debug = false;
        _Trace = false;
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }
}

