/*
 * Decompiled with CFR 0.152.
 */
package com.inprise.vbroker.compiler.preprocessor;

import com.inprise.vbroker.compiler.preprocessor.ConditionalInfo;
import com.inprise.vbroker.compiler.preprocessor.Macro;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Stack;

final class OpenStream {
    static final int MAXIMUM_BUFFER_SIZE = 0x100000;
    OpenStream PreviousStream;
    InputStream Stream;
    byte[] Buffer;
    int Length;
    int Index;
    long LineNumber;
    String FileName;
    String Directory;
    Macro Macro = null;
    boolean EndedWithLineSep = false;
    private Stack ConditionalStack = null;

    OpenStream(InputStream inputStream, String string, String string2, int n) throws IOException {
        this.PreviousStream = null;
        this.Stream = inputStream;
        this.FileName = string;
        this.Directory = string2;
        this.LineNumber = 1L;
        this.Length = 0;
        this.Buffer = n >= 0 && n < 0x100000 ? new byte[n] : new byte[0x100000];
        this.reload();
    }

    OpenStream(byte[] byArray, OpenStream openStream, Macro macro) throws IOException {
        this.PreviousStream = openStream;
        this.FileName = openStream.FileName;
        this.Directory = openStream.Directory;
        this.LineNumber = openStream.LineNumber;
        this.Macro = macro;
        if (0x100000 >= byArray.length) {
            this.Stream = null;
            this.Buffer = byArray;
            this.Length = this.Buffer.length;
        } else {
            this.Stream = new ByteArrayInputStream(byArray);
            this.Buffer = new byte[0x100000];
            this.Length = 0;
            this.reload();
        }
    }

    boolean advance() throws IOException {
        if (this.Index == this.Length) {
            return this.reload();
        }
        ++this.Index;
        return true;
    }

    boolean conditionalStackEmpty() {
        return this.ConditionalStack == null;
    }

    byte conditionalStackPeek() {
        return ((ConditionalInfo)this.ConditionalStack.peek()).Status;
    }

    ConditionalInfo conditionalStackPeekEntry() {
        return (ConditionalInfo)this.ConditionalStack.peek();
    }

    ConditionalInfo conditionalStackPop() {
        ConditionalInfo conditionalInfo = (ConditionalInfo)this.ConditionalStack.pop();
        if (this.ConditionalStack.empty()) {
            this.ConditionalStack = null;
        }
        return conditionalInfo;
    }

    void finished() throws IOException {
        if (this.Stream != null) {
            this.Stream.close();
        }
    }

    boolean isTransient() {
        return this.PreviousStream != null;
    }

    ConditionalInfo[] openConditionals() {
        if (this.conditionalStackEmpty()) {
            return null;
        }
        ConditionalInfo[] conditionalInfoArray = new ConditionalInfo[this.ConditionalStack.size()];
        for (int i = 0; i < conditionalInfoArray.length; ++i) {
            conditionalInfoArray[i] = (ConditionalInfo)this.ConditionalStack.pop();
        }
        return conditionalInfoArray;
    }

    boolean reload() throws IOException {
        if (this.Stream == null) {
            return false;
        }
        this.Length = this.Stream.read(this.Buffer);
        if (this.Length <= 0) {
            this.Index = this.Length;
            return false;
        }
        this.Index = 0;
        return true;
    }

    boolean updateConditionalStack(ConditionalInfo conditionalInfo, byte by) throws IOException {
        if (by == 2 && !this.conditionalStackEmpty() && this.conditionalStackPeek() != 2) {
            by = 1;
        }
        if (this.ConditionalStack == null) {
            this.ConditionalStack = new Stack();
        }
        this.ConditionalStack.push(new ConditionalInfo(conditionalInfo.Type, conditionalInfo.LineNumber, by));
        return by == 2;
    }

    boolean updateConditionalStack(String string, byte by) throws IOException {
        if (by == 2 && !this.conditionalStackEmpty() && this.conditionalStackPeek() != 2) {
            by = 1;
        }
        if (this.ConditionalStack == null) {
            this.ConditionalStack = new Stack();
        }
        this.ConditionalStack.push(new ConditionalInfo(string, this.LineNumber, by));
        return by == 2;
    }

    static {
        MAXIMUM_BUFFER_SIZE = 0x100000;
    }
}

