/*
 * Decompiled with CFR 0.152.
 */
package com.inprise.vbroker.compiler.tools.cmdline;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.Vector;

public final class CLProcessor {
    private Vector Strings;
    private int Index;
    private String Version;
    private Dictionary NameTable = null;
    private Dictionary FlagTable = null;
    private Vector NameLog;
    private Vector ArgLog;
    public static final int BOOL = 1;
    public static final int STRING = 2;
    public static final int LIST = 3;
    public static final int PAIR = 4;
    public static final int DICT = 5;
    public static final int BUILTIN = 6;

    public CLProcessor(String string, ResourceBundle[] resourceBundleArray) {
        this.Version = string;
        this.NameLog = new Vector();
        this.ArgLog = new Vector();
        this.NameTable = new Hashtable();
        this.FlagTable = new Hashtable();
        this.initialize(resourceBundleArray);
    }

    public boolean add(String[] stringArray) {
        return this.read(stringArray, true);
    }

    public boolean add(String[] stringArray, String[] stringArray2) {
        boolean bl = this.read(stringArray, false);
        boolean bl2 = this.read(stringArray2, true);
        return bl || bl2;
    }

    private void addObjectToVector(String string, Object object) {
        Name name = (Name)this.NameTable.get(string);
        Vector<Object> vector = (Vector<Object>)name.Value;
        if (vector == null) {
            name.Value = vector = new Vector<Object>();
        }
        vector.addElement(object);
    }

    public static boolean allHyphens(String string) {
        int n = string.length();
        if (n == 0) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (string.charAt(i) == '-') continue;
            return false;
        }
        return true;
    }

    public static Vector arrayToVector(Object[] objectArray) {
        Vector<Object> vector = new Vector<Object>(objectArray.length);
        for (int i = 0; i < objectArray.length; ++i) {
            vector.addElement(objectArray[i]);
        }
        return vector;
    }

    private void clearGeneratedValues() {
        this.NameTable.put("REMAINING", new Name(3, null));
        this.NameTable.put("UNRECOGNIZED", new Name(3, null));
        this.NameTable.put("INVALID", new Name(3, null));
        this.NameTable.put("ERRORS", new Name(1, Boolean.FALSE));
    }

    public boolean errors() {
        try {
            boolean bl = this.getBool("ERRORS");
            return bl;
        }
        catch (MissingNameException missingNameException) {
            boolean bl = false;
            return bl;
        }
        catch (InvalidTypeException invalidTypeException) {
            boolean bl = false;
            return bl;
        }
    }

    private void fatal(String string) {
        System.err.println(string);
        System.exit(1);
    }

    public Vector getArgLog() {
        return this.ArgLog;
    }

    public boolean getBool(String string) throws InvalidTypeException, MissingNameException {
        Name name = (Name)this.NameTable.get(string);
        if (name == null) {
            throw new MissingNameException(string);
        }
        if (name.Type != 1) {
            throw new InvalidTypeException(string, 1, name.Type);
        }
        return (Boolean)name.Value;
    }

    public Dictionary getDict(String string) throws InvalidTypeException, MissingNameException {
        Name name = (Name)this.NameTable.get(string);
        if (name == null) {
            throw new MissingNameException(string);
        }
        if (name.Type != 5) {
            throw new InvalidTypeException(string, 5, name.Type);
        }
        return (Dictionary)name.Value;
    }

    public Vector getList(String string) throws InvalidTypeException, MissingNameException {
        Name name = (Name)this.NameTable.get(string);
        if (name == null) {
            throw new MissingNameException(string);
        }
        if (name.Type != 3) {
            throw new InvalidTypeException(string, 3, name.Type);
        }
        return (Vector)name.Value;
    }

    public Vector getNameLog() {
        return this.NameLog;
    }

    public String[] getPair(String string) throws InvalidTypeException, MissingNameException {
        Name name = (Name)this.NameTable.get(string);
        if (name == null) {
            throw new MissingNameException(string);
        }
        if (name.Type != 4) {
            throw new InvalidTypeException(string, 4, name.Type);
        }
        return (String[])name.Value;
    }

    public String getString(String string) throws InvalidTypeException, MissingNameException {
        Name name = (Name)this.NameTable.get(string);
        if (name == null) {
            throw new MissingNameException(string);
        }
        if (name.Type != 2) {
            throw new InvalidTypeException(string, 2, name.Type);
        }
        return (String)name.Value;
    }

    public int getType(String string) throws MissingNameException {
        Name name = (Name)this.NameTable.get(string);
        if (name == null) {
            throw new MissingNameException(string);
        }
        return name.Type;
    }

    public void initialize(ResourceBundle[] resourceBundleArray) {
        this.reset();
        this.installBuiltins();
        for (int i = 0; i < resourceBundleArray.length; ++i) {
            Enumeration<String> enumeration = resourceBundleArray[i].getKeys();
            while (enumeration.hasMoreElements()) {
                String string;
                String string2 = enumeration.nextElement();
                if (this.parseAndRecord(string2, string = resourceBundleArray[i].getString(string2)) != null) continue;
                System.err.println(String.valueOf(String.valueOf(new StringBuffer("Command-line property for key ").append(string2).append(" had errors."))));
            }
        }
    }

    private void insertAfterString(String string, int n) {
        int n2 = -1;
        while ((n2 = string.indexOf(32)) != -1) {
            this.Strings.insertElementAt(string.substring(0, n2), n++);
            string = string.substring(n2 + 1, string.length());
        }
    }

    private void installBuiltins() {
        this.NameTable.put("VERSION", new Name(6, null));
        this.NameTable.put("USAGE", new Name(6, null));
    }

    public Vector invalidArgs() {
        try {
            Vector vector = this.getList("INVALID");
            return vector;
        }
        catch (MissingNameException missingNameException) {
            Vector vector = null;
            return vector;
        }
        catch (InvalidTypeException invalidTypeException) {
            Vector vector = null;
            return vector;
        }
    }

    private Object parseAndRecord(String string, String string2) {
        Object object;
        Object object2;
        int n;
        Vector<String> vector = new Vector<String>();
        int n2 = 0;
        while ((n = string2.indexOf(44, n2)) != -1) {
            vector.addElement(string2.substring(0, n).trim());
            string2 = string2.substring(n + 1, string2.length());
        }
        if (string2.length() > 0) {
            vector.addElement(string2.trim());
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        if (objectArray.length == 0) {
            return null;
        }
        int n3 = this.typeNameToType((String)objectArray[0]);
        if (n3 == -1) {
            return null;
        }
        if (n3 == 1) {
            Object object3;
            Object object4;
            Object object5;
            Object object6 = object5 = objectArray.length > 1 ? objectArray[1] : null;
            if (object5 == null || ((String)object5).length() == 0) {
                object5 = "enable [disable] ".concat(String.valueOf(String.valueOf(string)));
            }
            Object object7 = object4 = objectArray.length > 2 ? objectArray[2] : null;
            if (object4 == null || ((String)object4).length() == 0) {
                object4 = "-".concat(String.valueOf(String.valueOf(string)));
            }
            Object object8 = object3 = objectArray.length > 3 ? objectArray[3] : null;
            if (object3 == null || ((String)object3).length() == 0) {
                object3 = "-no".concat(String.valueOf(String.valueOf(string)));
            }
            Object object9 = objectArray.length > 4 ? objectArray[4] : null;
            Object object10 = objectArray.length > 5 ? objectArray[5] : null;
            Arg arg = new Arg(string, (String)object5, (String)object4, (String)object3, (String)object9, (String)object10);
            this.FlagTable.put(object4, arg);
            this.FlagTable.put(object3, arg);
            String string3 = this.realName(arg);
            this.verifyNotBuiltin(string3);
            this.NameTable.put(string3, new Name(n3, Boolean.FALSE));
            return arg;
        }
        if (n3 == 2 || n3 == 3) {
            Object object11;
            Object object12;
            if (objectArray.length == 1) {
                this.fatal("Missing `space' specifier");
            }
            if (!((String)(object12 = objectArray[1])).equals("true") && !((String)object12).equals("false")) {
                this.fatal("Malformed `space' specifier (true or false expected)");
            }
            Object object13 = objectArray.length > 2 ? objectArray[2] : (n3 == 2 ? String.valueOf(String.valueOf(new StringBuffer("set ").append(string).append(" to <arg>"))) : String.valueOf(String.valueOf(new StringBuffer("add <arg> to the ").append(string).append(" list"))));
            Object object14 = object11 = objectArray.length > 3 ? objectArray[3] : null;
            if (object11 == null || ((String)object11).length() == 0) {
                object11 = "-".concat(String.valueOf(String.valueOf(string)));
            }
            Object object15 = objectArray.length > 4 ? objectArray[4] : null;
            Object object16 = objectArray.length > 5 ? objectArray[5] : null;
            Arg arg = new Arg(string, n3, ((String)object12).equals("true"), (String)object13, (String)object11, (String)object15, (String)object16);
            this.FlagTable.put(object11, arg);
            String string4 = this.realName(arg);
            this.verifyNotBuiltin(string4);
            this.NameTable.put(string4, new Name(n3, null));
            return arg;
        }
        if (n3 == 4 || n3 == 5) {
            Object object17;
            Object object18;
            Object object19 = object18 = objectArray.length > 1 ? objectArray[1] : null;
            if (object18 == null || ((String)object18).length() == 0) {
                object18 = n3 == 4 ? String.valueOf(String.valueOf(new StringBuffer("set ").append(string).append(" <name> to <value>"))) : "add name=value to ".concat(String.valueOf(String.valueOf(string)));
            }
            Object object20 = object17 = objectArray.length > 2 ? objectArray[2] : null;
            if (object17 == null || ((String)object17).length() == 0) {
                object17 = "-".concat(String.valueOf(String.valueOf(string)));
            }
            Object object21 = objectArray.length > 3 ? objectArray[3] : null;
            Object object22 = objectArray.length > 4 ? objectArray[4] : null;
            Arg arg = new Arg(string, n3, (String)object18, (String)object17, (String)object21, (String)object22);
            this.FlagTable.put(object17, arg);
            String string5 = this.realName(arg);
            this.verifyNotBuiltin(string5);
            this.NameTable.put(string5, new Name(n3, null));
            return arg;
        }
        Object object23 = objectArray.length > 1 ? objectArray[1] : null;
        Object object24 = object2 = objectArray.length > 2 ? objectArray[2] : null;
        if (object2 == null || ((String)object2).length() == 0) {
            object2 = "-".concat(String.valueOf(String.valueOf(string)));
        }
        Object object25 = objectArray.length > 3 ? objectArray[3] : null;
        Object object26 = object = objectArray.length > 4 ? objectArray[4] : null;
        if (object == null || !((String)object).equals("USAGE") && !((String)object).equals("VERSION")) {
            this.fatal("BUILTIN types must reference one of the operators: USAGE, VERSION");
        }
        if (object23 == null || ((String)object23).length() == 0) {
            object23 = ((String)object).equals("USAGE") ? "print this list" : "print software version";
        }
        Arg arg = new Arg(string, n3, (String)object23, (String)object2, (String)object25, (String)object);
        this.FlagTable.put(object2, arg);
        return arg;
    }

    private boolean processBOOL(Arg arg, boolean bl) {
        ((Name)this.NameTable.get((Object)this.realName((Arg)arg))).Value = this.Strings.elementAt(this.Index).equals(arg.Flag1) ? Boolean.TRUE : Boolean.FALSE;
        this.ArgLog.addElement(null);
        if (bl && arg.AfterString != null) {
            this.insertAfterString(arg.AfterString, this.Index + 1);
        }
        return true;
    }

    private void processBUILTIN(Arg arg) {
        Name name = (Name)this.NameTable.get(arg.AliasFor);
        if (name.Type != 6) {
            this.fatal(String.valueOf(String.valueOf(new StringBuffer("Flag specified BUILTIN, but name had type ").append(name.Type).append("."))));
        }
        if (arg.AliasFor.equals("VERSION")) {
            this.version();
        } else if (arg.AliasFor.equals("USAGE")) {
            System.out.println(this.usage());
        } else {
            this.fatal(String.valueOf(String.valueOf(new StringBuffer("Unknown BUILTIN name ").append(arg.AliasFor).append(": cannot handle."))));
        }
        this.ArgLog.addElement(null);
    }

    private boolean processPAIR(Arg arg, boolean bl, boolean bl2) {
        if (this.Index + 2 >= this.Strings.size()) {
            Name name = (Name)this.NameTable.get("ERRORS");
            name.Value = Boolean.TRUE;
            this.addObjectToVector("INVALID", this.realName(arg));
            this.ArgLog.addElement(new String[2]);
            return false;
        }
        String string = (String)this.Strings.elementAt(this.Index + 1);
        String string2 = (String)this.Strings.elementAt(this.Index + 2);
        String[] stringArray = new String[]{string, string2};
        String string3 = this.realName(arg);
        Name name = (Name)this.NameTable.get(string3);
        if (bl2) {
            name.Value = stringArray;
        } else {
            Hashtable<String, String> hashtable = (Hashtable<String, String>)name.Value;
            if (hashtable == null) {
                name.Value = hashtable = new Hashtable<String, String>(10);
            }
            ((Dictionary)hashtable).put(string, string2);
        }
        this.ArgLog.addElement(stringArray);
        this.Index += 2;
        if (bl && arg.AfterString != null) {
            this.insertAfterString(arg.AfterString, this.Index + 1);
        }
        return true;
    }

    private boolean processSTRING(Arg arg, boolean bl, boolean bl2) {
        if (!arg.NeedsSpace) {
            String string = (String)this.Strings.elementAt(this.Index);
            String string2 = string.substring(2, string.length());
            String string3 = this.realName(arg);
            Name name = (Name)this.NameTable.get(string3);
            if (bl2) {
                name.Value = string2;
            } else {
                this.addObjectToVector(string3, string2);
            }
            this.ArgLog.addElement(new String[]{string2});
            if (bl && arg.AfterString != null) {
                this.insertAfterString(arg.AfterString, this.Index + 1);
            }
            return true;
        }
        if (this.Index + 1 == this.Strings.size()) {
            Name name = (Name)this.NameTable.get("ERRORS");
            name.Value = Boolean.TRUE;
            this.addObjectToVector("INVALID", this.realName(arg));
            this.ArgLog.addElement(null);
            return false;
        }
        String string = (String)this.Strings.elementAt(this.Index + 1);
        String string4 = this.realName(arg);
        Name name = (Name)this.NameTable.get(string4);
        if (bl2) {
            name.Value = string;
        } else {
            this.addObjectToVector(string4, string);
        }
        this.ArgLog.addElement(new String[]{string});
        ++this.Index;
        if (bl && arg.AfterString != null) {
            this.insertAfterString(arg.AfterString, this.Index + 1);
        }
        return true;
    }

    private boolean processUnrecognizedWord() {
        boolean bl = false;
        String string = (String)this.Strings.elementAt(this.Index);
        if (string == null || string.equals("")) {
            return bl;
        }
        char c = string.charAt(0);
        if (c == '-' && !CLProcessor.allHyphens(string) || c == '+') {
            this.addObjectToVector("UNRECOGNIZED", string);
        } else {
            this.addObjectToVector("REMAINING", string);
            bl = true;
        }
        ++this.Index;
        return bl;
    }

    private boolean read(String[] stringArray, boolean bl) {
        boolean bl2 = true;
        this.clearGeneratedValues();
        this.Strings = CLProcessor.arrayToVector(stringArray);
        this.Index = 0;
        while (this.Index < this.Strings.size()) {
            block11: {
                boolean bl3;
                Arg arg;
                block9: {
                    block10: {
                        String string = (String)this.Strings.elementAt(this.Index);
                        arg = (Arg)this.FlagTable.get(string);
                        if (arg != null) break block9;
                        if (string.length() <= 2) break block10;
                        arg = (Arg)this.FlagTable.get(string.substring(0, 2));
                        if (arg != null && !arg.NeedsSpace && (arg.Type == 2 || arg.Type == 3)) break block9;
                        bl3 = this.processUnrecognizedWord();
                        bl2 = bl2 && bl3;
                        break block11;
                    }
                    bl3 = this.processUnrecognizedWord();
                    bl2 = bl2 && bl3;
                    break block11;
                }
                this.NameLog.addElement(this.realName(arg));
                bl3 = true;
                switch (arg.Type) {
                    case 1: {
                        bl3 = this.processBOOL(arg, bl);
                        break;
                    }
                    case 2: {
                        bl3 = this.processSTRING(arg, bl, true);
                        break;
                    }
                    case 3: {
                        bl3 = this.processSTRING(arg, bl, false);
                        break;
                    }
                    case 4: {
                        bl3 = this.processPAIR(arg, bl, true);
                        break;
                    }
                    case 5: {
                        bl3 = this.processPAIR(arg, bl, false);
                        break;
                    }
                    case 6: {
                        this.processBUILTIN(arg);
                    }
                }
                bl2 = bl2 && bl3;
            }
            ++this.Index;
        }
        return bl2;
    }

    String realName(Arg arg) {
        return arg.AliasFor != null ? arg.AliasFor : arg.Name;
    }

    public Vector remainingArgs() {
        try {
            Vector vector = this.getList("REMAINING");
            return vector;
        }
        catch (MissingNameException missingNameException) {
            Vector vector = null;
            return vector;
        }
        catch (InvalidTypeException invalidTypeException) {
            Vector vector = null;
            return vector;
        }
    }

    public boolean replace(String[] stringArray) {
        this.reset();
        return this.read(stringArray, true);
    }

    public boolean replace(String[] stringArray, String[] stringArray2) {
        this.reset();
        boolean bl = this.read(stringArray, false);
        boolean bl2 = this.read(stringArray2, true);
        return bl || bl2;
    }

    private void reset() {
        Enumeration enumeration = this.NameTable.elements();
        while (enumeration.hasMoreElements()) {
            Name name = (Name)enumeration.nextElement();
            name.Value = name.Type == 1 ? Boolean.FALSE : null;
        }
        this.NameLog.setSize(0);
        this.ArgLog.setSize(0);
    }

    public int typeNameToType(String string) {
        if (string.equals("BOOL")) {
            return 1;
        }
        if (string.equals("STRING")) {
            return 2;
        }
        if (string.equals("LIST")) {
            return 3;
        }
        if (string.equals("PAIR")) {
            return 4;
        }
        if (string.equals("DICT")) {
            return 5;
        }
        if (string.equals("BUILTIN")) {
            return 6;
        }
        return -1;
    }

    public Vector unrecognizedArgs() {
        try {
            Vector vector = this.getList("UNRECOGNIZED");
            return vector;
        }
        catch (MissingNameException missingNameException) {
            Vector vector = null;
            return vector;
        }
        catch (InvalidTypeException invalidTypeException) {
            Vector vector = null;
            return vector;
        }
    }

    public String usage() {
        int n;
        int n2;
        Arg arg;
        String string = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer("Usage:".concat(String.valueOf(String.valueOf(string))));
        Arg[] argArray = new Arg[this.FlagTable.size()];
        int n3 = 0;
        Enumeration enumeration = this.FlagTable.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            arg = (Arg)this.FlagTable.get(string2);
            if (arg.Flag2 != null && arg.Flag2 == string2) continue;
            argArray[n3++] = arg;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            for (int i = n2 + 1; i < n3; ++i) {
                if (argArray[n2].Flag1.compareTo(argArray[i].Flag1) <= 0) continue;
                arg = argArray[n2];
                argArray[n2] = argArray[i];
                argArray[i] = arg;
            }
        }
        n2 = -1;
        for (n = 0; n < n3; ++n) {
            int n4 = argArray[n].Flag1.length();
            if (argArray[n].Flag2 != null) {
                n4 += argArray[n].Flag2.length() + 3;
            }
            if (n4 <= n2) continue;
            n2 = n4;
        }
        for (n = 0; n < n3; ++n) {
            int n5 = argArray[n].Flag1.length();
            stringBuffer.append(" ");
            stringBuffer.append(argArray[n].Flag1);
            if (argArray[n].Flag2 != null) {
                stringBuffer.append(" [");
                stringBuffer.append(argArray[n].Flag2);
                stringBuffer.append("]");
                n5 += argArray[n].Flag2.length() + 3;
            }
            int n6 = n2 - n5 + 3;
            for (int i = 0; i < n6; ++i) {
                stringBuffer.append(".");
            }
            stringBuffer.append(argArray[n].Usage);
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    private void verifyNotBuiltin(String string) {
        Name name = (Name)this.NameTable.get(string);
        if (name != null && name.Type == 6) {
            this.fatal(String.valueOf(String.valueOf(new StringBuffer("Cannot redefine builtin name \"").append(string).append("\"."))));
        }
    }

    private void version() {
        System.out.println(this.Version);
    }

    static {
        BOOL = 1;
        STRING = 2;
        LIST = 3;
        PAIR = 4;
        DICT = 5;
        BUILTIN = 6;
    }

    public static final class InvalidTypeException
    extends Exception {
        private final String Name;
        private final int ActualType;
        private final int RequestedType;

        public InvalidTypeException() {
            this.Name = null;
            this.ActualType = -1;
            this.RequestedType = -1;
        }

        public InvalidTypeException(String string, int n, int n2) {
            super(String.valueOf(String.valueOf(new StringBuffer("\"").append(string).append("\" with type ").append(n).append(" was accessed as type ").append(n2).append("."))));
            this.Name = string;
            this.ActualType = n;
            this.RequestedType = n2;
        }
    }

    public static final class MissingNameException
    extends Exception {
        private final String Name;

        public MissingNameException() {
            this.Name = null;
        }

        public MissingNameException(String string) {
            super(String.valueOf(String.valueOf(new StringBuffer("\"").append(string).append("\" not found in command line repository"))));
            this.Name = string;
        }
    }

    private static final class Arg {
        final String Name;
        final int Type;
        final boolean NeedsSpace;
        final String Usage;
        final String Flag1;
        final String Flag2;
        final String AfterString;
        final String AliasFor;

        Arg(String string, String string2, String string3, String string4, String string5, String string6) {
            this.Name = string;
            this.Type = 1;
            this.NeedsSpace = false;
            this.Usage = string2 != null && !string2.equals("") ? string2 : null;
            this.Flag1 = string3 != null && !string3.equals("") ? string3 : null;
            this.Flag2 = string4 != null && !string4.equals("") ? string4 : null;
            this.AfterString = string5 != null && !string5.equals("") ? string5 : null;
            this.AliasFor = string6 != null && !string6.equals("") ? string6 : null;
        }

        Arg(String string, int n, boolean bl, String string2, String string3, String string4, String string5) {
            this.Name = string;
            this.Type = n;
            this.NeedsSpace = bl;
            this.Usage = string2 != null && !string2.equals("") ? string2 : null;
            this.Flag1 = string3 != null && !string3.equals("") ? string3 : null;
            this.Flag2 = null;
            this.AfterString = string4 != null && !string4.equals("") ? string4 : null;
            this.AliasFor = string5 != null && !string5.equals("") ? string5 : null;
        }

        Arg(String string, int n, String string2, String string3, String string4, String string5) {
            this.Name = string;
            this.Type = n;
            this.NeedsSpace = false;
            this.Usage = string2 != null && !string2.equals("") ? string2 : null;
            this.Flag1 = string3 != null && !string3.equals("") ? string3 : null;
            this.Flag2 = null;
            this.AfterString = string4 != null && !string4.equals("") ? string4 : null;
            this.AliasFor = string5 != null && !string5.equals("") ? string5 : null;
        }
    }

    private static final class Name {
        final int Type;
        Object Value;

        Name(int n, Object object) {
            this.Type = n;
            this.Value = object;
        }
    }
}

