/*
 * Decompiled with CFR 0.152.
 */
package com.inprise.vbroker.compiler.util;

import com.inprise.vbroker.compiler.util.Utils;
import com.inprise.vbroker.util.StringFunctions;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public abstract class ErrorReporter {
    public static final Object[] NO_ARGS = new Object[0];
    public static final int FATAL = 0;
    public static final int ERROR = 1;
    public static final int WARNING = 2;
    public static final int ADDON = 3;
    public static final int MESSAGE = 4;
    public boolean _verbose = false;
    public boolean _multipleMessagesPerLine = false;
    private String _toolName;
    protected ResourceBundle _messageTranslations;
    public int _numErrors = 0;
    public int _numWarns = 0;
    public int _maxErrors = Integer.MAX_VALUE;
    public int _maxWarns = Integer.MAX_VALUE;
    public boolean _warnImpliesError = false;
    public boolean _errorImpliesFatal = false;
    public final int _defaultFatalExitCode = 1;
    public int _currentFileNumber;
    public long _currentLineNumber;
    private int _numFiles;
    public String[] _files = new String[50];
    public Hashtable _fileMap = new Hashtable(50);
    public int _previousFileNumber;
    public long _previousLineNumber;
    public int _lastFileNumber;
    public long _lastLineNumber;
    private int _lastErrorFileNumber = -1;
    private long _lastErrorLineNumber;
    private String _lastToolName;
    public boolean _printToStdout = false;
    public boolean _print = true;
    private ExitHandler _exitHandler = new ExitHandler(this){

        public void exit(int n) {
            System.exit(n);
        }
    };

    public ErrorReporter(String string) {
        this._messageTranslations = ResourceBundle.getBundle(string);
    }

    protected ErrorReporter(ResourceBundle resourceBundle) {
        this._messageTranslations = resourceBundle;
    }

    public final void add(String string) {
        this.add(string, NO_ARGS);
    }

    public final void add(String string, Object[] objectArray) {
        this.process(String.valueOf(String.valueOf(this.prolog(this._lastFileNumber, this._lastLineNumber, true))).concat(String.valueOf(String.valueOf(MessageFormat.format(this.getMesg(string), objectArray)))), 3, string, this._lastFileNumber, this._lastLineNumber, objectArray);
    }

    public final boolean error(String string) {
        return this.error(string, this._currentFileNumber, this._currentLineNumber);
    }

    public final boolean error(String string, int n, long l) {
        return this.error(string, n, l, NO_ARGS);
    }

    public final boolean error(String string, int n, long l, String string2) {
        if (string2 == null) {
            this.internalError("null string passed to error function with message ".concat(String.valueOf(String.valueOf(string))));
        }
        return this.error(string, n, l, new Object[]{string2});
    }

    public final boolean error(String string, int n, long l, Object[] objectArray) {
        if (!this.register(true, n, l)) {
            return false;
        }
        this.process(String.valueOf(String.valueOf(this.prolog(n, l, true))).concat(String.valueOf(String.valueOf(MessageFormat.format(this.getMesg(string), objectArray)))), 1, string, n, l, null);
        if (this._errorImpliesFatal) {
            this._exitHandler.exit(1);
        }
        return true;
    }

    public final boolean error(String string, String string2) {
        return this.error(string, this._currentFileNumber, this._currentLineNumber, string2);
    }

    public final boolean error(String string, Object[] objectArray) {
        return this.error(string, this._currentFileNumber, this._currentLineNumber, objectArray);
    }

    public final boolean error2(String string, int n, long l, String string2, int n2, long l2) {
        String string3;
        Object[] objectArray;
        if (!this.register(true, n, l)) {
            return false;
        }
        if (n == n2) {
            objectArray = new Object[]{this.getMesg(string2), new Long(l2)};
            string3 = String.valueOf(String.valueOf(this.prolog(n, l, true))).concat(String.valueOf(String.valueOf(MessageFormat.format(this.getMesg(String.valueOf(String.valueOf(string)).concat("SameFile")), objectArray))));
        } else {
            objectArray = new Object[]{this.getMesg(string2), this._files[n2], new Long(l2)};
            string3 = String.valueOf(String.valueOf(this.prolog(n, l, true))).concat(String.valueOf(String.valueOf(MessageFormat.format(this.getMesg(string), objectArray))));
        }
        this.process(string3, 1, string, n, l, objectArray);
        if (this._errorImpliesFatal) {
            this._exitHandler.exit(1);
        }
        return true;
    }

    public final boolean error2(String string, int n, long l, Object[] objectArray, int n2, long l2) {
        String string2;
        Object[] objectArray2;
        if (!this.register(true, n, l)) {
            return false;
        }
        if (n == n2) {
            objectArray2 = new Object[objectArray.length + 1];
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray2[i] = objectArray[i];
            }
            objectArray2[objectArray.length] = new Long(l2);
            string2 = String.valueOf(String.valueOf(this.prolog(n, l, true))).concat(String.valueOf(String.valueOf(MessageFormat.format(this.getMesg(String.valueOf(String.valueOf(string)).concat("SameFile")), objectArray2))));
        } else {
            objectArray2 = new Object[objectArray.length + 2];
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray2[i] = objectArray[i];
            }
            objectArray2[objectArray.length + 0] = this._files[n2];
            objectArray2[objectArray.length + 1] = new Long(l2);
            string2 = String.valueOf(String.valueOf(this.prolog(n, l, true))).concat(String.valueOf(String.valueOf(MessageFormat.format(this.getMesg(string), objectArray2))));
        }
        this.process(string2, 1, string, n, l, objectArray2);
        if (this._errorImpliesFatal) {
            this._exitHandler.exit(1);
        }
        return true;
    }

    public final boolean error2(String string, String string2) {
        return this.error2(string, this._currentFileNumber, this._currentLineNumber, string2, this._previousFileNumber, this._previousLineNumber);
    }

    public final boolean error2(String string, Object[] objectArray) {
        return this.error2(string, this._currentFileNumber, this._currentLineNumber, objectArray, this._previousFileNumber, this._previousLineNumber);
    }

    public final void fatal(String string) {
        this.fatal(string, 1);
    }

    public final void fatal(String string, int n) {
        this.fatal(string, NO_ARGS, n);
    }

    public final void fatal(String string, Object[] objectArray) {
        this.fatal(string, objectArray, 1);
    }

    public final void fatal(String string, Object[] objectArray, int n) {
        String string2 = MessageFormat.format(this.getMesg(string), objectArray);
        this.process(MessageFormat.format(this.getMesg("Comp.Fatal"), this._toolName, string2), 0, string, -1, -1L, objectArray);
        this._exitHandler.exit(n);
    }

    public String getFileName() {
        return this._files[this._currentFileNumber] == null ? "<<unknown file>>" : this._files[this._currentFileNumber];
    }

    public String getFileName(int n) {
        return this._files[n] == null ? "<<unknown file>>" : this._files[n];
    }

    public final String getMesg(String string) {
        String string2 = "???";
        try {
            string2 = this._messageTranslations.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            System.err.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this._toolName))).append(": unable to translate message: \"").append(string).append("\" (Missing, incomplete or damaged resource bundle?)"))));
            this._exitHandler.exit(1);
        }
        return string2;
    }

    public final ResourceBundle getMessageTranslations() {
        return this._messageTranslations;
    }

    public final int getSummary() {
        return this._numErrors > 0 ? -this._numErrors : this._numWarns;
    }

    public final String getToolName() {
        return this._toolName;
    }

    public final void internalError(String string) {
        if (this._currentFileNumber != -1 && this._currentLineNumber > (long)0) {
            string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer(" (may have happened near line ").append(this._currentLineNumber).append(", file \"").append(this.getFileName()).append("\")"))))));
        }
        this.fatal(this._verbose ? "Comp.VerboseInternal" : "Comp.Internal", new Object[]{string});
    }

    public final void internalError(Throwable throwable) {
        if (this._verbose) {
            this.fatal("Comp.VerboseInternal", new Object[]{"unexpected exception: ".concat(String.valueOf(String.valueOf(Utils.getStackTrace(throwable))))});
        } else {
            this.fatal("Comp.Internal");
        }
    }

    public final void print(String string, Object[] objectArray) {
        this.process(MessageFormat.format(this.getMesg(string), objectArray), 4, string, this._lastFileNumber, this._lastLineNumber, objectArray);
    }

    public final void printUntranslated(String string) {
        this.print("Comp.Tools.printUntranslated", new Object[]{string});
    }

    protected abstract void process(String var1, int var2, String var3, int var4, long var5, Object[] var7);

    private final String prolog(int n, long l, boolean bl) {
        if (l > (long)0) {
            String string = StringFunctions.prepFilename(this._files[n]);
            return MessageFormat.format(this.getMesg(bl ? "Comp.Error" : "Comp.Warn"), string, new Long(l));
        }
        return MessageFormat.format(this.getMesg(bl ? "Comp.ToolError" : "Comp.ToolWarn"), this._toolName);
    }

    private final boolean register(boolean bl, int n, long l) {
        if (this._lastToolName != null && this._lastToolName.equals(this._toolName) && this._lastErrorFileNumber != -1 && this._lastErrorFileNumber == n && this._lastErrorLineNumber == l && !this._multipleMessagesPerLine) {
            return false;
        }
        this._lastFileNumber = n;
        this._lastLineNumber = l;
        if (bl) {
            if (++this._numErrors == this._maxErrors) {
                this.fatal("maxErrorsReached");
            }
            this._lastToolName = this._toolName;
            this._lastErrorFileNumber = n;
            this._lastErrorLineNumber = l;
        } else if (++this._numWarns == this._maxWarns) {
            this.fatal("maxWarnsReached");
        }
        return true;
    }

    public void report() {
    }

    public void setExitHandler(ExitHandler exitHandler) {
        this._exitHandler = exitHandler;
    }

    public int setFile(String string) {
        Object v = this._fileMap.get(string);
        if (v != null) {
            this._currentFileNumber = (Integer)v;
            return this._currentFileNumber;
        }
        int n = this._files.length;
        if (this._numFiles == n) {
            String[] stringArray = new String[n * 2];
            System.arraycopy(this._files, 0, stringArray, 0, n);
            this._files = stringArray;
        }
        this._files[this._numFiles] = string;
        this._fileMap.put(string, new Integer(this._numFiles));
        this._currentFileNumber = this._numFiles;
        return this._numFiles++;
    }

    public final void setToolName(String string) {
        this._toolName = this.getMesg(string);
    }

    public final void unimplemented(String string) {
        this.internalError("unimplemented routine ".concat(String.valueOf(String.valueOf(string))));
    }

    public final void untranslatedMessage(String string) {
        this.process(String.valueOf(String.valueOf(this.prolog(this._lastFileNumber, this._lastLineNumber, true))).concat(String.valueOf(String.valueOf(string))), 4, null, this._lastFileNumber, this._lastLineNumber, NO_ARGS);
    }

    public final boolean warn(String string) {
        return this.warn(string, this._currentFileNumber, this._currentLineNumber);
    }

    public final boolean warn(String string, int n, long l) {
        return this.warn(string, n, l, NO_ARGS);
    }

    public final boolean warn(String string, int n, long l, String string2) {
        if (string2 == null) {
            this.internalError("null string passed to error function with message ".concat(String.valueOf(String.valueOf(string))));
        }
        return this.warn(string, n, l, new Object[]{string2});
    }

    public final boolean warn(String string, int n, long l, Object[] objectArray) {
        if (this._warnImpliesError) {
            return this.error(string, n, l, objectArray);
        }
        if (!this.register(false, n, l)) {
            return false;
        }
        this.process(String.valueOf(String.valueOf(this.prolog(n, l, false))).concat(String.valueOf(String.valueOf(MessageFormat.format(this.getMesg(string), objectArray)))), 2, string, n, l, objectArray);
        return true;
    }

    public final boolean warn(String string, String string2) {
        return this.warn(string, new Object[]{string2});
    }

    public final boolean warn(String string, Object[] objectArray) {
        return this.warn(string, this._currentFileNumber, this._currentLineNumber, objectArray);
    }

    public final boolean warn2(String string, int n, long l, String string2, int n2, long l2) {
        String string3;
        Object[] objectArray;
        if (this._warnImpliesError) {
            return this.error2(string, n, l, string2, n2, l2);
        }
        if (!this.register(false, n, l)) {
            return false;
        }
        if (n == n2) {
            objectArray = new Object[]{this.getMesg(string2), new Long(l2)};
            string3 = String.valueOf(String.valueOf(this.prolog(n, l, false))).concat(String.valueOf(String.valueOf(MessageFormat.format(this.getMesg(String.valueOf(String.valueOf(string)).concat("SameFile")), objectArray))));
        } else {
            objectArray = new Object[]{this.getMesg(string2), this._files[n2], new Long(l2)};
            string3 = String.valueOf(String.valueOf(this.prolog(n, l, false))).concat(String.valueOf(String.valueOf(MessageFormat.format(this.getMesg(string), objectArray))));
        }
        this.process(string3, 2, string, n, l, objectArray);
        return true;
    }

    public final boolean warn2(String string, int n, long l, Object[] objectArray, int n2, long l2) {
        String string2;
        Object[] objectArray2;
        if (this._warnImpliesError) {
            return this.error2(string, n, l, objectArray, n2, l2);
        }
        if (!this.register(false, n, l)) {
            return false;
        }
        if (n == n2) {
            objectArray2 = new Object[objectArray.length + 1];
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray2[i] = objectArray[i];
            }
            objectArray2[objectArray.length] = new Long(l2);
            string2 = String.valueOf(String.valueOf(this.prolog(n, l, false))).concat(String.valueOf(String.valueOf(MessageFormat.format(this.getMesg(String.valueOf(String.valueOf(string)).concat("SameFile")), objectArray2))));
        } else {
            objectArray2 = new Object[objectArray.length + 2];
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray2[i] = objectArray[i];
            }
            objectArray2[objectArray.length + 0] = this._files[n2];
            objectArray2[objectArray.length + 1] = new Long(l2);
            string2 = String.valueOf(String.valueOf(this.prolog(n, l, false))).concat(String.valueOf(String.valueOf(MessageFormat.format(this.getMesg(string), objectArray2))));
        }
        this.process(string2, 2, string, n, l, objectArray2);
        return true;
    }

    public final boolean warn2(String string, String string2) {
        return this.warn2(string, this._currentFileNumber, this._currentLineNumber, string2, this._previousFileNumber, this._previousLineNumber);
    }

    public final boolean warn2(String string, Object[] objectArray) {
        return this.warn2(string, this._currentFileNumber, this._currentLineNumber, objectArray, this._previousFileNumber, this._previousLineNumber);
    }

    public final void warnAdd(String string) {
        if (this._warnImpliesError) {
            this.add(string);
            return;
        }
        this.process(String.valueOf(String.valueOf(this.prolog(this._lastFileNumber, this._lastLineNumber, false))).concat(String.valueOf(String.valueOf(this.getMesg(string)))), 3, string, this._lastFileNumber, this._lastLineNumber, NO_ARGS);
    }

    static {
        FATAL = 0;
        ERROR = 1;
        WARNING = 2;
        ADDON = 3;
        MESSAGE = 4;
    }

    public static interface ExitHandler {
        public void exit(int var1);
    }
}

