/*
 * Decompiled with CFR 0.152.
 */
package com.inprise.vbroker.util;

public final class SimpleStringBuffer {
    public static final int DEFAULT_CAPACITY = 1024;
    private int Length;
    private char[] Data;

    public SimpleStringBuffer() {
        this(1024);
    }

    public SimpleStringBuffer(int n) {
        this.Data = new char[n];
        this.Length = 0;
    }

    public SimpleStringBuffer(String string) {
        this(string.length());
        this.append(string);
    }

    public void append(char c) {
        this.append(c, 1);
    }

    public void append(char c, int n) {
        if (this.Length + n > this.Data.length) {
            this.expand(this.Length + n - this.Data.length);
        }
        for (int i = 0; i < n; ++i) {
            this.Data[this.Length++] = c;
        }
    }

    public void append(SimpleStringBuffer simpleStringBuffer) {
        this.ensureCapacity(this.Length + simpleStringBuffer.Length);
        for (int i = 0; i < simpleStringBuffer.Length; ++i) {
            this.Data[this.Length++] = simpleStringBuffer.Data[i];
        }
    }

    public void append(String string) {
        int n = string.length();
        if (this.Length + n > this.Data.length) {
            this.expand(this.Length + n - this.Data.length);
        }
        string.getChars(0, n, this.Data, this.Length);
        this.Length += n;
    }

    public void append(String string, int n) {
        if (this.Length + n > this.Data.length) {
            this.expand(this.Length + n - this.Data.length);
        }
        string.getChars(0, n, this.Data, this.Length);
        this.Length += n;
    }

    public void ensureCapacity(int n) {
        if (this.Data.length < n) {
            char[] cArray = new char[n];
            System.arraycopy(this.Data, 0, cArray, 0, this.Data.length);
            this.Data = cArray;
        }
    }

    public boolean equals(String string) {
        if (this.Length != string.length()) {
            return false;
        }
        for (int i = 0; i < this.Length; ++i) {
            if (this.Data[i] == string.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(char[] cArray) {
        if (this.Length != cArray.length) {
            return false;
        }
        for (int i = 0; i < this.Length; ++i) {
            if (this.Data[i] == cArray[i]) continue;
            return false;
        }
        return true;
    }

    private void expand(int n) {
        this.ensureCapacity(SimpleStringBuffer.max(this.Data.length * 2, this.Data.length + n));
    }

    public int length() {
        return this.Length;
    }

    public static int max(int n, int n2) {
        return n >= n2 ? n : n2;
    }

    public void reset() {
        this.Length = 0;
    }

    public void reset(int n) throws IllegalArgumentException {
        if (n > this.Length) {
            throw new IllegalArgumentException(String.valueOf(String.valueOf(new StringBuffer("").append(n).append(" exceeds current length of ").append(this.Length))));
        }
        this.Length = n;
    }

    public char[] toReadOnlyArray() {
        return this.Data;
    }

    public String toString() {
        return new String(this.Data, 0, this.Length);
    }

    static {
        DEFAULT_CAPACITY = 1024;
    }
}

