/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.console;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.ui.internal.console.HyperlinkUpdater;

public class ConsoleDocument
extends Document {
    private static final char NEW_LINE = '\n';
    private static final char BACK_SPACE = '\b';
    private static final char CARRIAGE_RETURN = '\r';
    private static final char FORM_FEED = '\f';

    public synchronized String get(int pos, int length) throws BadLocationException {
        return super.get(pos, length);
    }

    public synchronized int getLength() {
        return super.getLength();
    }

    public synchronized String getLineDelimiter(int line) throws BadLocationException {
        return super.getLineDelimiter(line);
    }

    public synchronized IRegion getLineInformation(int line) throws BadLocationException {
        return super.getLineInformation(line);
    }

    public synchronized IRegion getLineInformationOfOffset(int offset) throws BadLocationException {
        return super.getLineInformationOfOffset(offset);
    }

    public synchronized int getLineLength(int line) throws BadLocationException {
        return super.getLineLength(line);
    }

    public synchronized int getLineOffset(int line) throws BadLocationException {
        return super.getLineOffset(line);
    }

    public int getLineOfOffset(int pos) throws BadLocationException {
        return super.getLineOfOffset(pos);
    }

    public synchronized int getNumberOfLines() {
        return super.getNumberOfLines();
    }

    public synchronized void replace(int pos, int length, String text) throws BadLocationException {
        if (ConsoleDocument.containsControlCharacter(text)) {
            int lengthDelta;
            int actualPosition;
            StringBuilder buffer;
            boolean endsWithNewLIne;
            int lineNumber = this.getTracker().getLineNumberOfOffset(pos);
            boolean bl = endsWithNewLIne = this.getLineDelimiter(lineNumber) != null;
            if (endsWithNewLIne) {
                buffer = new StringBuilder(length);
                actualPosition = pos;
                lengthDelta = 0;
            } else {
                IRegion lineInformation = this.getLineInformation(lineNumber);
                actualPosition = lineInformation.getOffset();
                int lineLength = lineInformation.getLength();
                buffer = new StringBuilder(length + lineLength);
                String line = this.get(lineInformation.getOffset(), lineLength);
                buffer.append(line);
                lengthDelta = lineLength;
            }
            int offset = 0;
            int lineStart = 0;
            DelimiterInfo delimiterInfo = ConsoleDocument.nextDelimiterInfo(text, offset);
            while (delimiterInfo != null) {
                ConsoleDocument.processLine(text, offset, lineStart, delimiterInfo.delimiterIndex - offset, buffer);
                buffer.append(text, delimiterInfo.delimiterIndex, delimiterInfo.delimiterIndex + delimiterInfo.delimiterLength);
                offset = delimiterInfo.delimiterIndex + delimiterInfo.delimiterLength;
                delimiterInfo = ConsoleDocument.nextDelimiterInfo(text, offset);
                lineStart = buffer.length();
            }
            ConsoleDocument.processLine(text, offset, lineStart, text.length() - offset, buffer);
            String processedText = buffer.toString();
            super.replace(actualPosition, length + lengthDelta, processedText);
        } else {
            super.replace(pos, length, text);
        }
    }

    public synchronized void set(String text) {
        super.set(text);
    }

    protected void completeInitialization() {
        super.completeInitialization();
        this.addPositionUpdater((IPositionUpdater)new HyperlinkUpdater());
    }

    public synchronized void addPosition(String category, Position position) throws BadLocationException, BadPositionCategoryException {
        super.addPosition(category, position);
    }

    public synchronized void removePosition(String category, Position position) throws BadPositionCategoryException {
        super.removePosition(category, position);
    }

    public synchronized Position[] getPositions(String category) throws BadPositionCategoryException {
        return super.getPositions(category);
    }

    private static boolean containsControlCharacter(String text) {
        int length = text.length();
        int i = 0;
        while (i < length) {
            char ch = text.charAt(i);
            if (ch == '\b' || ch == '\f') {
                return true;
            }
            if (ch == '\r') {
                if (i + 1 < length && text.charAt(i + 1) == '\n') {
                    i += 2;
                    continue;
                }
                return true;
            }
            ++i;
        }
        return false;
    }

    private static void processLine(String text, int start, int initialLineStart, int length, StringBuilder buffer) {
        if (length == 0) {
            return;
        }
        int insertIndex = buffer.length();
        int lineStart = initialLineStart;
        int end = start + length;
        int i = start;
        while (i < end) {
            char ch = text.charAt(i);
            if (ch == '\b') {
                if (insertIndex > lineStart) {
                    --insertIndex;
                }
            } else if (ch == '\r') {
                insertIndex = lineStart;
            } else if (ch == '\f') {
                int headPosition = insertIndex - lineStart;
                buffer.append('\n');
                lineStart = buffer.length();
                int j = 0;
                while (j < headPosition) {
                    buffer.append(' ');
                    ++j;
                }
                insertIndex = lineStart + headPosition;
            } else {
                if (insertIndex == buffer.length()) {
                    buffer.append(ch);
                } else {
                    buffer.setCharAt(insertIndex, ch);
                }
                ++insertIndex;
            }
            ++i;
        }
    }

    private static DelimiterInfo nextDelimiterInfo(String text, int offset) {
        int length = text.length();
        int i = offset;
        while (i < length) {
            char ch = text.charAt(i);
            if (ch == '\r') {
                if (i + 1 < length && text.charAt(i + 1) == '\n') {
                    return new DelimiterInfo(i, 2);
                }
            } else if (ch == '\n') {
                return new DelimiterInfo(i, 1);
            }
            ++i;
        }
        return null;
    }

    static final class DelimiterInfo {
        int delimiterIndex;
        int delimiterLength;

        DelimiterInfo(int delimiterIndex, int delimiterLength) {
            this.delimiterIndex = delimiterIndex;
            this.delimiterLength = delimiterLength;
        }
    }
}

