/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.json.core.internal.schema;

import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.json.schema.IJSONSchemaDocument;
import org.eclipse.json.schema.IJSONSchemaProcessor;
import org.eclipse.wst.common.uriresolver.internal.provisional.URIResolverPlugin;
import org.eclipse.wst.common.uriresolver.internal.util.URIHelper;
import org.eclipse.wst.json.core.JSONCorePlugin;
import org.eclipse.wst.json.core.document.IJSONModel;
import org.eclipse.wst.json.core.document.IJSONNode;
import org.eclipse.wst.json.core.internal.Logger;

public class SchemaProcessorRegistryReader {
    protected static final String EXTENSION_POINT_ID = "schemaProcessors";
    protected static final String TAG_CONTRIBUTION = "schemaProcessor";
    public static SchemaProcessorRegistryReader INSTANCE = null;
    private IJSONSchemaProcessor defaultProcessor;

    public static SchemaProcessorRegistryReader getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new SchemaProcessorRegistryReader();
            INSTANCE.readRegistry();
        }
        return INSTANCE;
    }

    public IJSONSchemaProcessor getDefaultProcessor() {
        return this.defaultProcessor;
    }

    public IJSONSchemaDocument getSchemaDocument(IJSONNode node) throws IOException {
        return this.getSchemaDocument(node.getModel());
    }

    public IJSONSchemaDocument getSchemaDocument(IJSONModel model) throws IOException {
        String schemaURL;
        IJSONSchemaProcessor processor = this.getDefaultProcessor();
        if (processor == null) {
            return null;
        }
        String base = model.getResolver().getFileBaseLocation();
        if (base != null) {
            base = URIHelper.addImpliedFileProtocol((String)base);
        }
        if ((schemaURL = this.resolve(base, null, null)) != null) {
            return processor.getSchema(schemaURL);
        }
        return null;
    }

    private String getFileMatch(String location) {
        if (location == null) {
            return null;
        }
        int index = location.lastIndexOf(47);
        if (index == -1) {
            index = location.lastIndexOf(92);
        }
        if (index != -1) {
            return location.substring(index, location.length());
        }
        return location;
    }

    private String resolve(String base, String publicId, String systemId) {
        String result = systemId;
        result = URIResolverPlugin.createResolver().resolve(base, publicId, systemId);
        return result;
    }

    protected void readRegistry() {
        IExtensionRegistry pluginRegistry = Platform.getExtensionRegistry();
        IExtensionPoint point = pluginRegistry.getExtensionPoint(JSONCorePlugin.getDefault().getBundle().getSymbolicName(), EXTENSION_POINT_ID);
        if (point != null) {
            IConfigurationElement[] elements = point.getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                this.readElement(elements[i]);
                ++i;
            }
        }
    }

    protected void readElement(IConfigurationElement element) {
        if (TAG_CONTRIBUTION.equals(element.getName())) {
            element.getAttribute("id");
            element.getAttribute("name");
            try {
                IJSONSchemaProcessor schemaProcessor;
                this.defaultProcessor = schemaProcessor = (IJSONSchemaProcessor)element.createExecutableExtension("class");
            }
            catch (CoreException e) {
                Logger.logException(e);
            }
        }
    }
}

