/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.json.core.internal.schema.catalog;

import java.io.IOException;
import java.net.MalformedURLException;
import org.eclipse.core.resources.IFile;
import org.eclipse.wst.common.uriresolver.internal.provisional.URIResolverExtension;
import org.eclipse.wst.json.core.JSONCorePlugin;
import org.eclipse.wst.json.core.internal.JSONCoreMessages;
import org.eclipse.wst.json.core.internal.Logger;
import org.eclipse.wst.json.core.schema.catalog.ICatalog;

public class JSONCatalogURIResolverExtension
implements URIResolverExtension {
    public String resolve(IFile file, String baseLocation, String publicId, String systemId) {
        ICatalog catalog = JSONCorePlugin.getDefault().getDefaultJSONCatalog();
        if (catalog == null) {
            Logger.log(204, JSONCoreMessages.Catalog_resolution_null_catalog);
            return null;
        }
        if (publicId != null || systemId != null) {
            return null;
        }
        try {
            return catalog.resolveSchema(file.getName());
        }
        catch (MalformedURLException malformedURLException) {
            Logger.log(204, JSONCoreMessages.Catalog_resolution_malformed_url);
            return null;
        }
        catch (IOException iOException) {
            Logger.log(204, JSONCoreMessages.Catalog_resolution_io_exception);
            return null;
        }
    }
}

