/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.js.common.build.system.launch.ui;

import java.io.File;
import java.util.ArrayList;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.js.common.CommonPlugin;
import org.eclipse.wst.jsdt.js.common.Messages;
import org.eclipse.wst.jsdt.js.common.build.system.ITask;
import org.eclipse.wst.jsdt.js.common.build.system.ui.IFileSelectionDialog;
import org.eclipse.wst.jsdt.js.common.util.WorkbenchResourceUtil;

public abstract class GenericBuildSystemTab
extends AbstractLaunchConfigurationTab {
    private WidgetListener defaultListener = new WidgetListener();
    protected Text buildFileText;
    protected Combo tasksCommbo;

    protected abstract String[] getTasksFromFile(IFile var1) throws JavaScriptModelException;

    public void createControl(Composite parent) {
        Composite comp = SWTFactory.createComposite((Composite)parent, (Font)parent.getFont(), (int)1, (int)1, (int)1808);
        ((GridLayout)comp.getLayout()).verticalSpacing = 0;
        this.createBuildFileEditor(comp);
        this.createTaskComboEditor(comp);
        this.setControl((Control)comp);
    }

    private void createTaskComboEditor(Composite parent) {
        Group group = SWTFactory.createGroup((Composite)parent, (String)Messages.LaunchTab_Tasks, (int)1, (int)1, (int)768);
        this.tasksCommbo = SWTFactory.createCombo((Composite)group, (int)2304, (int)0, null);
        this.tasksCommbo.addModifyListener((ModifyListener)this.defaultListener);
    }

    private void createBuildFileEditor(Composite parent) {
        Group group = SWTFactory.createGroup((Composite)parent, (String)Messages.LaunchTab_BuildFile, (int)2, (int)1, (int)768);
        this.buildFileText = SWTFactory.createSingleText((Composite)group, (int)1);
        this.buildFileText.addModifyListener((ModifyListener)this.defaultListener);
        Button fileButton = this.createPushButton((Composite)group, Messages.LaunchTab_Browse, null);
        fileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GenericBuildSystemTab.this.handleBuildFileButtonSelected();
            }
        });
    }

    public String getName() {
        return Messages.LaunchTab_Main;
    }

    protected void updateTasks(String[] tasks) {
        if (this.tasksCommbo != null && !this.tasksCommbo.isDisposed()) {
            this.tasksCommbo.removeAll();
            if (tasks != null && tasks.length > 0) {
                this.tasksCommbo.setItems(tasks);
                this.tasksCommbo.setText(tasks[0]);
            }
        }
    }

    protected void handleBuildFileButtonSelected() {
        IFileSelectionDialog dialog = new IFileSelectionDialog(Messages.LaunchTab_DialogTitle, Messages.LaunchTab_DialogMessage, new String[]{"js"});
        dialog.open();
        Object result = dialog.getFirstResult();
        if (result instanceof IFile) {
            this.buildFileText.setText(((IFile)result).getLocation().toOSString());
        }
    }

    IDialogSettings getDialogBoundsSettings(String id) {
        IDialogSettings settings = CommonPlugin.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(id);
        if (section == null) {
            section = settings.addNewSection(id);
        }
        return section;
    }

    protected IFile getBuildFile() {
        String path;
        File file;
        if (this.buildFileText != null && !this.buildFileText.isDisposed() && (file = WorkbenchResourceUtil.getFile(path = this.buildFileText.getText())) != null) {
            return WorkbenchResourceUtil.getFileForLocation(file.getAbsolutePath());
        }
        return null;
    }

    protected String[] getTaskNames(Set<ITask> tasks) {
        ArrayList<String> names = new ArrayList<String>();
        if (!tasks.isEmpty()) {
            for (ITask task : tasks) {
                names.add(task.getName());
            }
        }
        return names.toArray(new String[names.size()]);
    }

    private class WidgetListener
    implements ModifyListener,
    SelectionListener {
        private WidgetListener() {
        }

        public void modifyText(ModifyEvent e) {
            GenericBuildSystemTab.this.updateLaunchConfigurationDialog();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            GenericBuildSystemTab.this.updateLaunchConfigurationDialog();
        }
    }
}

