/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.lib.archive;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.cloudfoundry.client.lib.archive.AbstractApplicationArchiveEntry;
import org.cloudfoundry.client.lib.archive.ApplicationArchive;
import org.springframework.util.Assert;

public class ZipApplicationArchive
implements ApplicationArchive {
    private ZipFile zipFile;
    private List<ApplicationArchive.Entry> entries;
    private String fileName;

    public ZipApplicationArchive(ZipFile zipFile) {
        Assert.notNull((Object)zipFile, (String)"ZipFile must not be null");
        this.zipFile = zipFile;
        this.entries = this.adaptZipEntries(zipFile);
        this.fileName = new File(zipFile.getName()).getName();
    }

    private List<ApplicationArchive.Entry> adaptZipEntries(ZipFile zipFile) {
        ArrayList<EntryAdapter> entries = new ArrayList<EntryAdapter>();
        Enumeration<? extends ZipEntry> zipEntries = zipFile.entries();
        while (zipEntries.hasMoreElements()) {
            entries.add(new EntryAdapter(zipEntries.nextElement()));
        }
        return Collections.unmodifiableList(entries);
    }

    @Override
    public Iterable<ApplicationArchive.Entry> getEntries() {
        return this.entries;
    }

    @Override
    public String getFilename() {
        return this.fileName;
    }

    private class EntryAdapter
    extends AbstractApplicationArchiveEntry {
        private ZipEntry entry;

        public EntryAdapter(ZipEntry entry) {
            this.entry = entry;
        }

        @Override
        public boolean isDirectory() {
            return this.entry.isDirectory();
        }

        @Override
        public String getName() {
            return this.entry.getName();
        }

        @Override
        public long getSize() {
            return this.entry.getSize();
        }

        @Override
        public InputStream getInputStream() throws IOException {
            if (this.isDirectory()) {
                return null;
            }
            return ZipApplicationArchive.this.zipFile.getInputStream(this.entry);
        }
    }
}

