/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.lib.rest;

import java.io.IOException;
import java.util.Map;
import org.cloudfoundry.client.lib.CloudFoundryException;
import org.cloudfoundry.client.lib.NotFinishedStagingException;
import org.cloudfoundry.client.lib.StagingErrorException;
import org.cloudfoundry.client.lib.org.codehaus.jackson.JsonParseException;
import org.cloudfoundry.client.lib.org.codehaus.jackson.map.ObjectMapper;
import org.cloudfoundry.client.lib.util.CloudUtil;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.web.client.DefaultResponseErrorHandler;
import org.springframework.web.client.HttpServerErrorException;
import org.springframework.web.client.RestClientException;

public class CloudControllerResponseErrorHandler
extends DefaultResponseErrorHandler {
    public void handleError(ClientHttpResponse response) throws IOException {
        HttpStatus statusCode = response.getStatusCode();
        switch (statusCode.series()) {
            case CLIENT_ERROR: {
                throw CloudControllerResponseErrorHandler.getException(response);
            }
            case SERVER_ERROR: {
                throw new HttpServerErrorException(statusCode, response.getStatusText());
            }
        }
        throw new RestClientException("Unknown status code [" + statusCode + "]");
    }

    private static CloudFoundryException getException(ClientHttpResponse response) throws IOException {
        HttpStatus statusCode = response.getStatusCode();
        CloudFoundryException cloudFoundryException = null;
        String description = "Client error";
        String statusText = response.getStatusText();
        ObjectMapper mapper = new ObjectMapper();
        if (response.getBody() != null) {
            try {
                Map map = mapper.readValue(response.getBody(), Map.class);
                description = CloudUtil.parse(String.class, map.get("description"));
                int cloudFoundryErrorCode = CloudUtil.parse(Integer.class, map.get("code"));
                if (cloudFoundryErrorCode >= 0) {
                    switch (cloudFoundryErrorCode) {
                        case 170001: {
                            cloudFoundryException = new StagingErrorException(statusCode, statusText);
                            break;
                        }
                        case 170002: {
                            cloudFoundryException = new NotFinishedStagingException(statusCode, statusText);
                        }
                    }
                }
            }
            catch (JsonParseException jsonParseException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (cloudFoundryException == null) {
            cloudFoundryException = new CloudFoundryException(statusCode, statusText);
        }
        cloudFoundryException.setDescription(description);
        return cloudFoundryException;
    }
}

