/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.lib.rest;

import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import javax.websocket.Session;
import org.cloudfoundry.client.lib.StreamingLogToken;

public class StreamingLogTokenImpl
implements StreamingLogToken {
    private static long keepAliveTime = 25000L;
    private Timer keepAliveTimer = new Timer(true);
    private Session session;

    public StreamingLogTokenImpl(Session session) {
        this.session = session;
        this.keepAliveTimer.scheduleAtFixedRate((TimerTask)new KeepAliveTimerTask(), keepAliveTime, keepAliveTime);
    }

    @Override
    public void cancel() {
        this.keepAliveTimer.cancel();
        try {
            this.session.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private class KeepAliveTimerTask
    extends TimerTask {
        private KeepAliveTimerTask() {
        }

        @Override
        public void run() {
            if (StreamingLogTokenImpl.this.session.isOpen()) {
                StreamingLogTokenImpl.this.session.getAsyncRemote().sendText("keep alive");
            } else {
                StreamingLogTokenImpl.this.keepAliveTimer.cancel();
            }
        }
    }
}

