/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.lib.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;

public class Multipart {
    public static final String CRLF = "\r\n";
    public static final String DASHES = "--";
    private final InputStream input;
    private final String boundary;
    private final String eomBoundary;
    private boolean firstPart = true;
    private ByteArrayOutputStream byteBuffer = new ByteArrayOutputStream(1024);
    private byte[] prevHeader;

    public Multipart(InputStream input, String boundary) {
        this.input = input;
        this.boundary = DASHES + boundary + CRLF;
        this.eomBoundary = DASHES + boundary + DASHES;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Part nextPart() {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        byte[] line = this.readLine(this.input);
        while (line.length > 0) {
            if (this.isBoundaryLine(line)) {
                byte[] header = this.trimCRLF(this.readLine(this.input));
                if (!this.firstPart) {
                    Part part = new Part(this.trimCRLF(output.toByteArray()), this.prevHeader);
                    this.prevHeader = header;
                    return part;
                }
                this.firstPart = false;
                this.prevHeader = header;
            } else {
                if (this.isEomBoundaryLine(line)) {
                    this.drainInput();
                    if (this.firstPart) {
                        return null;
                    }
                    return new Part(this.trimCRLF(output.toByteArray()), this.prevHeader);
                }
                try {
                    output.write(line);
                }
                catch (IOException e) {
                    this.rethrow(e);
                }
            }
            line = this.readLine(this.input);
        }
        byte[] content = output.toByteArray();
        if (content.length > 0) {
            return new Part(content, this.prevHeader);
        }
        return null;
    }

    private byte[] readLine(InputStream input) {
        this.byteBuffer.reset();
        try {
            int value;
            while ((value = input.read()) != -1) {
                this.byteBuffer.write(value);
                if (value != 10) continue;
                break;
            }
        }
        catch (IOException e) {
            return this.rethrow(e);
        }
        return this.byteBuffer.toByteArray();
    }

    private void drainInput() {
        try {
            this.input.skip(this.input.available());
        }
        catch (IOException e) {
            this.rethrow(e);
        }
    }

    private byte[] trimCRLF(byte[] bytes) {
        if (this.endsWithCRLF(bytes)) {
            return Arrays.copyOf(bytes, bytes.length - 2);
        }
        return bytes;
    }

    private boolean endsWithCRLF(byte[] bytes) {
        int length = bytes.length;
        if (length < 2) {
            return false;
        }
        return bytes[length - 2] == 13 && bytes[length - 1] == 10;
    }

    private boolean isBoundaryLine(byte[] line) {
        return new String(line).equals(this.boundary);
    }

    private boolean isEomBoundaryLine(byte[] line) {
        return new String(line).startsWith(this.eomBoundary);
    }

    private byte[] rethrow(IOException e) {
        throw new RuntimeException("Error reading multipart message", e);
    }

    public class Part {
        private byte[] content;
        private String header;

        Part(byte[] content, byte[] header) {
            this.content = content;
            this.header = new String(header);
        }

        public byte[] getContent() {
            return this.content;
        }

        public String getHeader() {
            return this.header;
        }
    }
}

