/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal.ast;

import org.eclipse.wst.xml.xpath2.api.Item;
import org.eclipse.wst.xml.xpath2.api.ResultSequence;
import org.eclipse.wst.xml.xpath2.api.StaticContext;
import org.eclipse.wst.xml.xpath2.api.typesystem.TypeDefinition;
import org.eclipse.wst.xml.xpath2.api.typesystem.TypeModel;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.AttrElemTest;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.XPathVisitor;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.ElementType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.NodeType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ElementTest
extends AttrElemTest {
    private boolean _qmark = false;
    private AnyType anyType = null;
    static /* synthetic */ Class class$0;

    public ElementTest(QName name, boolean wild, QName type, boolean qmark) {
        super(name, wild, type);
        this._qmark = qmark;
    }

    public ElementTest(QName name, boolean wild, QName type) {
        super(name, wild, type);
    }

    public ElementTest(QName name, boolean wild) {
        super(name, wild);
    }

    public ElementTest() {
    }

    public Object accept(XPathVisitor v) {
        return v.visit(this);
    }

    public boolean qmark() {
        return this._qmark;
    }

    public AnyType createTestType(ResultSequence rs, StaticContext sc) {
        if (this.name() == null && !this.wild()) {
            return new ElementType();
        }
        Item at = rs.first();
        if (!(at instanceof NodeType)) {
            return new ElementType();
        }
        return this.createElementType(at, sc);
    }

    private AnyType createElementType(Item at, StaticContext sc) {
        this.anyType = new ElementType();
        NodeType nodeType = (NodeType)at;
        Node node = nodeType.node_value();
        Document doc = null;
        doc = node.getNodeType() == 9 ? (Document)node : nodeType.node_value().getOwnerDocument();
        NodeList nodeList = null;
        nodeList = !this.wild() ? doc.getElementsByTagNameNS(this.name().namespace(), this.name().local()) : new SingleItemNodeListImpl(node);
        if (nodeList.getLength() > 0) {
            this.anyType = this.createElementForXSDType(nodeList, sc);
        }
        return this.anyType;
    }

    private AnyType createElementForXSDType(NodeList nodeList, StaticContext sc) {
        int i = 0;
        while (i < nodeList.getLength()) {
            Element element = (Element)nodeList.item(i);
            TypeModel typeModel = sc.getTypeModel();
            TypeDefinition typedef = typeModel.getType(element);
            if (this.type() == null || typedef == null) {
                this.anyType = new ElementType(element, typeModel);
                break;
            }
            if (typedef.derivedFrom(this.type().namespace(), this.type().local(), this.getDerviationTypes())) {
                this.anyType = new ElementType(element, typeModel);
                break;
            }
            ++i;
        }
        return this.anyType;
    }

    public boolean isWild() {
        return this.wild();
    }

    public Class getXDMClassType() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.xml.xpath2.processor.internal.types.ElementType");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    private static class SingleItemNodeListImpl
    implements NodeList {
        private Node node;

        public SingleItemNodeListImpl(Node node) {
            this.node = node;
        }

        public Node item(int index) {
            return this.node;
        }

        public int getLength() {
            if (this.node != null) {
                return 1;
            }
            return 0;
        }
    }
}

