/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.core.util;

import java.lang.reflect.Field;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.epp.internal.mpc.core.MarketplaceClientCore;
import org.eclipse.epp.internal.mpc.core.MarketplaceClientCorePlugin;
import org.eclipse.epp.internal.mpc.core.util.Messages;
import org.osgi.util.tracker.ServiceTracker;

public class ProxyHelper {
    private static ProxyAuthenticator authenticator;
    private static ServiceTracker proxyServiceTracker;

    public static synchronized void acquireProxyService() {
        if (proxyServiceTracker == null) {
            proxyServiceTracker = new ServiceTracker(MarketplaceClientCorePlugin.getBundle().getBundleContext(), IProxyService.class.getName(), null);
            proxyServiceTracker.open();
        }
        Authenticator defaultAuthenticator = ProxyHelper.getDefaultAuthenticator();
        if (authenticator == null || authenticator != defaultAuthenticator) {
            authenticator = defaultAuthenticator instanceof ProxyAuthenticator ? (ProxyAuthenticator)defaultAuthenticator : new ProxyAuthenticator(defaultAuthenticator);
            Authenticator.setDefault(authenticator);
        }
    }

    public static synchronized void releaseProxyService() {
        Authenticator defaultAuthenticator = ProxyHelper.getDefaultAuthenticator();
        if (authenticator != null) {
            if (defaultAuthenticator == authenticator) {
                Authenticator.setDefault(authenticator.getDelegate());
            }
            authenticator = null;
        }
        if (proxyServiceTracker != null) {
            proxyServiceTracker.close();
        }
    }

    public static IProxyData getProxyData(String url) {
        IProxyService proxyService = ProxyHelper.getProxyService();
        if (proxyService != null) {
            URI uri;
            try {
                uri = new URI(url);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e.getMessage(), e);
            }
            IProxyData[] proxyData = proxyService.select(uri);
            if (proxyData != null && proxyData.length > 0 && proxyData[0] != null) {
                IProxyData pd = proxyData[0];
                return pd;
            }
        }
        return null;
    }

    protected static IProxyService getProxyService() {
        return proxyServiceTracker == null ? null : (IProxyService)proxyServiceTracker.getService();
    }

    private static Authenticator getDefaultAuthenticator() {
        Field authenticatorField = Authenticator.class.getDeclaredField("theAuthenticator");
        boolean accessible = authenticatorField.isAccessible();
        try {
            if (!accessible) {
                authenticatorField.setAccessible(true);
            }
            Authenticator authenticator = (Authenticator)authenticatorField.get(null);
            if (!accessible) {
                authenticatorField.setAccessible(false);
            }
            return authenticator;
        }
        catch (Throwable throwable) {
            try {
                if (!accessible) {
                    authenticatorField.setAccessible(false);
                }
                throw throwable;
            }
            catch (Exception e) {
                MarketplaceClientCore.getLog().log((IStatus)new Status(2, "org.eclipse.epp.mpc.core", Messages.ProxyHelper_replacingAuthenticator, (Throwable)e));
                return null;
            }
        }
    }

    private static class ProxyAuthenticator
    extends Authenticator {
        private final Authenticator delegate;

        public ProxyAuthenticator(Authenticator delegate) {
            if (delegate instanceof ProxyAuthenticator) {
                delegate = ((ProxyAuthenticator)delegate).getDelegate();
            }
            this.delegate = delegate;
        }

        protected PasswordAuthentication getPasswordAuthentication() {
            IProxyService proxyService;
            if (this.getRequestorType() == Authenticator.RequestorType.PROXY && (proxyService = ProxyHelper.getProxyService()) != null && proxyService.isProxiesEnabled()) {
                IProxyData[] proxies;
                URL requestingURL = this.getRequestingURL();
                if (requestingURL == null) {
                    proxies = proxyService.getProxyData();
                } else {
                    try {
                        proxies = proxyService.select(requestingURL.toURI());
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        proxies = proxyService.getProxyData();
                    }
                }
                IProxyData[] iProxyDataArray = proxies;
                int n = proxies.length;
                int n2 = 0;
                while (n2 < n) {
                    IProxyData proxyData = iProxyDataArray[n2];
                    if (proxyData.isRequiresAuthentication() && proxyData.getPort() == this.getRequestingPort() && proxyData.getHost().equals(this.getRequestingHost())) {
                        String userId = proxyData.getUserId();
                        String password = proxyData.getPassword();
                        if (userId != null && password != null) {
                            return new PasswordAuthentication(userId, password.toCharArray());
                        }
                    }
                    ++n2;
                }
            }
            if (this.delegate != null) {
                try {
                    Authenticator.setDefault(this.delegate);
                    Authenticator.requestPasswordAuthentication(this.getRequestingHost(), this.getRequestingSite(), this.getRequestingPort(), this.getRequestingProtocol(), this.getRequestingPrompt(), this.getRequestingScheme(), this.getRequestingURL(), this.getRequestorType());
                }
                finally {
                    Authenticator.setDefault(this);
                }
            }
            return null;
        }

        public Authenticator getDelegate() {
            return this.delegate;
        }
    }
}

