/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.useractions.ui.compile;

import java.util.Collection;
import java.util.Vector;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.internal.useractions.ui.ISystemCommandTextAdditionalGUIProvider;
import org.eclipse.rse.internal.useractions.ui.SystemCmdSubstVarList;
import org.eclipse.rse.internal.useractions.ui.SystemCommandTextField;
import org.eclipse.rse.internal.useractions.ui.SystemCommandViewerConfiguration;
import org.eclipse.rse.internal.useractions.ui.compile.ISystemCompileCommandEditPaneHoster;
import org.eclipse.rse.internal.useractions.ui.compile.ISystemCompileCommandEditPaneListener;
import org.eclipse.rse.internal.useractions.ui.compile.SystemCompileCommand;
import org.eclipse.rse.internal.useractions.ui.compile.SystemCompileManager;
import org.eclipse.rse.internal.useractions.ui.compile.SystemCompileType;
import org.eclipse.rse.internal.useractions.ui.uda.SystemUDAResources;
import org.eclipse.rse.internal.useractions.ui.validators.ValidatorCompileCommandLabel;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.shells.ui.view.ISystemCommandTextModifyListener;
import org.eclipse.rse.ui.ISystemMassager;
import org.eclipse.rse.ui.SystemWidgetHelpers;
import org.eclipse.rse.ui.validators.ISystemValidator;
import org.eclipse.rse.ui.validators.ISystemValidatorUniqueString;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SystemCompileCommandEditPane
implements SelectionListener,
ISystemCommandTextAdditionalGUIProvider,
ISystemCommandTextModifyListener {
    protected Shell shell;
    protected ISystemCompileCommandEditPaneHoster hoster;
    protected SystemCompileManager compileManager;
    protected SystemCompileCommand inputCompileCommand;
    protected SystemCompileType parentCompileType;
    protected Vector listeners = new Vector();
    protected SystemCmdSubstVarList varList;
    protected boolean newMode = true;
    protected boolean ignoreChanges;
    protected Label labelLabel;
    protected Text textLabel;
    protected SystemCommandTextField commandField;
    protected SystemMessage errorMessage;
    protected boolean skipEventFiring;
    protected boolean fromVerify;
    protected boolean caseSensitive;
    protected Control controlInError = null;
    protected ISystemValidator cmdLabelValidator;

    public SystemCompileCommandEditPane(SystemCompileManager compileManager, Shell shell, ISystemCompileCommandEditPaneHoster owner, boolean caseSensitive) {
        this.compileManager = compileManager;
        this.shell = shell;
        this.caseSensitive = caseSensitive;
        this.commandField = new SystemCommandTextField(this.getCommandTextViewerConfiguration());
        this.commandField.setSubstitutionVariableList(compileManager.getSubstitutionVariableList());
        this.hoster = owner;
    }

    protected Shell getShell() {
        return this.shell;
    }

    protected SystemCompileCommand getInputCompileCommand() {
        return this.inputCompileCommand;
    }

    protected SystemCompileManager getCompileManager() {
        return this.compileManager;
    }

    protected IHost getSystemConnection() {
        return this.compileManager.getSystemConnection();
    }

    public void setCompileLabelValidator(ISystemValidator validator) {
        this.cmdLabelValidator = validator;
    }

    protected void setIgnoreChanges(boolean ignoreChanges) {
        this.ignoreChanges = ignoreChanges;
        this.commandField.setIgnoreChanges(ignoreChanges);
    }

    public void addChangeListener(ISystemCompileCommandEditPaneListener l) {
        this.listeners.add(l);
    }

    public void removeChangeListener(ISystemCompileCommandEditPaneListener l) {
        this.listeners.remove(l);
    }

    public void setCommandValidator(ISystemValidator validator) {
        this.commandField.setCommandValidator(validator);
    }

    public void setCommandMassager(ISystemMassager massager) {
        this.commandField.setCommandMassager(massager);
    }

    public void setSubstitutionVariableList(SystemCmdSubstVarList varList) {
        this.commandField.setSubstitutionVariableList(varList);
    }

    protected SystemCommandViewerConfiguration getCommandTextViewerConfiguration() {
        return new SystemCommandViewerConfiguration();
    }

    protected void setCommandTextViewerConfiguration(SystemCommandViewerConfiguration cmdAssistant) {
        this.commandField.setCommandTextViewerConfiguration(cmdAssistant);
    }

    public void setCompileCommand(SystemCompileType parentCompileType, SystemCompileCommand compileCommand) {
        this.inputCompileCommand = compileCommand;
        this.parentCompileType = parentCompileType;
        if (parentCompileType != null && this.cmdLabelValidator instanceof ISystemValidatorUniqueString) {
            Vector existingLabels = parentCompileType.getExistingLabels();
            if (compileCommand != null) {
                existingLabels.removeElement(compileCommand.getLabel());
            }
            ((ISystemValidatorUniqueString)this.cmdLabelValidator).setExistingNamesList((Collection)existingLabels);
        }
        this.newMode = compileCommand == null;
        this.setIgnoreChanges(true);
        this.resetFields();
        if (compileCommand != null) {
            this.doInitializeFields();
        }
        this.enableExtraButtons();
        if (this.newMode) {
            this.resetExtraButtonsForNewMode();
        } else {
            this.resetExtraButtons(compileCommand);
        }
        this.setIgnoreChanges(false);
    }

    public SystemCompileCommand saveChanges() {
        String cmdLabel = this.textLabel.getText().trim();
        if (cmdLabel.length() == 0) {
            return null;
        }
        String cmdString = this.commandField.getMassagedCommandText();
        if (cmdString.length() == 0) {
            return null;
        }
        cmdString = this.preSaveMassage(cmdString);
        SystemCompileCommand currentCmd = this.inputCompileCommand;
        if (currentCmd == null) {
            currentCmd = new SystemCompileCommand(this.parentCompileType);
            currentCmd.setDefaultString(cmdString);
            currentCmd.setIsUserSupplied();
        } else if (this.commandField.getCommandMassager() != null) {
            this.setIgnoreChanges(true);
            this.setCommandText(cmdString);
            this.setIgnoreChanges(false);
        }
        currentCmd.setLabel(cmdLabel);
        currentCmd.setCurrentString(cmdString);
        this.processExtraButtonsChanges(currentCmd);
        return currentCmd;
    }

    protected String preSaveMassage(String commandString) {
        return commandString;
    }

    public void configureHeadingLabel(Label label) {
        if (!this.newMode) {
            label.setText(SystemUDAResources.RESID_WWCOMPCMDS_EDITCMD_LABEL);
            label.setToolTipText(SystemUDAResources.RESID_WWCOMPCMDS_EDITCMD_TOOLTIP);
        } else {
            label.setText(SystemUDAResources.RESID_WWCOMPCMDS_NEWCMD_LABEL);
            label.setToolTipText(SystemUDAResources.RESID_WWCOMPCMDS_NEWCMD_TOOLTIP);
        }
    }

    public Control createContents(Composite parent) {
        if (this.cmdLabelValidator == null) {
            this.cmdLabelValidator = new ValidatorCompileCommandLabel();
        }
        if (this.cmdLabelValidator instanceof ISystemValidatorUniqueString) {
            ((ISystemValidatorUniqueString)this.cmdLabelValidator).setCaseSensitive(this.caseSensitive);
        }
        int nbrColumns = 3;
        Composite composite_prompts = SystemWidgetHelpers.createComposite((Composite)parent, (int)nbrColumns);
        ((GridLayout)composite_prompts.getLayout()).marginWidth = 0;
        this.textLabel = SystemWidgetHelpers.createLabeledTextField((Composite)composite_prompts, null, (String)this.getCompileCommandLabel(), (String)this.getCompileCommandTooltip());
        this.labelLabel = SystemWidgetHelpers.getLastLabel();
        this.textLabel.setTextLimit(this.cmdLabelValidator.getMaximumNameLength());
        ((GridData)this.textLabel.getLayoutData()).horizontalSpan = nbrColumns - 1;
        this.commandField.createContents(composite_prompts, nbrColumns, this);
        this.resetFields();
        this.doInitializeFields();
        this.textLabel.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SystemCompileCommandEditPane.this.validateLabelInput();
            }
        });
        this.commandField.addModifyListener(this);
        return composite_prompts;
    }

    public Control getInitialFocusControl() {
        if (this.textLabel.isEnabled()) {
            return this.textLabel;
        }
        return this.commandField.getCommandWidget();
    }

    public boolean createCommandLabelLineControls(Composite parent, int availableColumns) {
        return false;
    }

    public boolean createExtraButtons(Composite parent, int availableColumns) {
        return false;
    }

    protected void enableExtraButtons() {
    }

    protected void resetExtraButtonsForNewMode() {
    }

    protected void resetExtraButtons(SystemCompileCommand originalCmd) {
    }

    protected void processExtraButtonsChanges(SystemCompileCommand currentCmd) {
    }

    protected String getCompileCommandLabel() {
        return SystemUDAResources.RESID_WWCOMPCMDS_CMDLABEL_LABEL;
    }

    protected String getCompileCommandTooltip() {
        return SystemUDAResources.RESID_WWCOMPCMDS_CMDLABEL_TOOLTIP;
    }

    protected String getCompileCommandPromptLabel() {
        return SystemUDAResources.RESID_WWCOMPCMDS_CMD_LABEL;
    }

    protected String getCompileCommandPromptTooltip() {
        return SystemUDAResources.RESID_WWCOMPCMDS_CMD_TOOLTIP;
    }

    protected void doInitializeFields() {
        if (this.commandField == null) {
            return;
        }
        if (this.inputCompileCommand != null) {
            this.textLabel.setText(this.inputCompileCommand.getLabel());
            this.textLabel.setEnabled(this.inputCompileCommand.isLabelEditable());
            this.commandField.setCommandText(this.inputCompileCommand.getCurrentString());
            this.commandField.enableCommandWidget(this.inputCompileCommand.isCommandStringEditable());
        }
    }

    protected void resetFields() {
        this.textLabel.setEnabled(true);
        this.textLabel.setText("");
        this.commandField.setCommandText("");
        this.errorMessage = null;
    }

    public boolean isComplete() {
        boolean complete = true;
        complete = this.errorMessage != null ? false : this.areFieldsComplete();
        return complete;
    }

    protected boolean areFieldsComplete() {
        if (this.commandField == null) {
            return false;
        }
        return this.textLabel.getText().trim().length() > 0 && this.commandField.getCommandText().length() > 0;
    }

    public boolean areErrorsPending() {
        return this.errorMessage != null;
    }

    public void clearErrorMessage() {
        this.errorMessage = null;
    }

    public void commandModified(String cmdText, SystemMessage errorMessage) {
        this.errorMessage = errorMessage;
        this.processCommandTextChange(cmdText, errorMessage != null);
        if (!this.fromVerify) {
            this.fireChangeEvent(errorMessage);
        }
    }

    protected void processCommandTextChange(String newText, boolean hasError) {
    }

    protected void setCommandText(String text) {
        this.commandField.setCommandText(text);
    }

    protected String getCommandText() {
        return this.commandField.getCommandText();
    }

    protected void fireChangeEvent(SystemMessage error) {
        if (this.skipEventFiring) {
            return;
        }
        int idx = 0;
        while (idx < this.listeners.size()) {
            ISystemCompileCommandEditPaneListener l = (ISystemCompileCommandEditPaneListener)this.listeners.elementAt(idx);
            l.compileCommandChanged(error);
            ++idx;
        }
    }

    protected SystemMessage validateLabelInput() {
        if (this.ignoreChanges) {
            return this.errorMessage;
        }
        this.errorMessage = this.cmdLabelValidator.validate(this.textLabel.getText().trim());
        if (!this.fromVerify) {
            this.fireChangeEvent(this.errorMessage);
        }
        return this.errorMessage;
    }

    protected SystemMessage validateStringInput() {
        if (this.ignoreChanges) {
            return this.errorMessage;
        }
        this.errorMessage = this.commandField.validateCommand();
        if (!this.fromVerify) {
            this.fireChangeEvent(this.errorMessage);
        }
        return this.errorMessage;
    }

    public SystemMessage validate(boolean skipLabel, boolean skipString) {
        this.errorMessage = null;
        this.controlInError = null;
        if (!skipLabel) {
            this.errorMessage = this.validateLabelInput();
            if (this.errorMessage != null) {
                this.controlInError = this.textLabel;
            }
        }
        if (this.errorMessage == null && !skipString) {
            this.errorMessage = this.validateStringInput();
            if (this.errorMessage != null) {
                this.controlInError = this.commandField.getCommandWidget();
            }
        }
        return this.errorMessage;
    }

    public SystemMessage verify() {
        this.fromVerify = true;
        this.errorMessage = this.validate(false, false);
        if (this.errorMessage != null && this.controlInError != null) {
            this.controlInError.setFocus();
        }
        this.fromVerify = false;
        this.fireChangeEvent(this.errorMessage);
        return this.errorMessage;
    }

    public void widgetSelected(SelectionEvent event) {
    }

    public void widgetDefaultSelected(SelectionEvent event) {
    }

    protected void addSeparatorLine(Composite parent, int nbrColumns) {
        Label separator = new Label(parent, 258);
        GridData data = new GridData();
        data.horizontalSpan = nbrColumns;
        data.horizontalAlignment = 4;
        separator.setLayoutData((Object)data);
    }

    protected void addFillerLine(Composite parent, int nbrColumns) {
        Label filler = new Label(parent, 16384);
        GridData data = new GridData();
        data.horizontalSpan = nbrColumns;
        data.horizontalAlignment = 4;
        filler.setLayoutData((Object)data);
    }

    protected void addGrowableFillerLine(Composite parent, int nbrColumns) {
        Label filler = new Label(parent, 16384);
        GridData data = new GridData();
        data.horizontalSpan = nbrColumns;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        data.grabExcessVerticalSpace = true;
        filler.setLayoutData((Object)data);
    }
}

