/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.highlight;

import org.apache.lucene.analysis.Token;

public class TokenGroup {
    private static final int MAX_NUM_TOKENS_PER_GROUP = 50;
    Token[] tokens = new Token[50];
    float[] scores = new float[50];
    int numTokens = 0;
    int startOffset = 0;
    int endOffset = 0;
    float tot;
    int matchStartOffset;
    int matchEndOffset;

    void addToken(Token token, float score) {
        if (this.numTokens < 50) {
            if (this.numTokens == 0) {
                this.startOffset = this.matchStartOffset = token.startOffset();
                this.endOffset = this.matchEndOffset = token.endOffset();
                this.tot += score;
            } else {
                this.startOffset = Math.min(this.startOffset, token.startOffset());
                this.endOffset = Math.max(this.endOffset, token.endOffset());
                if (score > 0.0f) {
                    if (this.tot == 0.0f) {
                        this.matchStartOffset = token.startOffset();
                        this.matchEndOffset = token.endOffset();
                    } else {
                        this.matchStartOffset = Math.min(this.matchStartOffset, token.startOffset());
                        this.matchEndOffset = Math.max(this.matchEndOffset, token.endOffset());
                    }
                    this.tot += score;
                }
            }
            this.tokens[this.numTokens] = (Token)token.clone();
            this.scores[this.numTokens] = score;
            ++this.numTokens;
        }
    }

    boolean isDistinct(Token token) {
        return token.startOffset() >= this.endOffset;
    }

    void clear() {
        this.numTokens = 0;
        this.tot = 0.0f;
    }

    public Token getToken(int index) {
        return this.tokens[index];
    }

    public float getScore(int index) {
        return this.scores[index];
    }

    public int getEndOffset() {
        return this.endOffset;
    }

    public int getNumTokens() {
        return this.numTokens;
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    public float getTotalScore() {
        return this.tot;
    }
}

