/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.injection;

import org.eclipse.core.runtime.ContributorFactoryOSGi;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IExecutableExtensionFactory;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.recommenders.injection.InjectionService;

public class ExtensionFactory
implements IExecutableExtension,
IExecutableExtensionFactory {
    private IConfigurationElement config;
    private String propertyName;
    private Object data;

    public ExtensionFactory() {
        InjectionService.getInstance().getInjector();
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.config = config;
        this.propertyName = propertyName;
        this.data = data;
    }

    public Object create() throws CoreException {
        Object extension = this.loadExtension();
        this.initializeExtension(extension);
        return extension;
    }

    private Object loadExtension() throws CoreException {
        if (this.data instanceof String) {
            Class<?> clazz = this.resolveClass((String)this.data);
            return InjectionService.getInstance().getInjector().getInstance(clazz);
        }
        throw new CoreException((IStatus)new Status(4, this.config.getContributor().getName(), "Class configuration missing"));
    }

    private Class<?> resolveClass(String className) throws CoreException {
        try {
            return ContributorFactoryOSGi.resolve((IContributor)this.config.getContributor()).loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new CoreException((IStatus)new Status(4, this.config.getContributor().getName(), "Class could not be found", (Throwable)e));
        }
    }

    private void initializeExtension(Object extension) throws CoreException {
        if (extension instanceof IExecutableExtension) {
            ((IExecutableExtension)extension).setInitializationData(this.config, this.propertyName, this.data);
        }
    }
}

