/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.tomcat.core.internal;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jst.server.tomcat.core.internal.CatalinaPropertiesUtil;
import org.eclipse.jst.server.tomcat.core.internal.Messages;
import org.eclipse.jst.server.tomcat.core.internal.Trace;
import org.eclipse.jst.server.tomcat.core.internal.wst.IModuleVisitor;
import org.eclipse.jst.server.tomcat.core.internal.xml.Factory;
import org.eclipse.jst.server.tomcat.core.internal.xml.server40.Context;
import org.eclipse.jst.server.tomcat.core.internal.xml.server40.Loader;
import org.eclipse.jst.server.tomcat.core.internal.xml.server40.ServerInstance;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.componentcore.resources.IVirtualResource;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.ServerUtil;

public class TomcatPublishModuleVisitor
implements IModuleVisitor {
    protected final IPath baseDir;
    protected final String tomcatVersion;
    protected final ServerInstance serverInstance;
    protected final String sharedLoader;
    protected final boolean enableMetaInfResources;
    protected final List<String> earCommonResources = new ArrayList<String>();
    protected Set<String> virtualClassClasspathElements = new LinkedHashSet<String>();
    protected Set<String> virtualJarClasspathElements = new LinkedHashSet<String>();
    protected Map<String, List<String>> virtualDependentResources = new LinkedHashMap<String, List<String>>();

    TomcatPublishModuleVisitor(IPath baseDir, String tomcatVersion, ServerInstance serverInstance, String sharedLoader, boolean enableMetaInfResources) {
        this.baseDir = baseDir;
        this.tomcatVersion = tomcatVersion;
        this.serverInstance = serverInstance;
        this.sharedLoader = sharedLoader;
        this.enableMetaInfResources = enableMetaInfResources;
    }

    public void visitWebComponent(IVirtualComponent component) throws CoreException {
    }

    public void visitArchiveComponent(IPath runtimePath, IPath workspacePath) {
        this.addVirtualJarResource(runtimePath, workspacePath);
    }

    public void visitDependentJavaProject(IJavaProject javaProject) {
    }

    public void visitDependentComponent(IPath runtimePath, IPath workspacePath) {
        this.addVirtualJarResource(runtimePath, workspacePath);
    }

    public void visitWebResource(IPath runtimePath, IPath workspacePath) {
        this.addVirtualClassResource(runtimePath, workspacePath);
    }

    public void visitDependentContentResource(IPath runtimePath, IPath workspacePath) {
        if (this.enableMetaInfResources) {
            this.addContentResource(runtimePath, workspacePath);
        }
    }

    public void visitEarResource(IPath runtimePath, IPath workspacePath) {
        this.earCommonResources.add(workspacePath.toOSString());
    }

    public void endVisitEarComponent(IVirtualComponent component) throws CoreException {
        if (this.earCommonResources.size() > 0) {
            try {
                try {
                    CatalinaPropertiesUtil.addGlobalClasspath(this.baseDir.append("conf/catalina.properties").toFile(), this.sharedLoader, this.earCommonResources.toArray(new String[this.earCommonResources.size()]));
                }
                catch (IOException e) {
                    Trace.trace((byte)1, "Unable to add ear path entries to catalina.properties", e);
                    this.earCommonResources.clear();
                }
            }
            finally {
                this.earCommonResources.clear();
            }
        }
    }

    public void endVisitWebComponent(IVirtualComponent component) throws CoreException {
        String oldResPaths;
        String resPaths;
        String string;
        String vcp;
        boolean dirty = false;
        IModule module = ServerUtil.getModule((IProject)component.getProject());
        Context context = this.findContext(module);
        if (context == null) {
            String name = module != null ? module.getName() : component.getName();
            Trace.trace((byte)2, "Could not find context for module " + name);
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jst.server.tomcat.core", 0, NLS.bind((String)Messages.errorPublishContextNotFound, (Object)name), null));
        }
        dirty = this.includeProjectContextXml(component, context);
        dirty = this.updateDocBaseAndPath(component, context);
        context.getResources().setClassName("org.eclipse.jst.server.tomcat.loader.WtpDirContext");
        Loader loader = context.getLoader();
        loader.setClassName("org.eclipse.jst.server.tomcat.loader.WtpWebappLoader");
        loader.setUseSystemClassLoaderAsParent(Boolean.FALSE.toString());
        StringBuffer vcBuffer = new StringBuffer();
        StringBuffer vcJarBuffer = new StringBuffer();
        StringBuffer rpBuffer = new StringBuffer();
        boolean isTomcat7 = this.tomcatVersion.startsWith("7.");
        for (String element : this.virtualClassClasspathElements) {
            if (vcBuffer.length() > 0) {
                vcBuffer.append(";");
            }
            vcBuffer.append((Object)element);
            if (!isTomcat7) continue;
            if (rpBuffer.length() > 0) {
                rpBuffer.append(";");
            }
            rpBuffer.append("/WEB-INF/classes").append("|").append((Object)element);
        }
        Iterator<String> iterator = this.virtualJarClasspathElements.iterator();
        while (iterator.hasNext()) {
            vcJarBuffer.append((Object)iterator.next());
            if (!iterator.hasNext()) continue;
            vcJarBuffer.append(";");
        }
        this.virtualClassClasspathElements.clear();
        this.virtualJarClasspathElements.clear();
        HashSet<String> rtPathsProcessed = new HashSet<String>();
        HashSet<String> locationsIncluded = new HashSet<String>();
        String docBase = context.getDocBase();
        locationsIncluded.add(docBase);
        HashMap<String, String> retryLocations = new HashMap<String, String>();
        IVirtualResource[] virtualResources = component.getRootFolder().getResources("");
        int i = 0;
        while (i < virtualResources.length) {
            String string2 = virtualResources[i].getRuntimePath().toString();
            if (!rtPathsProcessed.contains(string2)) {
                if (!"/WEB-INF/classes".equals(string2)) {
                    IResource[] underlyingResources = virtualResources[i].getUnderlyingResources();
                    if ("/".equals(string2)) {
                        int j = 0;
                        while (j < underlyingResources.length) {
                            IPath resLoc = underlyingResources[j].getLocation();
                            String location = resLoc.toOSString();
                            if (!location.equals(docBase)) {
                                File webInfLib;
                                if (rpBuffer.length() != 0) {
                                    rpBuffer.append(";");
                                }
                                rpBuffer.append(location);
                                locationsIncluded.add(location);
                                File webInfClasses = resLoc.append("WEB-INF/classes").toFile();
                                if (webInfClasses.exists() && webInfClasses.isDirectory()) {
                                    if (vcBuffer.length() != 0) {
                                        vcBuffer.append(";");
                                    }
                                    vcBuffer.append(webInfClasses.getPath());
                                }
                                if ((webInfLib = resLoc.append("WEB-INF/lib").toFile()).exists() && webInfLib.isDirectory()) {
                                    String[] jars = webInfLib.list(new FilenameFilter(){

                                        public boolean accept(File dir, String name) {
                                            File f = new File(dir, name);
                                            return f.isFile() && name.endsWith(".jar");
                                        }
                                    });
                                    int k = 0;
                                    while (k < jars.length) {
                                        if (vcJarBuffer.length() != 0) {
                                            vcJarBuffer.append(";");
                                        }
                                        vcJarBuffer.append(String.valueOf(webInfLib.getPath()) + File.separator + jars[k]);
                                        ++k;
                                    }
                                }
                            }
                            ++j;
                        }
                    } else {
                        int idx = string2.lastIndexOf(47);
                        if (idx >= 0) {
                            String lastSegment = string2.substring(idx + 1);
                            int j = 0;
                            while (j < underlyingResources.length) {
                                IPath resLoc = underlyingResources[j].getLocation();
                                String location = resLoc.toOSString();
                                if (!lastSegment.equals(resLoc.lastSegment())) {
                                    if (rpBuffer.length() != 0) {
                                        rpBuffer.append(";");
                                    }
                                    rpBuffer.append(string2).append("|").append(location);
                                    locationsIncluded.add(location);
                                    File webInfLib = null;
                                    File webInfClasses = null;
                                    if ("/WEB-INF".equals(string2)) {
                                        webInfLib = resLoc.append("lib").toFile();
                                        webInfClasses = resLoc.append("classes").toFile();
                                    } else if ("/WEB-INF/lib".equals(string2)) {
                                        webInfLib = resLoc.toFile();
                                    } else if ("/WEB-INF/classes".equals(string2)) {
                                        webInfClasses = resLoc.toFile();
                                    }
                                    if (webInfClasses != null && webInfClasses.exists() && webInfClasses.isDirectory()) {
                                        if (vcBuffer.length() != 0) {
                                            vcBuffer.append(";");
                                        }
                                        vcBuffer.append(webInfClasses.getPath());
                                    }
                                    if (webInfLib != null && webInfLib.exists() && webInfLib.isDirectory()) {
                                        String[] jars = webInfLib.list(new FilenameFilter(){

                                            public boolean accept(File dir, String name) {
                                                File f = new File(dir, name);
                                                return f.isFile() && name.endsWith(".jar");
                                            }
                                        });
                                        int k = 0;
                                        while (k < jars.length) {
                                            if (vcJarBuffer.length() != 0) {
                                                vcJarBuffer.append(";");
                                            }
                                            vcJarBuffer.append(String.valueOf(webInfLib.getPath()) + File.separator + jars[k]);
                                            ++k;
                                        }
                                    }
                                } else {
                                    retryLocations.put(location, string2);
                                }
                                ++j;
                            }
                        }
                    }
                }
                rtPathsProcessed.add(string2);
            }
            ++i;
        }
        if (!retryLocations.isEmpty()) {
            Iterator iterator2 = retryLocations.keySet().iterator();
            block7: while (iterator2.hasNext()) {
                String string3 = (String)iterator2.next();
                for (String includedLocation : locationsIncluded) {
                    if (!string3.equals(includedLocation) && !string3.startsWith(String.valueOf(includedLocation) + File.separator)) continue;
                    iterator2.remove();
                    continue block7;
                }
            }
            if (!retryLocations.isEmpty()) {
                for (Map.Entry entry : retryLocations.entrySet()) {
                    String location = (String)entry.getKey();
                    String rtPath = (String)entry.getValue();
                    if (rpBuffer.length() != 0) {
                        rpBuffer.append(";");
                    }
                    rpBuffer.append(rtPath).append("|").append(location);
                    File webInfLib = null;
                    File webInfClasses = null;
                    if ("/WEB-INF".equals(rtPath)) {
                        webInfLib = new File(location, "lib");
                        webInfClasses = new File(location, "classes");
                    } else if ("/WEB-INF/lib".equals(rtPath)) {
                        webInfLib = new File(location);
                    } else if ("/WEB-INF/classes".equals(rtPath)) {
                        webInfClasses = new File(location);
                    }
                    if (webInfClasses != null && webInfClasses.exists() && webInfClasses.isDirectory()) {
                        if (vcBuffer.length() != 0) {
                            vcBuffer.append(";");
                        }
                        vcBuffer.append(webInfClasses.getPath());
                    }
                    if (webInfLib == null || !webInfLib.exists() || !webInfLib.isDirectory()) continue;
                    String[] jars = webInfLib.list(new FilenameFilter(){

                        public boolean accept(File dir, String name) {
                            File f = new File(dir, name);
                            return f.isFile() && name.endsWith(".jar");
                        }
                    });
                    int k = 0;
                    while (k < jars.length) {
                        if (vcJarBuffer.length() != 0) {
                            vcJarBuffer.append(";");
                        }
                        vcJarBuffer.append(String.valueOf(webInfLib.getPath()) + File.separator + jars[k]);
                        ++k;
                    }
                }
            }
        }
        if (!this.virtualDependentResources.isEmpty()) {
            for (Map.Entry<String, List<String>> entry : this.virtualDependentResources.entrySet()) {
                String rtPath = entry.getKey();
                List<String> locations = entry.getValue();
                for (String location : locations) {
                    if (rpBuffer.length() != 0) {
                        rpBuffer.append(";");
                    }
                    if (rtPath.length() > 0) {
                        rpBuffer.append((Object)entry.getKey()).append("|").append(location);
                        continue;
                    }
                    rpBuffer.append(location);
                }
            }
        }
        this.virtualDependentResources.clear();
        if (vcJarBuffer.length() > 0) {
            if (vcBuffer.length() > 0) {
                vcBuffer.append(';');
            }
            vcBuffer.append(vcJarBuffer);
        }
        if (!(vcp = vcBuffer.toString()).equals(string = loader.getVirtualClasspath())) {
            dirty = true;
            loader.setVirtualClasspath(vcp);
            context.getResources().setVirtualClasspath(vcp);
        }
        if (!(resPaths = rpBuffer.toString()).equals(oldResPaths = context.getResources().getExtraResourcePaths())) {
            dirty = true;
            context.getResources().setExtraResourcePaths(resPaths);
        }
        if (this.enableMetaInfResources) {
            context.findElement("JarScanner").setAttributeValue("scanAllDirectories", "true");
        }
    }

    private void addVirtualClassResource(IPath runtimePath, IPath workspacePath) {
        this.virtualClassClasspathElements.add(workspacePath.toOSString());
    }

    private void addVirtualJarResource(IPath runtimePath, IPath workspacePath) {
        this.virtualJarClasspathElements.add(workspacePath.toOSString());
    }

    private void addContentResource(IPath runtimePath, IPath workspacePath) {
        String rtPath = runtimePath.toString();
        List<String> locations = this.virtualDependentResources.get(rtPath);
        if (locations == null) {
            locations = new ArrayList<String>();
            this.virtualDependentResources.put(rtPath, locations);
        }
        locations.add(workspacePath.toOSString());
    }

    protected Context getProjectContextXml(IVirtualComponent component) throws CoreException {
        Context contextElement;
        block12: {
            IVirtualFile contextFile = (IVirtualFile)component.getRootFolder().findMember("META-INF/context.xml");
            contextElement = null;
            if (contextFile != null && contextFile.exists()) {
                Factory factory = new Factory();
                factory.setPackageName("org.eclipse.jst.server.tomcat.core.internal.xml.server40");
                InputStream fis = null;
                try {
                    try {
                        fis = contextFile.getUnderlyingFile().getContents();
                        contextElement = (Context)factory.loadDocument(fis);
                    }
                    catch (Exception e) {
                        Trace.trace((byte)2, "Exception reading " + contextFile, e);
                        try {
                            fis.close();
                        }
                        catch (IOException iOException) {}
                        break block12;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        fis.close();
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
        return contextElement;
    }

    protected Context findContext(IModule module) {
        if (module == null) {
            return null;
        }
        String source = module.getId();
        Context[] contexts = this.serverInstance.getContexts();
        int i = 0;
        while (i < contexts.length) {
            if (source.equals(contexts[i].getSource())) {
                return contexts[i];
            }
            ++i;
        }
        return null;
    }

    String getContextName(Context context) {
        String contextName = context.getPath();
        if (contextName.startsWith("/")) {
            contextName = contextName.substring(1);
        }
        if ("".equals(contextName)) {
            contextName = "ROOT";
        }
        return contextName;
    }

    boolean includeProjectContextXml(IVirtualComponent component, Context context) throws CoreException {
        boolean dirty = false;
        Context projectContext = this.getProjectContextXml(component);
        if (projectContext != null) {
            projectContext.copyChildrenTo(context);
            Map attrs = projectContext.getAttributes();
            for (String name : attrs.keySet()) {
                String actualValue;
                String value;
                if (name.equalsIgnoreCase("path") || name.equalsIgnoreCase("docBase") || name.equalsIgnoreCase("source") || (value = (String)attrs.get(name)).equals(actualValue = context.getAttributeValue(name))) continue;
                context.setAttributeValue(name, value);
                dirty = true;
            }
        }
        return dirty;
    }

    boolean updateDocBaseAndPath(IVirtualComponent component, Context context) {
        String contextName;
        String path;
        boolean dirty = false;
        String docBase = component.getRootFolder().getUnderlyingFolder().getLocation().toOSString();
        if (!docBase.equals(context.getDocBase())) {
            dirty = true;
            context.setDocBase(docBase);
        }
        String string = path = (contextName = this.getContextName(context)).equals("ROOT") ? "" : "/" + contextName;
        if (!path.equals(context.getPath())) {
            dirty = true;
            context.setPath(path);
        }
        return dirty;
    }
}

