/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.ui.internal.autoedit;

import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.wst.css.core.internal.CSSCorePlugin;
import org.eclipse.wst.css.core.internal.util.RegionIterator;
import org.eclipse.wst.css.ui.internal.Logger;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.ui.internal.text.StructuredAutoEditStrategy;

public class StructuredAutoEditStrategyCSS
extends StructuredAutoEditStrategy {
    protected IStructuredDocument structuredDocument = null;

    protected void autoIndentAfterClose(DocumentCommand command, String regionType) {
        if (!this.setRangeForClose(command)) {
            return;
        }
        int position = command.offset + command.length;
        if (position == -1 || this.structuredDocument.getLength() == 0) {
            return;
        }
        CompoundRegion region = this.prevCorrespondence(position, regionType);
        String str = this.getIndentFor(region, false);
        if (str != null) {
            command.text = String.valueOf(str) + command.text;
        }
    }

    protected void autoIndentAfterNewLine(DocumentCommand command) {
        int position = command.offset;
        if (position == -1 || this.structuredDocument.getLength() == 0) {
            return;
        }
        IStructuredDocumentRegion prev = this.getPreviousRegion(position);
        if (prev == null || !"LBRACE".equals(prev.getType())) {
            return;
        }
        this.setRangeForNewLine(command);
        position = command.offset;
        IStructuredDocumentRegion next = prev.getNext();
        StringBuffer buf = new StringBuffer(command.text);
        try {
            IRegion line = this.structuredDocument.getLineInformationOfOffset(position);
            int contentStart = StructuredAutoEditStrategyCSS.findEndOfWhiteSpace((IDocument)this.structuredDocument, position, line.getOffset() + line.getLength());
            command.length = Math.max(contentStart - position, 0);
            buf.append(this.getIndentString());
            if (next != null && "RBRACE".equals(next.getType()) && !this.isOneLine(prev)) {
                command.shiftsCaret = false;
                command.caretOffset = contentStart + buf.length();
                buf.append(TextUtilities.getDefaultLineDelimiter((IDocument)this.structuredDocument));
            }
            command.text = buf.toString();
        }
        catch (BadLocationException badLocationException) {}
    }

    private boolean isOneLine(IStructuredDocumentRegion prev) {
        return StructuredAutoEditStrategyCSS.endsWith(this.structuredDocument.getLegalLineDelimiters(), prev.getFullText()) != -1;
    }

    private IStructuredDocumentRegion getPreviousRegion(int offset) {
        IStructuredDocumentRegion prev = null;
        if (offset > 0) {
            prev = this.structuredDocument.getRegionAtCharacterOffset(offset - 1);
        }
        return prev;
    }

    public void customizeDocumentCommand(IDocument document, DocumentCommand command) {
        if (!this.supportsSmartInsert(document)) {
            return;
        }
        this.structuredDocument = (IStructuredDocument)document;
        if (command.length == 0 && command.text != null) {
            if (StructuredAutoEditStrategyCSS.endsWith(document.getLegalLineDelimiters(), command.text) != -1) {
                this.autoIndentAfterNewLine(command);
            } else if (command.text.equals("}")) {
                this.autoIndentAfterClose(command, "RBRACE");
            } else if (command.text.equals("]")) {
                this.autoIndentAfterClose(command, "SELECTOR_ATTRIBUTE_END");
            } else if (command.text.equals(")")) {
                this.autoIndentAfterClose(command, "DECLARATION_VALUE_PARENTHESIS_CLOSE");
            }
        }
        if (command.text != null && command.text.length() > 0 && command.text.charAt(0) == '\t') {
            this.smartInsertForTab(command, document);
        }
    }

    protected String getIndentFor(CompoundRegion region, boolean indentForNextRegion) {
        if (region == null) {
            return null;
        }
        IStructuredDocumentRegion flatNode = region.getDocumentRegion();
        if (flatNode == null) {
            return null;
        }
        try {
            if (region.getType() == "LBRACE" || region.getType() == "DELIMITER" || region.getType() == "DECLARATION_DELIMITER") {
                RegionIterator it = new RegionIterator(flatNode, region.getTextRegion());
                it.prev();
                while (it.hasPrev()) {
                    ITextRegion r = it.prev();
                    region = new CompoundRegion(it.getStructuredDocumentRegion(), r);
                    if (region.getType() != "S") break;
                }
                flatNode = region.getDocumentRegion();
                int position = flatNode.getStart();
                int line = this.structuredDocument.getLineOfOffset(position);
                int start = this.structuredDocument.getLineOffset(line);
                int end = StructuredAutoEditStrategyCSS.findEndOfWhiteSpace((IDocument)this.structuredDocument, start, position);
                return this.structuredDocument.get(start, end - start);
            }
            if (region.getType() == "SELECTOR_ATTRIBUTE_START" || region.getType() == "DECLARATION_VALUE_FUNCTION" || region.getType() == "DECLARATION_SEPARATOR") {
                int tokenStart;
                int position = flatNode.getStart() + region.getStart();
                int line = this.structuredDocument.getLineOfOffset(position);
                int start = this.structuredDocument.getLineOffset(line);
                int end = StructuredAutoEditStrategyCSS.findEndOfWhiteSpace((IDocument)this.structuredDocument, start, position);
                StringBuffer buf = new StringBuffer(this.structuredDocument.get(start, end - start));
                if (indentForNextRegion && (tokenStart = StructuredAutoEditStrategyCSS.findEndOfWhiteSpace((IDocument)this.structuredDocument, position += region.getText().length(), this.structuredDocument.getLineOffset(line) + this.structuredDocument.getLineLength(line) - 1)) < this.structuredDocument.getLineOffset(line) + this.structuredDocument.getLineLength(line) - 1) {
                    position = tokenStart;
                }
                while (position - end > 0) {
                    buf.append(" ");
                    ++end;
                }
                return buf.toString();
            }
            return "";
        }
        catch (BadLocationException excp) {
            Logger.logException(excp);
            return null;
        }
    }

    protected CompoundRegion getPrevKeyRegion(int position, CompoundRegion currentRegion) {
        if (currentRegion == null && this.structuredDocument.getLastStructuredDocumentRegion() == null) {
            return null;
        }
        if (currentRegion != null && (currentRegion.getType() == "RBRACE" || currentRegion.getType() == "SELECTOR_ATTRIBUTE_END" || currentRegion.getType() == "DECLARATION_VALUE_PARENTHESIS_CLOSE")) {
            return this.prevCorrespondence(currentRegion);
        }
        RegionIterator it = new RegionIterator(this.structuredDocument, position - 1);
        block0: while (it.hasPrev()) {
            RegionIterator itTmp;
            ITextRegion r = it.prev();
            CompoundRegion region = new CompoundRegion(it.getStructuredDocumentRegion(), r);
            if (region.getType() == "LBRACE" || region.getType() == "SELECTOR_ATTRIBUTE_START" || region.getType() == "DELIMITER" || region.getType() == "DECLARATION_DELIMITER" || region.getType() == "DECLARATION_VALUE_FUNCTION") {
                return region;
            }
            if (region.getType() == "RBRACE" || region.getType() == "SELECTOR_ATTRIBUTE_END" || region.getType() == "DECLARATION_VALUE_PARENTHESIS_CLOSE") {
                CompoundRegion pc = this.prevCorrespondence(region);
                if (pc == null) break;
                it.reset(pc.getDocumentRegion(), pc.getTextRegion());
                it.prev();
                continue;
            }
            if (region.getType() == "STRING") {
                itTmp = new RegionIterator(this.structuredDocument, position);
                if (region != itTmp.prev()) continue;
                return region;
            }
            if (region.getType() == "COMMENT") {
                itTmp = new RegionIterator(this.structuredDocument, position);
                if (region != itTmp.prev()) continue;
                return region;
            }
            if (region.getType() == "UNKNOWN") {
                String str = region.getText();
                if (str.charAt(str.length() - 1) != '\\') continue;
                return region;
            }
            if (region.getType() != "DECLARATION_SEPARATOR") continue;
            RegionIterator itPrev = new RegionIterator(region.getDocumentRegion(), region.getTextRegion());
            while (itPrev.hasPrev()) {
                ITextRegion regionPrev = itPrev.prev();
                if (regionPrev.getType() == "RBRACE") continue block0;
                if (regionPrev.getType() == "DELIMITER" || regionPrev.getType() == "DECLARATION_DELIMITER") {
                    return region;
                }
                if (regionPrev.getType() != "LBRACE") continue;
                while (itPrev.hasPrev()) {
                    regionPrev = itPrev.prev();
                    if (regionPrev.getType() == "MEDIA") break;
                    if (regionPrev.getType() != "LBRACE" && regionPrev.getType() != "RBRACE" && regionPrev.getType() != "DELIMITER" && regionPrev.getType() != "DECLARATION_DELIMITER") continue;
                    return region;
                }
                if (regionPrev.getType() == "MEDIA") continue block0;
                return region;
            }
        }
        return null;
    }

    protected CompoundRegion getRegion(int position) {
        IStructuredDocumentRegion flatNode = this.structuredDocument.getRegionAtCharacterOffset(position);
        if (flatNode != null) {
            return new CompoundRegion(flatNode, flatNode.getRegionAtCharacterOffset(position));
        }
        return null;
    }

    protected int needShift(CompoundRegion region, int position) {
        int shift = 0;
        if (region == null || region.getType() == "DELIMITER" || region.getType() == "DECLARATION_DELIMITER" || region.getType() == "LBRACE") {
            CompoundRegion cr = this.getRegion(position - 1);
            RegionIterator it = new RegionIterator(cr.getDocumentRegion(), cr.getTextRegion());
            ITextRegion nearestRegion = null;
            while (it.hasPrev()) {
                nearestRegion = it.prev();
                if (nearestRegion.getType() != "S" && nearestRegion.getType() != "COMMENT") break;
            }
            if (nearestRegion != null && (nearestRegion.getType() == "LBRACE" || nearestRegion.getType() == "RBRACE" || nearestRegion.getType() == "DELIMITER" || nearestRegion.getType() == "DECLARATION_DELIMITER")) {
                --shift;
            } else if (region == null) {
                --shift;
            }
            ++shift;
        }
        if (region != null && region.getType() == "LBRACE") {
            RegionIterator it = new RegionIterator(this.structuredDocument, position);
            shift = !it.hasPrev() || it.prev().getType() != "RBRACE" ? ++shift : 0;
        }
        return shift;
    }

    protected CompoundRegion prevCorrespondence(int position, String regionType) {
        RegionIterator it = new RegionIterator(this.structuredDocument, position - 1);
        ITextRegion region = null;
        int nest = 1;
        if (regionType == "RBRACE") {
            while (it.hasPrev()) {
                region = it.prev();
                if (region.getType() == "LBRACE") {
                    --nest;
                } else if (region.getType() == "RBRACE") {
                    ++nest;
                }
                if (nest <= 0) break;
            }
            if (nest == 0) {
                return new CompoundRegion(it.getStructuredDocumentRegion(), region);
            }
        }
        if (regionType == "SELECTOR_ATTRIBUTE_END") {
            while (it.hasPrev()) {
                region = it.prev();
                if (region.getType() == "SELECTOR_ATTRIBUTE_START") {
                    --nest;
                } else if (region.getType() == "SELECTOR_ATTRIBUTE_END") {
                    ++nest;
                }
                if (nest <= 0) break;
            }
            if (nest == 0) {
                return new CompoundRegion(it.getStructuredDocumentRegion(), region);
            }
        }
        if (regionType == "DECLARATION_VALUE_PARENTHESIS_CLOSE") {
            while (it.hasPrev()) {
                region = it.prev();
                if (region.getType() == "DECLARATION_VALUE_FUNCTION") {
                    --nest;
                } else if (region.getType() == "DECLARATION_VALUE_PARENTHESIS_CLOSE") {
                    ++nest;
                }
                if (nest <= 0) break;
            }
            if (nest == 0) {
                return new CompoundRegion(it.getStructuredDocumentRegion(), region);
            }
        }
        return null;
    }

    protected CompoundRegion prevCorrespondence(CompoundRegion region) {
        if (region == null) {
            return null;
        }
        IStructuredDocumentRegion flatNode = region.getDocumentRegion();
        int position = flatNode.getStart() + region.getStart();
        return this.prevCorrespondence(position, region.getType());
    }

    protected boolean setRangeForClose(DocumentCommand command) {
        int position = command.offset;
        if (position == -1 || this.structuredDocument.getLength() == 0) {
            return false;
        }
        try {
            int p = position == this.structuredDocument.getLength() ? position - 1 : position;
            int line = this.structuredDocument.getLineOfOffset(p);
            int start = this.structuredDocument.getLineOffset(line);
            RegionIterator it = new RegionIterator(this.structuredDocument, start);
            boolean allWhiteSpace = false;
            while (it.hasNext()) {
                ITextRegion region = it.next();
                if (region.getType() != "S") break;
                if (it.getStructuredDocumentRegion().getEndOffset(region) <= p) continue;
                allWhiteSpace = true;
                break;
            }
            if (allWhiteSpace) {
                command.length -= start - command.offset;
                command.offset = start;
                return true;
            }
        }
        catch (BadLocationException excp) {
            Logger.logException(excp);
        }
        return false;
    }

    protected void setRangeForNewLine(DocumentCommand command) {
        int position = command.offset;
        if (position == -1 || this.structuredDocument.getLength() == 0) {
            return;
        }
        try {
            ITextRegion region;
            IStructuredDocumentRegion flatNode;
            if (position > 0 && (flatNode = this.structuredDocument.getRegionAtCharacterOffset(position - 1)) != null && (region = flatNode.getRegionAtCharacterOffset(position - 1)).getType() == "S") {
                int end = command.offset + command.length;
                int nLine = this.structuredDocument.getLineOfOffset(position);
                int nStartPos = this.structuredDocument.getLineOffset(nLine);
                if (nStartPos < flatNode.getStartOffset(region)) {
                    nStartPos = flatNode.getStartOffset(region);
                }
                command.offset = nStartPos;
                command.length = end - command.offset;
            }
            if (position < this.structuredDocument.getLength() && (flatNode = this.structuredDocument.getRegionAtCharacterOffset(position)) != null && (region = flatNode.getRegionAtCharacterOffset(position)).getType() == "S") {
                int nLine = this.structuredDocument.getLineOfOffset(position);
                String currentLineDelim = this.structuredDocument.getLineDelimiter(nLine);
                int nEndPos = this.structuredDocument.getLineOffset(nLine) + this.structuredDocument.getLineLength(nLine) - (currentLineDelim != null ? currentLineDelim.length() : 0);
                if (nEndPos > flatNode.getEndOffset(region)) {
                    nEndPos = flatNode.getEndOffset(region);
                }
                command.length = nEndPos - command.offset;
            }
        }
        catch (BadLocationException badLocationException) {}
    }

    private static int endsWith(String[] searchStrings, String text) {
        int i = 0;
        while (i < searchStrings.length) {
            if (text.endsWith(searchStrings[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private static int findEndOfWhiteSpace(IDocument document, int offset, int end) throws BadLocationException {
        while (offset < end) {
            char c = document.getChar(offset);
            if (c != ' ' && c != '\t') {
                return offset;
            }
            ++offset;
        }
        return end;
    }

    private String getIndentString() {
        StringBuffer indent = new StringBuffer();
        Preferences preferences = CSSCorePlugin.getDefault().getPluginPreferences();
        if (preferences != null) {
            char indentChar = ' ';
            String indentCharPref = preferences.getString("indentationChar");
            if ("tab".equals(indentCharPref)) {
                indentChar = '\t';
            }
            int indentationWidth = preferences.getInt("indentationSize");
            int i = 0;
            while (i < indentationWidth) {
                indent.append(indentChar);
                ++i;
            }
        }
        return indent.toString();
    }

    private void smartInsertForTab(DocumentCommand command, IDocument document) {
        Preferences preferences = CSSCorePlugin.getDefault().getPluginPreferences();
        if ("space".equals(preferences.getString("indentationChar"))) {
            int indentationWidth = preferences.getInt("indentationSize");
            StringBuffer indent = new StringBuffer();
            if (indentationWidth != 0) {
                int indentSize = indentationWidth;
                try {
                    IRegion firstLine = document.getLineInformationOfOffset(command.offset);
                    int offsetInLine = command.offset - firstLine.getOffset();
                    int remainder = offsetInLine % indentationWidth;
                    indentSize = indentationWidth - remainder;
                }
                catch (BadLocationException e) {
                    Logger.log(202, e.getMessage(), e);
                }
                int i = 0;
                while (i < indentSize) {
                    indent.append(' ');
                    ++i;
                }
            }
            command.text = indent.toString();
        }
    }

    class CompoundRegion {
        private IStructuredDocumentRegion documentRegion;
        private ITextRegion textRegion;

        CompoundRegion(IStructuredDocumentRegion documentRegion, ITextRegion textRegion) {
            this.documentRegion = documentRegion;
            this.textRegion = textRegion;
        }

        IStructuredDocumentRegion getDocumentRegion() {
            return this.documentRegion;
        }

        ITextRegion getTextRegion() {
            return this.textRegion;
        }

        int getStart() {
            return this.textRegion != null ? this.textRegion.getStart() : this.documentRegion.getStart();
        }

        int getEnd() {
            return this.textRegion != null ? this.textRegion.getEnd() : this.documentRegion.getEnd();
        }

        String getType() {
            return this.textRegion != null ? this.textRegion.getType() : "UNKNOWN";
        }

        String getText() {
            return this.textRegion != null ? this.documentRegion.getText(this.textRegion) : "";
        }

        int getStartOffset() {
            return this.textRegion != null ? this.documentRegion.getStartOffset(this.textRegion) : this.documentRegion.getStartOffset();
        }

        int getEndOffset() {
            return this.textRegion != null ? this.documentRegion.getEndOffset(this.textRegion) : this.documentRegion.getEndOffset();
        }
    }
}

