/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.internal.wip;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.wst.jsdt.chromium.Breakpoint;
import org.eclipse.wst.jsdt.chromium.CallFrame;
import org.eclipse.wst.jsdt.chromium.DebugContext;
import org.eclipse.wst.jsdt.chromium.ExceptionData;
import org.eclipse.wst.jsdt.chromium.JavascriptVm;
import org.eclipse.wst.jsdt.chromium.JsDeclarativeVariable;
import org.eclipse.wst.jsdt.chromium.JsEvaluateContext;
import org.eclipse.wst.jsdt.chromium.JsObject;
import org.eclipse.wst.jsdt.chromium.JsScope;
import org.eclipse.wst.jsdt.chromium.JsValue;
import org.eclipse.wst.jsdt.chromium.JsVariable;
import org.eclipse.wst.jsdt.chromium.RelayOk;
import org.eclipse.wst.jsdt.chromium.RemoteValueMapping;
import org.eclipse.wst.jsdt.chromium.RestartFrameExtension;
import org.eclipse.wst.jsdt.chromium.SyncCallback;
import org.eclipse.wst.jsdt.chromium.TextStreamPosition;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.JsonProtocolParseException;
import org.eclipse.wst.jsdt.chromium.internal.wip.EvaluateHack;
import org.eclipse.wst.jsdt.chromium.internal.wip.WipBrowserImpl;
import org.eclipse.wst.jsdt.chromium.internal.wip.WipCommandCallback;
import org.eclipse.wst.jsdt.chromium.internal.wip.WipCommandProcessor;
import org.eclipse.wst.jsdt.chromium.internal.wip.WipEvaluateContextBase;
import org.eclipse.wst.jsdt.chromium.internal.wip.WipScriptImpl;
import org.eclipse.wst.jsdt.chromium.internal.wip.WipScriptManager;
import org.eclipse.wst.jsdt.chromium.internal.wip.WipTabImpl;
import org.eclipse.wst.jsdt.chromium.internal.wip.WipValueBuilder;
import org.eclipse.wst.jsdt.chromium.internal.wip.WipValueLoader;
import org.eclipse.wst.jsdt.chromium.internal.wip.protocol.WipParserAccess;
import org.eclipse.wst.jsdt.chromium.internal.wip.protocol.input.WipCommandResponse;
import org.eclipse.wst.jsdt.chromium.internal.wip.protocol.input.debugger.CallFrameValue;
import org.eclipse.wst.jsdt.chromium.internal.wip.protocol.input.debugger.EvaluateOnCallFrameData;
import org.eclipse.wst.jsdt.chromium.internal.wip.protocol.input.debugger.PausedEventData;
import org.eclipse.wst.jsdt.chromium.internal.wip.protocol.input.debugger.RestartFrameData;
import org.eclipse.wst.jsdt.chromium.internal.wip.protocol.input.debugger.ResumedEventData;
import org.eclipse.wst.jsdt.chromium.internal.wip.protocol.input.debugger.ScopeValue;
import org.eclipse.wst.jsdt.chromium.internal.wip.protocol.input.runtime.EvaluateData;
import org.eclipse.wst.jsdt.chromium.internal.wip.protocol.input.runtime.InternalPropertyDescriptorValue;
import org.eclipse.wst.jsdt.chromium.internal.wip.protocol.input.runtime.PropertyDescriptorValue;
import org.eclipse.wst.jsdt.chromium.internal.wip.protocol.input.runtime.RemoteObjectValue;
import org.eclipse.wst.jsdt.chromium.internal.wip.protocol.output.WipParams;
import org.eclipse.wst.jsdt.chromium.internal.wip.protocol.output.WipParamsWithResponse;
import org.eclipse.wst.jsdt.chromium.internal.wip.protocol.output.debugger.EvaluateOnCallFrameParams;
import org.eclipse.wst.jsdt.chromium.internal.wip.protocol.output.debugger.RestartFrameParams;
import org.eclipse.wst.jsdt.chromium.internal.wip.protocol.output.debugger.ResumeParams;
import org.eclipse.wst.jsdt.chromium.internal.wip.protocol.output.debugger.StepIntoParams;
import org.eclipse.wst.jsdt.chromium.internal.wip.protocol.output.debugger.StepOutParams;
import org.eclipse.wst.jsdt.chromium.internal.wip.protocol.output.debugger.StepOverParams;
import org.eclipse.wst.jsdt.chromium.internal.wip.protocol.output.runtime.EvaluateParams;
import org.eclipse.wst.jsdt.chromium.util.AsyncFutureRef;
import org.eclipse.wst.jsdt.chromium.util.BasicUtil;
import org.eclipse.wst.jsdt.chromium.util.GenericCallback;
import org.eclipse.wst.jsdt.chromium.util.LazyConstructable;
import org.eclipse.wst.jsdt.chromium.util.MethodIsBlockingException;
import org.eclipse.wst.jsdt.chromium.util.RelaySyncCallback;
import org.json.simple.JSONObject;

class WipContextBuilder {
    private static final Logger LOGGER = Logger.getLogger(WipContextBuilder.class.getName());
    private final WipTabImpl tabImpl;
    private final EvaluateHack evaluateHack;
    private WipDebugContextImpl currentContext = null;
    public static final RestartFrameExtension RESTART_FRAME_EXTENSION = new RestartFrameExtension(){

        public RelayOk restartFrame(CallFrame callFrame, GenericCallback<Boolean> callback, SyncCallback syncCallback) {
            WipDebugContextImpl.CallFrameImpl callFrameImpl = (WipDebugContextImpl.CallFrameImpl)callFrame;
            return callFrameImpl.restart(callback, syncCallback);
        }

        public boolean canRestartFrame(CallFrame callFrame) {
            return callFrame.getScript() != null;
        }
    };
    private static final Map<ScopeValue.Type, JsScope.Type> WIP_TO_SDK_SCOPE_TYPE = new HashMap<ScopeValue.Type, JsScope.Type>();
    private static final WipValueLoader.Getter<ScopeVariables> EMPTY_SCOPE_VARIABLES_OPTIONAL;
    private static final ResumeParams RESUME_PARAMS;
    private static final StepIntoParams STEP_INTO_PARAMS;
    private static final StepOutParams STEP_OUT_PARAMS;
    private static final StepOverParams STEP_OVER_PARAMS;

    static {
        WIP_TO_SDK_SCOPE_TYPE.put(ScopeValue.Type.GLOBAL, JsScope.Type.GLOBAL);
        WIP_TO_SDK_SCOPE_TYPE.put(ScopeValue.Type.LOCAL, JsScope.Type.LOCAL);
        WIP_TO_SDK_SCOPE_TYPE.put(ScopeValue.Type.WITH, JsScope.Type.WITH);
        WIP_TO_SDK_SCOPE_TYPE.put(ScopeValue.Type.CLOSURE, JsScope.Type.CLOSURE);
        WIP_TO_SDK_SCOPE_TYPE.put(ScopeValue.Type.CATCH, JsScope.Type.CATCH);
        assert (WIP_TO_SDK_SCOPE_TYPE.size() == ScopeValue.Type.values().length);
        EMPTY_SCOPE_VARIABLES_OPTIONAL = new WipValueLoader.Getter<ScopeVariables>(){
            private final ScopeVariables value = new ScopeVariables(Collections.<JsDeclarativeVariable>emptyList(), Integer.MAX_VALUE);

            @Override
            ScopeVariables get() {
                return this.value;
            }
        };
        RESUME_PARAMS = new ResumeParams();
        STEP_INTO_PARAMS = new StepIntoParams();
        STEP_OUT_PARAMS = new StepOutParams();
        STEP_OVER_PARAMS = new StepOverParams();
    }

    WipContextBuilder(WipTabImpl tabImpl) {
        this.tabImpl = tabImpl;
        this.evaluateHack = new EvaluateHack(tabImpl);
    }

    RelayOk updateStackTrace(List<CallFrameValue> callFrames, GenericCallback<Void> callback, SyncCallback syncCallback) {
        if (this.currentContext == null) {
            if (callback != null) {
                callback.success(null);
            }
            return RelaySyncCallback.finish((SyncCallback)syncCallback);
        }
        return this.currentContext.setFrames(callFrames, callback, syncCallback);
    }

    void createContext(PausedEventData data) {
        WipDebugContextImpl context;
        if (this.currentContext != null) {
            LOGGER.severe("Context is already created");
            this.currentContext = null;
        }
        this.currentContext = context = new WipDebugContextImpl(data);
        GenericCallback<Void> callback = new GenericCallback<Void>(){

            public void success(Void value) {
                WipContextBuilder.this.tabImpl.getDebugListener().getDebugEventListener().suspended((DebugContext)context);
            }

            public void failure(Exception exception) {
                throw new RuntimeException(exception);
            }
        };
        context.setFrames(data.callFrames(), callback, null);
    }

    EvaluateHack getEvaluateHack() {
        return this.evaluateHack;
    }

    void onResumeReportedFromRemote(ResumedEventData event) {
        if (this.currentContext == null) {
            throw new IllegalStateException();
        }
        WipDebugContextImpl context = this.currentContext;
        this.currentContext = null;
        this.tabImpl.getDebugListener().getDebugEventListener().resumed();
        context.reportClosed();
    }

    static JsScope createScope(ScopeValue scopeData, WipValueLoader valueLoader, ScopeHolderParams holderParams, int scopeIndex) {
        JsScope.Type type = WIP_TO_SDK_SCOPE_TYPE.get((Object)scopeData.type());
        if (type == null) {
            type = JsScope.Type.UNKNOWN;
        }
        if (type == JsScope.Type.WITH || type == JsScope.Type.GLOBAL) {
            return new ObjectScopeImpl(scopeData, type, valueLoader);
        }
        ScopeParams scopeParams = new ScopeParams(holderParams, scopeIndex);
        return new DeclarativeScopeImpl(scopeData, scopeParams, type, valueLoader);
    }

    private WipParams sdkStepToProtocolStep(DebugContext.StepAction stepAction) {
        switch (stepAction) {
            case CONTINUE: {
                return RESUME_PARAMS;
            }
            case IN: {
                return STEP_INTO_PARAMS;
            }
            case OUT: {
                return STEP_OUT_PARAMS;
            }
            case OVER: {
                return STEP_OVER_PARAMS;
            }
        }
        throw new RuntimeException();
    }

    private static class DeclarativeScopeImpl
    implements JsScope.Declarative {
        private final AsyncFutureRef<WipValueLoader.Getter<ScopeVariables>> propertiesRef = new AsyncFutureRef();
        private final String objectId;
        private final ScopeParams scopeParams;
        private final JsScope.Type type;
        private final WipValueLoader valueLoader;

        public DeclarativeScopeImpl(ScopeValue scopeData, ScopeParams scopeParams, JsScope.Type type, WipValueLoader valueLoader) {
            this.type = type;
            this.scopeParams = scopeParams;
            this.objectId = scopeData.object().objectId();
            this.valueLoader = valueLoader;
        }

        public JsScope.Type getType() {
            return this.type;
        }

        public JsScope.Declarative asDeclarativeScope() {
            return this;
        }

        public JsScope.ObjectBased asObjectBased() {
            return null;
        }

        public <R> R accept(JsScope.Visitor<R> visitor) {
            return (R)visitor.visitDeclarative((JsScope.Declarative)this);
        }

        public List<? extends JsDeclarativeVariable> getVariables() throws MethodIsBlockingException {
            int currentCacheState = this.valueLoader.getCacheState();
            if (this.propertiesRef.isInitialized()) {
                ScopeVariables result = (ScopeVariables)((WipValueLoader.Getter)this.propertiesRef.getSync()).get();
                if (result.cacheState == currentCacheState) {
                    return result.variables;
                }
                this.startLoadOperation(true, currentCacheState);
            } else {
                this.startLoadOperation(false, currentCacheState);
            }
            return ((ScopeVariables)((WipValueLoader.Getter)this.propertiesRef.getSync()).get()).variables;
        }

        private void startLoadOperation(boolean reload, int currentCacheState) throws MethodIsBlockingException {
            WipValueLoader.LoadPostprocessor<WipValueLoader.Getter<ScopeVariables>> processor = new WipValueLoader.LoadPostprocessor<WipValueLoader.Getter<ScopeVariables>>(){

                @Override
                public WipValueLoader.Getter<ScopeVariables> process(List<? extends PropertyDescriptorValue> propertyList, List<? extends InternalPropertyDescriptorValue> internalPropertyList, int currentCacheState) {
                    ArrayList<JsDeclarativeVariable> properties = new ArrayList<JsDeclarativeVariable>(propertyList.size());
                    WipValueBuilder valueBuilder = DeclarativeScopeImpl.this.valueLoader.getValueBuilder();
                    for (PropertyDescriptorValue propertyDescriptorValue : propertyList) {
                        String name = propertyDescriptorValue.name();
                        JsDeclarativeVariable variable = valueBuilder.createDeclarativeVariable(propertyDescriptorValue.value(), name, DeclarativeScopeImpl.this.scopeParams);
                        properties.add(variable);
                    }
                    final ScopeVariables scopeVariables = new ScopeVariables(properties, currentCacheState);
                    return new WipValueLoader.Getter<ScopeVariables>(){

                        @Override
                        ScopeVariables get() {
                            return scopeVariables;
                        }
                    };
                }

                @Override
                public WipValueLoader.Getter<ScopeVariables> getEmptyResult() {
                    return EMPTY_SCOPE_VARIABLES_OPTIONAL;
                }

                @Override
                public WipValueLoader.Getter<ScopeVariables> forException(Exception exception) {
                    return WipValueLoader.Getter.newFailure(exception);
                }
            };
            this.valueLoader.loadPropertiesInFuture(this.objectId, processor, reload, currentCacheState, this.propertiesRef);
        }
    }

    static final class GlobalEvaluateContext
    extends WipEvaluateContextBase<EvaluateData> {
        GlobalEvaluateContext(WipValueLoader valueLoader) {
            super(valueLoader);
        }

        @Override
        protected WipParamsWithResponse<EvaluateData> createRequestParams(String expression, WipValueLoader destinationValueLoader) {
            boolean doNotPauseOnExceptions = true;
            return new EvaluateParams(expression, destinationValueLoader.getObjectGroupId(), false, doNotPauseOnExceptions, null, false, null);
        }

        @Override
        protected RemoteObjectValue getRemoteObjectValue(EvaluateData data) {
            return data.result();
        }

        @Override
        protected Boolean getWasThrown(EvaluateData data) {
            return data.wasThrown();
        }
    }

    private static class ObjectScopeImpl
    implements JsScope.ObjectBased {
        private final JsValue jsValue;
        private final JsScope.Type type;

        ObjectScopeImpl(ScopeValue scopeData, JsScope.Type type, WipValueLoader valueLoader) {
            this.jsValue = valueLoader.getValueBuilder().wrap(scopeData.object());
            this.type = type;
        }

        public JsScope.Type getType() {
            return this.type;
        }

        public JsScope.Declarative asDeclarativeScope() {
            return null;
        }

        public JsScope.ObjectBased asObjectBased() {
            return this;
        }

        public <R> R accept(JsScope.Visitor<R> visitor) {
            return (R)visitor.visitObject((JsScope.ObjectBased)this);
        }

        public JsObject getScopeObject() throws MethodIsBlockingException {
            JsObject jsObject = this.jsValue.asObject();
            if (jsObject == null) {
                throw new RuntimeException("Received scope object value is not an object");
            }
            return jsObject;
        }
    }

    static class ScopeHolderParams {
        private final String callFrameId;
        private final String functionId;

        ScopeHolderParams(String callFrameId, String functionId) {
            this.callFrameId = callFrameId;
            this.functionId = functionId;
        }
    }

    static class ScopeParams {
        private final ScopeHolderParams scopeHolder;
        private final int scopeIndex;

        private ScopeParams(ScopeHolderParams scopeHolder, int scopeIndex) {
            this.scopeHolder = scopeHolder;
            this.scopeIndex = scopeIndex;
        }

        String getCallFrameId() {
            return this.scopeHolder.callFrameId;
        }

        String getFunctionId() {
            return this.scopeHolder.functionId;
        }

        int getScopeNumber() {
            return this.scopeIndex;
        }
    }

    private static class ScopeVariables {
        final List<JsDeclarativeVariable> variables;
        final int cacheState;

        ScopeVariables(List<JsDeclarativeVariable> variables, int cacheState) {
            this.variables = variables;
            this.cacheState = cacheState;
        }
    }

    class WipDebugContextImpl
    implements DebugContext {
        private volatile List<CallFrameImpl> frames = null;
        private final ExceptionData exceptionData;
        private final AtomicReference<CloseRequest> closeRequest = new AtomicReference<Object>(null);
        private final JsEvaluateContext globalContext;
        private final WipValueLoader valueLoader;

        public WipDebugContextImpl(PausedEventData data) {
            this.valueLoader = new WipValueLoader(WipContextBuilder.this.tabImpl){

                @Override
                String getObjectGroupId() {
                    return null;
                }
            };
            PausedEventData.Data additionalData = data.data();
            if (data.reason() == PausedEventData.Reason.EXCEPTION && additionalData != null) {
                RemoteObjectValue exceptionRemoteObject;
                try {
                    JSONObject additionalDataObject = additionalData.getUnderlyingObject();
                    exceptionRemoteObject = WipParserAccess.get().parseRemoteObjectValue(additionalDataObject);
                }
                catch (JsonProtocolParseException e) {
                    throw new RuntimeException("Failed to parse exception data", e);
                }
                JsValue exceptionValue = this.valueLoader.getValueBuilder().wrap(exceptionRemoteObject);
                this.exceptionData = new ExceptionDataImpl(exceptionValue);
            } else {
                this.exceptionData = null;
            }
            this.globalContext = new GlobalEvaluateContext(this.getValueLoader());
        }

        RelayOk setFrames(List<CallFrameValue> frameDataList, final GenericCallback<Void> callback, SyncCallback syncCallback) {
            this.frames = new ArrayList<CallFrameImpl>(frameDataList.size());
            for (CallFrameValue frameData : frameDataList) {
                this.frames.add(new CallFrameImpl(frameData));
            }
            return WipContextBuilder.this.tabImpl.getScriptManager().loadScriptSourcesAsync(this.getScriptIds(), new WipScriptManager.ScriptSourceLoadCallback(){

                @Override
                public void done(Map<String, WipScriptImpl> loadedScripts) {
                    WipDebugContextImpl.this.setScripts(loadedScripts);
                    if (callback != null) {
                        callback.success(null);
                    }
                }
            }, syncCallback);
        }

        void resetFrames(List<CallFrameValue> frameDataList) {
            ArrayList<CallFrameImpl> newFrames = new ArrayList<CallFrameImpl>(frameDataList.size());
            int i = 0;
            while (i < frameDataList.size()) {
                CallFrameImpl callFrameImpl = new CallFrameImpl(frameDataList.get(i));
                callFrameImpl.setScript(this.frames.get(i).getScript());
                newFrames.add(callFrameImpl);
                ++i;
            }
            this.frames = newFrames;
        }

        WipValueLoader getValueLoader() {
            return this.valueLoader;
        }

        void reportClosed() {
            CloseRequest request = this.closeRequest.get();
            if (request != null && request.callback != null) {
                request.callback.success();
            }
        }

        Set<String> getScriptIds() {
            HashSet<String> scriptIds = new HashSet<String>();
            for (CallFrameImpl frame : this.frames) {
                String sourceId = frame.getSourceId();
                if (sourceId == null) continue;
                scriptIds.add(sourceId);
            }
            return scriptIds;
        }

        void setScripts(Map<String, WipScriptImpl> loadedScripts) {
            for (CallFrameImpl frame : this.frames) {
                String sourceId = frame.getSourceId();
                if (sourceId == null) continue;
                WipScriptImpl script = (WipScriptImpl)((Object)BasicUtil.getSafe(loadedScripts, (Object)sourceId));
                frame.setScript(script);
            }
        }

        public DebugContext.State getState() {
            if (this.exceptionData == null) {
                return DebugContext.State.NORMAL;
            }
            return DebugContext.State.EXCEPTION;
        }

        public ExceptionData getExceptionData() {
            return this.exceptionData;
        }

        public Collection<? extends Breakpoint> getBreakpointsHit() {
            if (this.frames.isEmpty()) {
                return Collections.emptyList();
            }
            CallFrameImpl topFrame = this.frames.get(0);
            return WipContextBuilder.this.tabImpl.getBreakpointManager().findRelatedBreakpoints(topFrame);
        }

        public List<? extends CallFrame> getCallFrames() {
            return this.frames;
        }

        public void continueVm(DebugContext.StepAction stepAction, int stepCount, DebugContext.ContinueCallback callback) {
            this.continueVm(stepAction, stepCount, callback, null);
        }

        public RelayOk continueVm(DebugContext.StepAction stepAction, int stepCount, final DebugContext.ContinueCallback callback, SyncCallback syncCallback) {
            boolean updated = this.closeRequest.compareAndSet(null, new CloseRequest(callback));
            if (!updated) {
                throw new IllegalStateException("Continue already requested");
            }
            WipParams params = WipContextBuilder.this.sdkStepToProtocolStep(stepAction);
            WipCommandCallback commandCallback = callback == null ? null : new WipCommandCallback(){

                public void messageReceived(WipCommandResponse response) {
                    callback.success();
                }

                public void failure(String message) {
                    callback.failure(message);
                }
            };
            return WipContextBuilder.this.tabImpl.getCommandProcessor().send(params, commandCallback, syncCallback);
        }

        public JsEvaluateContext getGlobalEvaluateContext() {
            return this.globalContext;
        }

        public RemoteValueMapping getDefaultRemoteValueMapping() {
            return this.valueLoader;
        }

        public WipTabImpl getTab() {
            return WipContextBuilder.this.tabImpl;
        }

        public WipCommandProcessor getCommandProcessor() {
            return WipContextBuilder.this.tabImpl.getCommandProcessor();
        }

        public JavascriptVm getJavascriptVm() {
            return WipContextBuilder.this.tabImpl;
        }

        class CallFrameImpl
        implements CallFrame {
            private final String functionName;
            private final String id;
            private final LazyConstructable<List<JsScope>> scopeData;
            private final JsVariable thisObject;
            private final TextStreamPosition streamPosition;
            private final String sourceId;
            private WipScriptImpl scriptImpl;
            private final WipEvaluateContextBase<?> evaluateContext;

            public CallFrameImpl(CallFrameValue frameData) {
                this.evaluateContext = new WipEvaluateContextBase<EvaluateOnCallFrameData>(WipDebugContextImpl.this.getValueLoader()){

                    @Override
                    protected WipParamsWithResponse<EvaluateOnCallFrameData> createRequestParams(String expression, WipValueLoader destinationValueLoader) {
                        return new EvaluateOnCallFrameParams(CallFrameImpl.this.id, expression, destinationValueLoader.getObjectGroupId(), false, null, false, null);
                    }

                    @Override
                    protected RemoteObjectValue getRemoteObjectValue(EvaluateOnCallFrameData data) {
                        return data.result();
                    }

                    @Override
                    protected Boolean getWasThrown(EvaluateOnCallFrameData data) {
                        return data.wasThrown();
                    }
                };
                this.functionName = frameData.functionName();
                this.id = frameData.callFrameId();
                this.sourceId = frameData.location().scriptId();
                final List<ScopeValue> scopeDataList = frameData.scopeChain();
                this.scopeData = LazyConstructable.create((LazyConstructable.Factory)new LazyConstructable.Factory<List<JsScope>>(){

                    public List<JsScope> construct() {
                        ArrayList<JsScope> scopes = new ArrayList<JsScope>(scopeDataList.size());
                        ScopeHolderParams holderParams = new ScopeHolderParams(CallFrameImpl.this.id, null);
                        int i = 0;
                        while (i < scopeDataList.size()) {
                            ScopeValue scopeData = (ScopeValue)scopeDataList.get(i);
                            scopes.add(WipContextBuilder.createScope(scopeData, WipDebugContextImpl.this.valueLoader, holderParams, i));
                            ++i;
                        }
                        return scopes;
                    }
                });
                RemoteObjectValue thisObjectData = frameData.getThis();
                if (thisObjectData == null) {
                    LOGGER.log(Level.SEVERE, "Missing local scope", new Exception());
                    this.thisObject = null;
                } else {
                    this.thisObject = this.createSimpleNameVariable("this", thisObjectData);
                }
                final int line = (int)frameData.location().lineNumber();
                Long columnObject = frameData.location().columnNumber();
                final int column = columnObject == null ? 0 : columnObject.intValue();
                this.streamPosition = new TextStreamPosition(){

                    public int getOffset() {
                        return (Integer)WipBrowserImpl.throwUnsupported();
                    }

                    public int getLine() {
                        return line;
                    }

                    public int getColumn() {
                        return column;
                    }
                };
            }

            String getSourceId() {
                return this.sourceId;
            }

            void setScript(WipScriptImpl scriptImpl) {
                this.scriptImpl = scriptImpl;
            }

            public List<? extends JsScope> getVariableScopes() {
                return (List)this.scopeData.get();
            }

            public JsVariable getReceiverVariable() {
                return this.thisObject;
            }

            public WipScriptImpl getScript() {
                return this.scriptImpl;
            }

            public TextStreamPosition getStatementStartPosition() {
                return this.streamPosition;
            }

            public String getFunctionName() {
                return this.functionName;
            }

            public JsEvaluateContext getEvaluateContext() {
                return this.evaluateContext;
            }

            private JsVariable createSimpleNameVariable(String name, RemoteObjectValue thisObjectData) {
                return WipDebugContextImpl.this.valueLoader.getValueBuilder().createVariable(thisObjectData, name);
            }

            RelayOk restart(final GenericCallback<Boolean> callback, SyncCallback syncCallback) {
                RelaySyncCallback relaySyncCallback = new RelaySyncCallback(syncCallback);
                final RelaySyncCallback.Guard guard = relaySyncCallback.newGuard();
                RestartFrameParams params = new RestartFrameParams(this.id);
                WipCommandProcessor commandProcessor = WipDebugContextImpl.this.valueLoader.getTabImpl().getCommandProcessor();
                GenericCallback<RestartFrameData> commandCallback = new GenericCallback<RestartFrameData>(){

                    public void success(RestartFrameData value) {
                        RelayOk relayOk = CallFrameImpl.this.handleRestartFrameData(value, (GenericCallback<Boolean>)callback, guard.getRelay());
                        guard.discharge(relayOk);
                    }

                    public void failure(Exception exception) {
                        if (callback != null) {
                            callback.failure(exception);
                        }
                    }
                };
                return commandProcessor.send(params, commandCallback, guard.asSyncCallback());
            }

            private RelayOk handleRestartFrameData(RestartFrameData data, GenericCallback<Boolean> callback, RelaySyncCallback relay) {
                if (WipContextBuilder.this.currentContext != WipDebugContextImpl.this) {
                    return this.finishSuccessfulRestart(false, callback, relay);
                }
                WipDebugContextImpl.this.resetFrames(data.callFrames());
                return this.finishSuccessfulRestart(false, callback, relay);
            }

            private RelayOk finishSuccessfulRestart(boolean vmResumed, GenericCallback<Boolean> callback, RelaySyncCallback relay) {
                if (callback != null) {
                    callback.success((Object)vmResumed);
                }
                return relay.finish();
            }
        }

        private class CloseRequest {
            final DebugContext.ContinueCallback callback;

            CloseRequest(DebugContext.ContinueCallback callback) {
                this.callback = callback;
            }
        }

        private class ExceptionDataImpl
        implements ExceptionData {
            private final JsValue exceptionValue;

            ExceptionDataImpl(JsValue exceptionValue) {
                this.exceptionValue = exceptionValue;
            }

            public JsValue getExceptionValue() {
                return this.exceptionValue;
            }

            public boolean isUncaught() {
                return false;
            }

            public String getSourceText() {
                return null;
            }

            public String getExceptionMessage() {
                return this.exceptionValue.getValueString();
            }
        }
    }
}

