/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.util;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;

public class ByteToCharConverter {
    private static final int REMAINDER_MAX_SIZE = 10;
    private final CharsetDecoder decoder;
    private final ByteBuffer unprocessedBuffer;

    public ByteToCharConverter(Charset charset) {
        this.decoder = charset.newDecoder();
        this.unprocessedBuffer = ByteBuffer.wrap(new byte[10]);
        this.unprocessedBuffer.flip();
    }

    public CharBuffer convert(ByteBuffer input) {
        CharBuffer result = this.convertImpl(input);
        result.flip();
        return result;
    }

    private CharBuffer convertImpl(ByteBuffer input) {
        CoderResult res;
        int bytesCount = input.remaining() + this.unprocessedBuffer.remaining() + 1;
        CharBuffer out = CharBuffer.allocate((int)((float)bytesCount * this.decoder.maxCharsPerByte()));
        if (this.unprocessedBuffer.hasRemaining()) {
            do {
                if (!input.hasRemaining()) {
                    return out;
                }
                this.unprocessedBuffer.compact();
                this.unprocessedBuffer.put(input.get());
                this.unprocessedBuffer.flip();
                res = this.decoder.decode(this.unprocessedBuffer, out, false);
                if (res.isUnderflow()) continue;
                throw new RuntimeException("Unexpected error: " + res);
            } while (this.unprocessedBuffer.position() <= 0);
            assert (!this.unprocessedBuffer.hasRemaining());
        }
        if (!input.hasRemaining()) {
            return out;
        }
        res = this.decoder.decode(input, out, false);
        if (!res.isUnderflow()) {
            throw new RuntimeException("Unexpected error: " + res);
        }
        this.unprocessedBuffer.clear();
        while (input.hasRemaining()) {
            this.unprocessedBuffer.put(input.get());
        }
        this.unprocessedBuffer.flip();
        return out;
    }
}

