/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.js.node.internal.launch;

import java.io.File;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wst.jsdt.core.runtime.IJSRunner;
import org.eclipse.wst.jsdt.core.runtime.IJSRuntimeInstall;
import org.eclipse.wst.jsdt.core.runtime.JSRunnerConfiguration;
import org.eclipse.wst.jsdt.core.runtime.JSRuntimeManager;
import org.eclipse.wst.jsdt.js.node.internal.Messages;
import org.eclipse.wst.jsdt.js.node.internal.NodeConstants;
import org.eclipse.wst.jsdt.js.node.internal.util.LaunchConfigurationUtil;
import org.eclipse.wst.jsdt.launching.ExecutionArguments;

public class NodeLaunchConfigurationDelegate
extends LaunchConfigurationDelegate {
    public void launch(ILaunchConfiguration configuration, final String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        if (mode.equals("debug") && !LaunchConfigurationUtil.isChromiumAvailable()) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.jsdt.js.node", Messages.LAUNCH_CONFIGURATION_CHROMIUM_IS_NOT_AVAILABLE_ERROR));
        }
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(NLS.bind((String)"{0}...", (Object[])new String[]{configuration.getName()}), 3);
        if (monitor.isCanceled()) {
            return;
        }
        try {
            String mainTypeName = configuration.getAttribute("attr_app_path", "");
            mainTypeName = LaunchConfigurationUtil.resolveValue(mainTypeName);
            IJSRunner runner = this.getJSRunner(configuration, mode);
            if (runner == null) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.jsdt.js.node", Messages.LAUNCH_CONFIGURATION_NO_RUNNER_FOUND_ERROR));
            }
            File workingDir = this.verifyWorkingDirectory(configuration);
            String workingDirName = null;
            if (workingDir != null) {
                workingDirName = workingDir.getAbsolutePath();
            }
            String[] envp = this.getEnvironment(configuration);
            String pgmArgs = this.getProgramArguments(configuration);
            String nodeArgs = this.getNodeArguments(configuration);
            if (mode.equals("debug")) {
                String debugPort = configuration.getAttribute("attr_port_field", String.valueOf(5858));
                Boolean isBreakEnable = configuration.getAttribute("attr_break_field", true);
                nodeArgs = isBreakEnable != false ? "--debug-brk=" + debugPort + " " + nodeArgs : "--debug=" + debugPort + " " + nodeArgs;
            }
            ExecutionArguments execArgs = new ExecutionArguments(nodeArgs, pgmArgs);
            JSRunnerConfiguration runConfig = new JSRunnerConfiguration(mainTypeName);
            runConfig.setProgramArguments(execArgs.getProgramArgumentsArray());
            runConfig.setEnvironment(envp);
            runConfig.setJSRuntimeArguments(execArgs.getVMArgumentsArray());
            runConfig.setWorkingDirectory(workingDirName);
            if (monitor.isCanceled()) {
                return;
            }
            monitor.worked(1);
            runner.run(runConfig, launch, monitor);
            if (mode.equals("debug")) {
                String project = configuration.getAttribute("attr_app_project", "");
                String projectRelativePath = configuration.getAttribute("attr_app_project_relative_path", "");
                ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
                ILaunchConfigurationType type = launchManager.getLaunchConfigurationType("org.eclipse.wst.jsdt.chromium.debug.ui.LaunchType$StandaloneV8");
                IContainer container = null;
                final ILaunchConfigurationWorkingCopy chromiumLaunch = type.newInstance(container, configuration.getName());
                chromiumLaunch.setAttribute("debug_host", configuration.getAttribute("attr_host_field", "localhost"));
                chromiumLaunch.setAttribute("debug_port", Integer.parseInt(configuration.getAttribute("attr_port_field", String.valueOf(5858))));
                chromiumLaunch.setAttribute("add_network_console", configuration.getAttribute("attr_add_network_console_field", false));
                chromiumLaunch.setAttribute("breakpoint_startup_sync_direction", "MERGE");
                chromiumLaunch.setAttribute("source_lookup_mode", "EXACT_MATCH");
                chromiumLaunch.setAttribute("predefined_source_wrapperd_ids", this.encode(NodeConstants.PREDEFIENED_WRAPPERS));
                chromiumLaunch.setAttribute("attr_app_project", project);
                chromiumLaunch.setAttribute("attr_app_project_relative_path", projectRelativePath);
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        DebugUITools.launch((ILaunchConfiguration)chromiumLaunch, (String)mode);
                    }
                });
            }
            if (monitor.isCanceled()) {
                return;
            }
        }
        finally {
            monitor.done();
        }
    }

    public IJSRunner getJSRunner(ILaunchConfiguration configuration, String mode) throws CoreException {
        IJSRuntimeInstall runtimeInstall = this.verifyJSRuntimeInstall(configuration);
        if (runtimeInstall != null) {
            return runtimeInstall.getJSRunner(mode);
        }
        return null;
    }

    public IJSRuntimeInstall verifyJSRuntimeInstall(ILaunchConfiguration configuration) throws CoreException {
        return this.getJSRuntimeInstall(configuration);
    }

    public IJSRuntimeInstall getJSRuntimeInstall(ILaunchConfiguration configuration) throws CoreException {
        return JSRuntimeManager.getDefaultRuntimeInstall((String)"org.eclipse.wst.jsdt.js.node.runtimeType");
    }

    public File verifyWorkingDirectory(ILaunchConfiguration configuration) throws CoreException {
        String projectName;
        File workingPath = null;
        String workingDirectory = configuration.getAttribute("attr_working_directory", "");
        if (workingDirectory.equals("") && !(projectName = configuration.getAttribute("attr_app_project", "")).equals("")) {
            workingDirectory = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName).getLocation().toOSString();
        }
        if (workingDirectory.length() > 0 && (workingDirectory = LaunchConfigurationUtil.resolveValue(workingDirectory)) != null) {
            workingPath = new File(workingDirectory);
        }
        return workingPath;
    }

    public String[] getEnvironment(ILaunchConfiguration configuration) throws CoreException {
        return DebugPlugin.getDefault().getLaunchManager().getEnvironment(configuration);
    }

    public String getProgramArguments(ILaunchConfiguration configuration) throws CoreException {
        String appArguments = configuration.getAttribute("attr_app_arguments", "");
        return VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(appArguments);
    }

    public String getNodeArguments(ILaunchConfiguration configuration) throws CoreException {
        String nodeArguments = configuration.getAttribute("attr_node_arguments", "");
        String args = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(nodeArguments);
        return args;
    }

    private String encode(List<String> wrappers) {
        StringBuilder output = new StringBuilder();
        Collections.sort(wrappers);
        for (String wrapper : wrappers) {
            output.append(wrapper.length());
            output.append('(').append(wrapper).append(')');
        }
        return output.toString();
    }
}

