/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.json.impl.schema;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.json.impl.schema.JSONSchemaProperty;
import org.eclipse.json.provisonnal.com.eclipsesource.json.JsonObject;
import org.eclipse.json.schema.IJSONSchemaNode;
import org.eclipse.json.schema.IJSONSchemaProperty;

public class JSONSchemaNode
extends JsonObject
implements IJSONSchemaNode {
    private final IJSONSchemaNode parent;
    private final Map<String, IJSONSchemaProperty> properties;

    public JSONSchemaNode(JsonObject jsonObject, IJSONSchemaNode parent) {
        this.parent = parent;
        this.properties = new HashMap<String, IJSONSchemaProperty>();
        JSONSchemaNode.walk(jsonObject, this);
    }

    private static void walk(JsonObject json, JSONSchemaNode schemaNode) {
        JsonObject.Member member2 = null;
        JsonObject properties = (JsonObject)json.get("properties");
        if (properties != null) {
            for (JsonObject.Member member2 : properties) {
                schemaNode.addProperty(new JSONSchemaProperty(member2.getName(), (JsonObject)member2.getValue(), schemaNode));
            }
        }
    }

    private void addProperty(IJSONSchemaProperty property) {
        this.properties.put(property.getName(), property);
    }

    @Override
    public IJSONSchemaNode getParent() {
        return this.parent;
    }

    @Override
    public IJSONSchemaProperty[] getProperties() {
        return this.properties.values().toArray(IJSONSchemaProperty.EMPTY_PROPERTY);
    }
}

