/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.debug.core;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourcePathComputerDelegate;
import org.eclipse.debug.core.sourcelookup.containers.FolderSourceContainer;
import org.eclipse.debug.core.sourcelookup.containers.ProjectSourceContainer;
import org.eclipse.wst.jsdt.chromium.debug.core.SourceNameMapperContainer;
import org.eclipse.wst.jsdt.chromium.debug.core.VProjectSourceContainer;

public class ChromiumSourceComputer
implements ISourcePathComputerDelegate {
    public ISourceContainer[] computeSourceContainers(ILaunchConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        Path resourcePath;
        IFile resource;
        IProject project;
        ArrayList<Object> containers = new ArrayList<Object>();
        String projectName = configuration.getAttribute("attr_app_project", null);
        String path = configuration.getAttribute("attr_app_project_relative_path", null);
        if (projectName != null && path != null && (project = this.getProject(projectName)) != null && project.isAccessible() && (resource = project.getFile((IPath)(resourcePath = new Path(path)))).isAccessible()) {
            IContainer container = resource.getParent();
            String mapping = container.getLocation().toOSString();
            SourceNameMapperContainer workspaceConatiner = this.createWorkspaceSourceContainer(container, mapping);
            containers.add(workspaceConatiner);
        }
        containers.add(new VProjectSourceContainer());
        return containers.toArray(new ISourceContainer[containers.size()]);
    }

    private IProject getProject(String name) {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(name);
    }

    private SourceNameMapperContainer createWorkspaceSourceContainer(IContainer container, String path) {
        ProjectSourceContainer sourceContainer = null;
        if (container instanceof IProject) {
            sourceContainer = new ProjectSourceContainer((IProject)container, true);
        } else if (container instanceof IFolder) {
            sourceContainer = new FolderSourceContainer((IContainer)((IFolder)container), true);
        }
        return new SourceNameMapperContainer(String.valueOf(path) + System.getProperty("file.separator"), (ISourceContainer)sourceContainer);
    }
}

