/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cache.interceptor;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.util.Assert;

public abstract class CacheOperation {
    private Set<String> cacheNames = Collections.emptySet();
    private String condition = "";
    private String key = "";
    private String name = "";

    public Set<String> getCacheNames() {
        return this.cacheNames;
    }

    public String getCondition() {
        return this.condition;
    }

    public String getKey() {
        return this.key;
    }

    public String getName() {
        return this.name;
    }

    public void setCacheName(String cacheName) {
        Assert.hasText((String)cacheName);
        this.cacheNames = Collections.singleton(cacheName);
    }

    public void setCacheNames(String[] cacheNames) {
        Assert.notEmpty((Object[])cacheNames);
        this.cacheNames = new LinkedHashSet<String>(cacheNames.length);
        for (String string : cacheNames) {
            this.cacheNames.add(string);
        }
    }

    public void setCondition(String condition) {
        Assert.notNull((Object)condition);
        this.condition = condition;
    }

    public void setKey(String key) {
        Assert.notNull((Object)key);
        this.key = key;
    }

    public void setName(String name) {
        Assert.hasText((String)name);
        this.name = name;
    }

    public boolean equals(Object other) {
        return other instanceof CacheOperation && this.toString().equals(other.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return this.getOperationDescription().toString();
    }

    protected StringBuilder getOperationDescription() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getSimpleName());
        result.append("[");
        result.append(this.name);
        result.append("] caches=");
        result.append(this.cacheNames);
        result.append(" | key='");
        result.append(this.key);
        result.append("' | condition='");
        result.append(this.condition);
        result.append("'");
        return result;
    }
}

