/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.validation.internal.wsdl11.http;

import com.ibm.wsdl.extensions.http.HTTPAddressImpl;
import com.ibm.wsdl.extensions.http.HTTPBindingImpl;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.wsdl.Binding;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.Port;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.http.HTTPOperation;
import org.eclipse.wst.wsdl.validation.internal.util.MessageGenerator;
import org.eclipse.wst.wsdl.validation.internal.wsdl11.IWSDL11ValidationInfo;
import org.eclipse.wst.wsdl.validation.internal.wsdl11.IWSDL11Validator;

public class HTTPValidator
implements IWSDL11Validator {
    private static String HTTP_RESOURCE_BUNDLE_NAME = "validatewsdlhttp";
    private final String _ERROR_INVALID_PORT_ELEMENT = "_ERROR_INVALID_PORT_ELEMENT";
    private final String _ERROR_INVALID_BINDING_ELEMENT = "_ERROR_INVALID_BINDING_ELEMENT";
    private final String _ERROR_INVALID_BINDING_OPERATION_ELEMENT = "_ERROR_INVALID_BINDING_OPERATION_ELEMENT";
    private final String _ERROR_INVALID_BINDING_INPUT_ELEMENT = "_ERROR_INVALID_BINDING_INPUT_ELEMENT";
    private final String _ERROR_INVALID_HTTP_ELEMENT_FOR_LOCATION = "_ERROR_INVALID_HTTP_ELEMENT_FOR_LOCATION";
    private final String _ERROR_NO_LOCATION_FOR_ADDRESS = "_ERROR_NO_LOCATION_FOR_ADDRESS";
    private final String _ERROR_NO_HTTPBINDING_FOR_ADDRESS = "_ERROR_NO_HTTPBINDING_FOR_ADDRESS";
    private final String _ERROR_INVALID_BINDING_VERB = "_ERROR_INVALID_BINDING_VERB";
    private final String _ERROR_INVALID_LOCATION_URI = "_ERROR_INVALID_LOCATION_URI";
    private final String _ERROR_NO_HTTPBINDING_FOR_OPERATION = "_ERROR_NO_HTTPBINDING_FOR_OPERATION";
    private final String _ERROR_NOT_ONLY_ELEMENT_DEFINED = "_ERROR_NOT_ONLY_ELEMENT_DEFINED";
    private final String _ERROR_NO_HTTPOPERATION_FOR_URL = "_ERROR_NO_HTTPOPERATION_FOR_URL";
    private final String GET = "GET";
    private final String POST = "POST";
    private final String QUOTE = "'";
    private final String EMPTY_STRING = "";
    private MessageGenerator messagegenerator;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;

    public HTTPValidator() {
        ResourceBundle rb = ResourceBundle.getBundle(HTTP_RESOURCE_BUNDLE_NAME, Locale.getDefault());
        this.messagegenerator = new MessageGenerator(rb);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void validate(Object element, List parents, IWSDL11ValidationInfo valInfo) {
        Class<?> clazz = parents.get(0).getClass();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            Class<?> clazz3;
            try {
                clazz3 = Class.forName("com.ibm.wsdl.PortImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            clazz2 = class$0 = clazz3;
        }
        if (clazz == clazz2) {
            Class<?> clazz4 = element.getClass();
            Class<?> clazz5 = class$1;
            if (clazz5 == null) {
                Class<?> clazz6;
                try {
                    clazz6 = Class.forName("com.ibm.wsdl.extensions.http.HTTPAddressImpl");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                clazz5 = class$1 = clazz6;
            }
            if (clazz4 == clazz5) {
                this.validateAddress(element, parents, valInfo);
                return;
            }
            ExtensibilityElement e = (ExtensibilityElement)element;
            valInfo.addError(this.messagegenerator.getString("_ERROR_INVALID_PORT_ELEMENT", "'" + e.getElementType().getLocalPart() + "'"), element);
            return;
        }
        Class<?> clazz7 = parents.get(0).getClass();
        Class<?> clazz8 = class$2;
        if (clazz8 == null) {
            Class<?> clazz9;
            try {
                clazz9 = Class.forName("com.ibm.wsdl.BindingImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            clazz8 = class$2 = clazz9;
        }
        if (clazz7 == clazz8) {
            Class<?> clazz10 = element.getClass();
            Class<?> clazz11 = class$3;
            if (clazz11 == null) {
                Class<?> clazz12;
                try {
                    clazz12 = Class.forName("com.ibm.wsdl.extensions.http.HTTPBindingImpl");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                clazz11 = class$3 = clazz12;
            }
            if (clazz10 == clazz11) {
                this.validateBinding(element, parents, valInfo);
                return;
            }
            ExtensibilityElement e = (ExtensibilityElement)element;
            valInfo.addError(this.messagegenerator.getString("_ERROR_INVALID_BINDING_ELEMENT", "'" + e.getElementType().getLocalPart() + "'"), element);
            return;
        }
        Class<?> clazz13 = parents.get(0).getClass();
        Class<?> clazz14 = class$4;
        if (clazz14 == null) {
            Class<?> clazz15;
            try {
                clazz15 = Class.forName("com.ibm.wsdl.BindingOperationImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            clazz14 = class$4 = clazz15;
        }
        if (clazz13 == clazz14) {
            Class<?> clazz16 = element.getClass();
            Class<?> clazz17 = class$5;
            if (clazz17 == null) {
                Class<?> clazz18;
                try {
                    clazz18 = Class.forName("com.ibm.wsdl.extensions.http.HTTPOperationImpl");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                clazz17 = class$5 = clazz18;
            }
            if (clazz16 == clazz17) {
                this.validateOperation(element, parents, valInfo);
                return;
            }
            ExtensibilityElement e = (ExtensibilityElement)element;
            valInfo.addError(this.messagegenerator.getString("_ERROR_INVALID_BINDING_OPERATION_ELEMENT", "'" + e.getElementType().getLocalPart() + "'"), element);
            return;
        }
        Class<?> clazz19 = parents.get(0).getClass();
        Class<?> clazz20 = class$6;
        if (clazz20 == null) {
            Class<?> clazz21;
            try {
                clazz21 = Class.forName("com.ibm.wsdl.BindingInputImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            clazz20 = class$6 = clazz21;
        }
        if (clazz19 != clazz20) {
            ExtensibilityElement e = (ExtensibilityElement)element;
            valInfo.addError(this.messagegenerator.getString("_ERROR_INVALID_HTTP_ELEMENT_FOR_LOCATION", "'" + e.getElementType().getLocalPart() + "'"), element);
            return;
        }
        Class<?> clazz22 = element.getClass();
        Class<?> clazz23 = class$7;
        if (clazz23 == null) {
            Class<?> clazz24;
            try {
                clazz24 = Class.forName("com.ibm.wsdl.extensions.http.HTTPUrlEncodedImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            clazz23 = class$7 = clazz24;
        }
        if (clazz22 != clazz23) {
            Class<?> clazz25 = element.getClass();
            Class<?> clazz26 = class$8;
            if (clazz26 == null) {
                Class<?> clazz27;
                try {
                    clazz27 = Class.forName("com.ibm.wsdl.extensions.http.HTTPUrlReplacementImpl");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                clazz26 = class$8 = clazz27;
            }
            if (clazz25 != clazz26) {
                ExtensibilityElement e = (ExtensibilityElement)element;
                valInfo.addError(this.messagegenerator.getString("_ERROR_INVALID_BINDING_INPUT_ELEMENT", "'" + e.getElementType().getLocalPart() + "'"), element);
                return;
            }
        }
        this.validateHttpUrl(element, parents, valInfo);
    }

    protected void validateAddress(Object element, List parents, IWSDL11ValidationInfo valInfo) {
        Port port;
        Binding binding;
        HTTPAddressImpl ha = (HTTPAddressImpl)element;
        String uri = ha.getLocationURI();
        if (uri == null || uri.equalsIgnoreCase("")) {
            valInfo.addError(this.messagegenerator.getString("_ERROR_NO_LOCATION_FOR_ADDRESS"), ha);
        }
        if (!this.hasHttpBinding(binding = (port = (Port)parents.get(0)).getBinding())) {
            valInfo.addError(this.messagegenerator.getString("_ERROR_NO_HTTPBINDING_FOR_ADDRESS", "'" + binding.getQName().getLocalPart() + "'", "'" + port.getName() + "'"), ha);
        }
    }

    protected void validateBinding(Object element, List parents, IWSDL11ValidationInfo valInfo) {
        HTTPBindingImpl hb = (HTTPBindingImpl)element;
        String verb = hb.getVerb();
        if (verb != null && !verb.equals("GET") && !verb.equals("POST")) {
            valInfo.addError(this.messagegenerator.getString("_ERROR_INVALID_BINDING_VERB", "'" + verb + "'"), element);
        }
    }

    protected void validateOperation(Object element, List parents, IWSDL11ValidationInfo valInfo) {
        Binding binding;
        HTTPOperation ho = (HTTPOperation)element;
        String locationURI = ho.getLocationURI();
        if (locationURI != null && locationURI.equalsIgnoreCase("")) {
            valInfo.addError(this.messagegenerator.getString("_ERROR_INVALID_LOCATION_URI"), element);
        }
        if (!this.hasHttpBinding(binding = (Binding)parents.get(1))) {
            valInfo.addError(this.messagegenerator.getString("_ERROR_NO_HTTPBINDING_FOR_OPERATION", "'" + binding.getQName().getLocalPart() + "'"), ho);
        }
    }

    protected void validateHttpUrl(Object element, List parents, IWSDL11ValidationInfo valInfo) {
        String elementName;
        BindingOperation operation = (BindingOperation)parents.get(1);
        Class<?> clazz = element.getClass();
        Class<?> clazz2 = class$7;
        if (clazz2 == null) {
            try {
                clazz2 = class$7 = Class.forName("com.ibm.wsdl.extensions.http.HTTPUrlEncodedImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz == clazz2) {
            elementName = "urlEncoded";
        } else {
            Class<?> clazz3 = element.getClass();
            Class<?> clazz4 = class$8;
            if (clazz4 == null) {
                try {
                    clazz4 = class$8 = Class.forName("com.ibm.wsdl.extensions.http.HTTPUrlReplacementImpl");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            elementName = clazz3 == clazz4 ? "urlReplacement" : "";
        }
        BindingInput input = (BindingInput)parents.get(0);
        if (input.getExtensibilityElements().size() != 1) {
            valInfo.addError(this.messagegenerator.getString("_ERROR_NOT_ONLY_ELEMENT_DEFINED", elementName), element);
        }
        if (!this.hasHttpOperation(operation)) {
            valInfo.addError(this.messagegenerator.getString("_ERROR_NO_HTTPOPERATION_FOR_URL", "'" + operation.getName() + "'", elementName), element);
        }
    }

    protected boolean hasHttpOperation(BindingOperation operation) {
        List extelems;
        if (operation != null && (extelems = operation.getExtensibilityElements()) != null) {
            Iterator iextelems = extelems.iterator();
            while (iextelems.hasNext()) {
                Class<?> clazz = iextelems.next().getClass();
                Class<?> clazz2 = class$5;
                if (clazz2 == null) {
                    try {
                        clazz2 = Class.forName("com.ibm.wsdl.extensions.http.HTTPOperationImpl");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz != clazz2) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean hasHttpBinding(Binding binding) {
        List extelems;
        if (binding != null && (extelems = binding.getExtensibilityElements()) != null) {
            Iterator iextelems = extelems.iterator();
            while (iextelems.hasNext()) {
                Class<?> clazz = iextelems.next().getClass();
                Class<?> clazz2 = class$3;
                if (clazz2 == null) {
                    try {
                        clazz2 = Class.forName("com.ibm.wsdl.extensions.http.HTTPBindingImpl");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz != clazz2) continue;
                return true;
            }
        }
        return false;
    }
}

