/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.reconcile;

import java.util.Map;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.quickassist.IQuickFixableAnnotation;
import org.eclipse.jface.text.reconciler.IReconcileResult;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationPresentation;
import org.eclipse.jface.text.source.ImageUtilities;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.AnnotationPreferenceLookup;
import org.eclipse.wst.sse.ui.internal.ITemporaryAnnotation;
import org.eclipse.wst.sse.ui.internal.reconcile.ReconcileAnnotationKey;

public class TemporaryAnnotation
extends Annotation
implements ITemporaryAnnotation,
IReconcileResult,
IAnnotationPresentation,
IQuickFixableAnnotation {
    public static final String ANNOT_ERROR = "org.eclipse.wst.sse.ui.temp.error";
    public static final String ANNOT_INFO = "org.eclipse.wst.sse.ui.temp.info";
    public static final String ANNOT_UNKNOWN = "org.eclipse.text.annotation.unknown";
    public static final String ANNOT_WARNING = "org.eclipse.wst.sse.ui.temp.warning";
    private static final int INFO_LAYER;
    private static final int WARNING_LAYER;
    private static final int ERROR_LAYER;
    private Object fAdditionalFixInfo = null;
    private Object fKey = null;
    private Position fPosition = null;
    private Map fAttributes = null;
    private boolean fIsQuickFixable = false;
    private boolean fIsQuickFixableStateSet = false;
    private int fProblemID;
    private int fLayer = 0;
    private Image fImage = null;
    private static Image fInfoImage;
    private static Image fWarningImage;
    private static Image fErrorImage;

    static {
        AnnotationPreferenceLookup lookup = EditorsUI.getAnnotationPreferenceLookup();
        INFO_LAYER = TemporaryAnnotation.computeLayer(ANNOT_INFO, lookup);
        WARNING_LAYER = TemporaryAnnotation.computeLayer(ANNOT_WARNING, lookup);
        ERROR_LAYER = TemporaryAnnotation.computeLayer(ANNOT_ERROR, lookup);
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        fInfoImage = sharedImages.getImage("IMG_OBJS_INFO_TSK");
        fWarningImage = sharedImages.getImage("IMG_OBJS_WARN_TSK");
        fErrorImage = sharedImages.getImage("IMG_OBJS_ERROR_TSK");
    }

    private static int computeLayer(String annotationType, AnnotationPreferenceLookup lookup) {
        Annotation annotation = new Annotation(annotationType, false, null);
        AnnotationPreference preference = lookup.getAnnotationPreference(annotation);
        if (preference != null) {
            return preference.getPresentationLayer() + 1;
        }
        return 1;
    }

    public TemporaryAnnotation(Position p, String type, String message, ReconcileAnnotationKey key) {
        this.fPosition = p;
        this.setType(type);
        this.fKey = key;
        this.setText(message);
        this.initLayer();
        this.initImage();
    }

    public TemporaryAnnotation(Position p, String type, String message, ReconcileAnnotationKey key, int problemId) {
        this.fPosition = p;
        this.fKey = key;
        this.setType(type);
        this.setText(message);
        this.fProblemID = problemId;
        this.initLayer();
        this.initImage();
    }

    private void initLayer() {
        String type = this.getType();
        if (type.equals(ANNOT_ERROR)) {
            this.fLayer = ERROR_LAYER;
        } else if (type.equals(ANNOT_WARNING)) {
            this.fLayer = WARNING_LAYER;
        } else if (type.equals(ANNOT_INFO)) {
            this.fLayer = INFO_LAYER;
        }
    }

    private void initImage() {
        String type = this.getType();
        this.fImage = type.equals(ANNOT_ERROR) ? fErrorImage : (type.equals(ANNOT_WARNING) ? fWarningImage : (type.equals(ANNOT_INFO) ? fInfoImage : null));
    }

    public boolean equals(Object obj) {
        if (obj instanceof TemporaryAnnotation) {
            TemporaryAnnotation ta = (TemporaryAnnotation)obj;
            boolean samePosition = ta.getPosition().equals((Object)this.getPosition());
            boolean sameText = false;
            if (ta.getText() != null && this.getText() != null && ta.getText().equals(this.getText())) {
                sameText = true;
            } else if (ta.getText() == null && this.getText() == null) {
                sameText = true;
            }
            return sameText && samePosition;
        }
        return super.equals(obj);
    }

    public Object getAdditionalFixInfo() {
        return this.fAdditionalFixInfo;
    }

    public String getDescription() {
        return this.getText();
    }

    public Object getKey() {
        return this.fKey;
    }

    public Position getPosition() {
        return this.fPosition;
    }

    public int getProblemID() {
        return this.fProblemID;
    }

    public boolean isPersistent() {
        return false;
    }

    public void setAdditionalFixInfo(Object info) {
        this.fAdditionalFixInfo = info;
        this.setQuickFixable(true);
    }

    public int getLayer() {
        return this.fLayer;
    }

    public void paint(GC gc, Canvas canvas, Rectangle r) {
        this.initImage();
        if (this.fImage != null) {
            ImageUtilities.drawImage((Image)this.fImage, (GC)gc, (Canvas)canvas, (Rectangle)r, (int)0x1000000, (int)128);
        }
    }

    public String toString() {
        return "" + this.fPosition.getOffset() + ':' + this.fPosition.getLength() + ": " + this.getText();
    }

    public Map getAttributes() {
        return this.fAttributes;
    }

    public void setAttributes(Map attributes) {
        this.fAttributes = attributes;
    }

    public boolean isQuickFixable() {
        return this.fIsQuickFixable;
    }

    public void setQuickFixable(boolean state) {
        this.fIsQuickFixable = state;
        this.fIsQuickFixableStateSet = true;
    }

    public boolean isQuickFixableStateSet() {
        return this.fIsQuickFixableStateSet;
    }
}

