/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.debug.ui.actions;

import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionDelegate2;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public abstract class SelectionBasedAction<S>
implements IObjectActionDelegate,
IActionDelegate2 {
    private ActionRunnable currentRunnable = null;
    private Shell currentShell = null;
    private String originalActionText = null;
    private IWorkbenchPart currentTargetPart = null;
    private IAction action;

    protected abstract S readSelection(IStructuredSelection var1);

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.currentShell = targetPart.getSite().getShell();
        this.currentTargetPart = targetPart;
    }

    public void run(IAction action) {
        assert (action == this.getAction());
        if (this.currentRunnable == null) {
            return;
        }
        this.currentRunnable.run(this.currentShell, this.currentTargetPart);
        this.currentRunnable = null;
    }

    public void selectionChanged(IAction actionParam, ISelection selection) {
        this.currentRunnable = this.createRunnableFromRawSelection(selection);
        this.action.setEnabled(this.currentRunnable != null);
        if (this.currentRunnable == null) {
            this.restoreActionText();
        } else {
            this.currentRunnable.adjustAction();
        }
    }

    private ActionRunnable createRunnableFromRawSelection(ISelection selection) {
        if (!(selection instanceof IStructuredSelection)) {
            return null;
        }
        IStructuredSelection structured = (IStructuredSelection)selection;
        S selectedElements = this.readSelection(structured);
        return this.createRunnable(selectedElements);
    }

    protected abstract ActionRunnable createRunnable(S var1);

    protected void modifyActionText(String newText) {
        if (this.originalActionText == null) {
            this.originalActionText = this.action.getText();
        }
        this.action.setText(newText);
    }

    protected void restoreActionText() {
        if (this.originalActionText != null) {
            this.action.setText(this.originalActionText);
            this.originalActionText = null;
        }
    }

    protected IAction getAction() {
        return this.action;
    }

    public void dispose() {
        this.currentRunnable = null;
    }

    public void init(IAction action) {
        this.action = action;
    }

    public void runWithEvent(IAction action, Event event) {
        this.run(action);
    }

    protected static interface ActionRunnable {
        public void adjustAction();

        public void run(Shell var1, IWorkbenchPart var2);
    }

    static abstract class Multiple<T>
    extends SelectionBasedAction<List<? extends T>> {
        Multiple() {
        }
    }

    public static abstract class Single<T>
    extends SelectionBasedAction<T> {
        private final boolean allowMutipleSelection;

        protected Single(boolean allowMutipleSelection) {
            this.allowMutipleSelection = allowMutipleSelection;
        }

        @Override
        protected T readSelection(IStructuredSelection selection) {
            if (!this.allowMutipleSelection && selection.size() != 1) {
                return null;
            }
            T result = null;
            for (Object element : selection) {
                T userElement = this.castElement(element);
                if (userElement == null) continue;
                if (result != null) {
                    return null;
                }
                result = userElement;
            }
            return result;
        }

        protected abstract T castElement(Object var1);
    }
}

