/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.debug.ui.actions;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.ide.IDE;
import org.eclipse.wst.jsdt.chromium.debug.core.ChromiumDebugPlugin;
import org.eclipse.wst.jsdt.chromium.debug.core.util.ChromiumDebugPluginUtil;
import org.eclipse.wst.jsdt.chromium.debug.core.util.ScriptTargetMapping;
import org.eclipse.wst.jsdt.chromium.debug.ui.actions.FileBasedAction;
import org.eclipse.wst.jsdt.chromium.debug.ui.actions.SelectionBasedAction;

public abstract class V8ScriptAction
extends FileBasedAction.Single<IFile> {
    static final FileBasedAction.FileFilter<IFile> JS_FILE_NAME_FILTER = new FileBasedAction.FileFilter<IFile>(){

        @Override
        IFile accept(IFile file) {
            if (this.filterFileName(file.getName())) {
                return file;
            }
            return null;
        }

        private boolean filterFileName(String name) {
            for (String suffix : ChromiumDebugPluginUtil.SUPPORTED_EXTENSIONS_SUFFIX_LIST) {
                if (!name.endsWith(suffix)) continue;
                return true;
            }
            return false;
        }
    };

    public V8ScriptAction() {
        super(false, JS_FILE_NAME_FILTER);
    }

    @Override
    protected SelectionBasedAction.ActionRunnable createRunnable(final IFile file) {
        return new SelectionBasedAction.ActionRunnable(){

            @Override
            public void adjustAction() {
            }

            @Override
            public void run(Shell shell, IWorkbenchPart workbenchPart) {
                boolean saved = IDE.saveAllEditors((IResource[])new IResource[]{file}, (boolean)true);
                if (!saved) {
                    return;
                }
                List filePairList = ChromiumDebugPlugin.getScriptTargetMapping((IFile)file);
                V8ScriptAction.this.execute(filePairList, shell, workbenchPart);
            }
        };
    }

    protected abstract void execute(List<? extends ScriptTargetMapping> var1, Shell var2, IWorkbenchPart var3);
}

