/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.selection;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.ui.internal.PropertyAdapter;
import org.eclipse.jpt.common.ui.internal.jface.SelectionChangedAdapter;
import org.eclipse.jpt.common.ui.internal.swt.widgets.DisplayTools;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.model.value.DoublePropertyValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.TransformationPropertyValueModel;
import org.eclipse.jpt.common.utility.internal.transformer.AbstractTransformer;
import org.eclipse.jpt.common.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.common.utility.model.listener.PropertyChangeAdapter;
import org.eclipse.jpt.common.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.common.utility.transformer.Transformer;
import org.eclipse.jpt.jpa.core.JpaFile;
import org.eclipse.jpt.jpa.core.JpaStructureNode;
import org.eclipse.jpt.jpa.ui.JpaFileModel;
import org.eclipse.jpt.jpa.ui.internal.plugin.JptJpaUiPlugin;
import org.eclipse.jpt.jpa.ui.selection.JpaEditorManager;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.texteditor.ITextEditor;

class JpaTextEditorManager
implements JpaEditorManager {
    private final ITextEditor textEditor;
    private final IPropertyListener textEditorInputListener = new TextEditorInputListener();
    private final ISelectionChangedListener textEditorSelectionListener = new TextEditorSelectionListener();
    private final ModifiablePropertyValueModel<IFile> fileModel = new SimplePropertyValueModel();
    private final PropertyValueModel<JpaFile> jpaFileModel;
    private final PropertyChangeListener jpaFileListener = new JpaFileListener();
    private final ModifiablePropertyValueModel<JpaStructureNode> jpaSelectionModel = new SimplePropertyValueModel();
    private final PropertyChangeListener jpaSelectionListener = new JpaSelectionListener();
    private static final Transformer<IFile, PropertyValueModel<JpaFile>> JPA_FILE_MODEL_TRANSFORMER = new JpaFileModelTransformer();

    JpaTextEditorManager(ITextEditor textEditor) {
        this.textEditor = textEditor;
        this.textEditor.addPropertyListener(this.textEditorInputListener);
        IPostSelectionProvider selProvider = this.getTextEditorSelectionProvider();
        if (selProvider != null) {
            selProvider.addPostSelectionChangedListener(this.textEditorSelectionListener);
        }
        this.jpaFileModel = this.buildJpaFileModel();
        this.jpaFileModel.addPropertyChangeListener("value", this.jpaFileListener);
        this.jpaSelectionModel.addPropertyChangeListener("value", this.jpaSelectionListener);
        this.setFileModel();
    }

    @Override
    public PropertyValueModel<JpaFile> getJpaFileModel() {
        return this.jpaFileModel;
    }

    private PropertyValueModel<JpaFile> buildJpaFileModel() {
        return new DoublePropertyValueModel(this.buildJpaFileModelModel());
    }

    private PropertyValueModel<PropertyValueModel<JpaFile>> buildJpaFileModelModel() {
        return new TransformationPropertyValueModel(this.fileModel, JPA_FILE_MODEL_TRANSFORMER);
    }

    void jpaFileChanged() {
        this.execute(new JpaFileChangedRunnable());
    }

    void jpaFileChanged_() {
        this.jpaSelectionModel.setValue((Object)this.getTextEditorJpaSelection());
    }

    @Override
    public ModifiablePropertyValueModel<JpaStructureNode> getJpaSelectionModel() {
        return this.jpaSelectionModel;
    }

    void setJpaSelection(ISelection selection) {
        this.jpaSelectionModel.setValue((Object)this.getTextEditorJpaSelection(selection));
    }

    void setTextEditorJpaSelection(JpaStructureNode selection) {
        this.execute(new SetTextEditorSelectionRunnable(selection));
    }

    void setTextEditorJpaSelection_(JpaStructureNode selection) {
        if (selection != null && selection != this.getTextEditorJpaSelection()) {
            this.setTextEditorSelection(selection.getSelectionTextRange());
        }
    }

    private void setTextEditorSelection(TextRange textRange) {
        if (textRange != null) {
            this.textEditor.selectAndReveal(textRange.getOffset(), textRange.getLength());
        }
    }

    private JpaStructureNode getTextEditorJpaSelection() {
        IPostSelectionProvider selProvider = this.getTextEditorSelectionProvider();
        return selProvider == null ? null : this.getTextEditorJpaSelection(selProvider.getSelection());
    }

    private JpaStructureNode getTextEditorJpaSelection(ISelection selection) {
        return selection instanceof ITextSelection ? this.getTextEditorJpaSelection((ITextSelection)selection) : null;
    }

    private JpaStructureNode getTextEditorJpaSelection(ITextSelection selection) {
        JpaFile jpaFile = (JpaFile)this.jpaFileModel.getValue();
        return jpaFile == null ? null : jpaFile.getStructureNode(selection.getOffset());
    }

    @Override
    public IEditorPart getEditor() {
        return this.textEditor;
    }

    void setFileModel() {
        this.fileModel.setValue((Object)this.getTextEditorFile());
    }

    private IFile getTextEditorFile() {
        IEditorInput input = this.textEditor.getEditorInput();
        return input instanceof IFileEditorInput ? ((IFileEditorInput)input).getFile() : null;
    }

    private IPostSelectionProvider getTextEditorSelectionProvider() {
        ISelectionProvider selProvider = this.textEditor.getSelectionProvider();
        return selProvider instanceof IPostSelectionProvider ? (IPostSelectionProvider)selProvider : null;
    }

    private void execute(Runnable runnable) {
        DisplayTools.execute((Display)this.textEditor.getSite().getShell().getDisplay(), (Runnable)runnable);
    }

    @Override
    public void dispose() {
        this.jpaFileModel.removePropertyChangeListener("value", this.jpaFileListener);
        this.jpaSelectionModel.removePropertyChangeListener("value", this.jpaSelectionListener);
        IPostSelectionProvider selProvider = this.getTextEditorSelectionProvider();
        if (selProvider != null) {
            selProvider.removePostSelectionChangedListener(this.textEditorSelectionListener);
        }
        this.textEditor.removePropertyListener(this.textEditorInputListener);
    }

    public String toString() {
        return ObjectTools.toString((Object)this, (Object)this.textEditor);
    }

    class JpaFileChangedRunnable
    implements Runnable {
        JpaFileChangedRunnable() {
        }

        @Override
        public void run() {
            JpaTextEditorManager.this.jpaFileChanged_();
        }

        public String toString() {
            return ObjectTools.toString((Object)this);
        }
    }

    class JpaFileListener
    extends PropertyChangeAdapter {
        JpaFileListener() {
        }

        public void propertyChanged(PropertyChangeEvent event) {
            JpaTextEditorManager.this.jpaFileChanged();
        }
    }

    static class JpaFileModelTransformer
    extends AbstractTransformer<IFile, PropertyValueModel<JpaFile>> {
        JpaFileModelTransformer() {
        }

        protected PropertyValueModel<JpaFile> transform_(IFile file) {
            return (JpaFileModel)file.getAdapter(JpaFileModel.class);
        }
    }

    class JpaSelectionListener
    extends PropertyChangeAdapter {
        JpaSelectionListener() {
        }

        public void propertyChanged(PropertyChangeEvent event) {
            JpaTextEditorManager.this.setTextEditorJpaSelection((JpaStructureNode)event.getNewValue());
        }
    }

    class SetTextEditorSelectionRunnable
    implements Runnable {
        private final JpaStructureNode selection;

        SetTextEditorSelectionRunnable(JpaStructureNode selection) {
            this.selection = selection;
        }

        @Override
        public void run() {
            JpaTextEditorManager.this.setTextEditorJpaSelection_(this.selection);
        }

        public String toString() {
            return ObjectTools.toString((Object)this, (Object)this.selection);
        }
    }

    class TextEditorInputListener
    extends PropertyAdapter {
        TextEditorInputListener() {
        }

        public void propertyChanged(Object source, int propertyID) {
            if (propertyID == 258) {
                JpaTextEditorManager.this.setFileModel();
            }
        }
    }

    class TextEditorSelectionListener
    extends SelectionChangedAdapter {
        TextEditorSelectionListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            if (JptJpaUiPlugin.instance().focusIsNotInDaliView()) {
                JpaTextEditorManager.this.setJpaSelection(event.getSelection());
            }
        }
    }
}

