/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder;

import java.util.Arrays;
import java.util.List;
import org.eclipse.datatools.sqltools.sqlbuilder.Messages;
import org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.UDFNamesAndSignatures;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SQLDomainModel;
import org.eclipse.swt.widgets.Combo;

public class InstantDBFunctionNamesAndSignatures {
    public static final String instantDBAll = Messages._UI_FCN_ALL;
    public static final String instantDBAggregate = Messages._UI_FCN_AGGREGATE;
    public static String dbUDF = Messages._UI_FCN_UDF;
    private static final String[] allFunctions = new String[]{"AVG", "COUNT", "MAX", "MIN", "SUM"};
    private static final String[] allColumnSupportedFunctions = allFunctions;
    private static final String[] functionsSupportingStar = new String[]{"COUNT"};
    private static final String[] aggregateFunctions = new String[]{"AVG", "COUNT", "MAX", "MIN", "SUM"};

    public static Object[][] getParms(String func) {
        Object[][] list = new Object[1][2];
        list[0][0] = "???";
        list[0][1] = "???";
        if (func.equals("AVG")) {
            list[0][0] = "numeric_expression";
            list[0][1] = "expression";
        } else if (func.equals("COUNT")) {
            list[0][0] = "numeric_expression";
            list[0][1] = "expression";
        } else if (func.equals("MAX")) {
            list[0][0] = "expression";
            list[0][1] = "expression";
        } else if (func.equals("MIN")) {
            list[0][0] = "expression";
            list[0][1] = "expression";
        } else if (func.equals("SUM")) {
            list[0][0] = "expression";
            list[0][1] = "expression";
        } else {
            list = UDFNamesAndSignatures.getUDFParams(func);
        }
        return list;
    }

    public static Object[][] getParameterFormats(String functionName) {
        return InstantDBFunctionNamesAndSignatures.getParms(functionName);
    }

    public static void fillCategoryCombo(Combo functionsCategoryCombo, boolean isColumn) {
        if (!isColumn) {
            functionsCategoryCombo.add(instantDBAll);
            functionsCategoryCombo.add(instantDBAggregate);
            functionsCategoryCombo.add(dbUDF);
        } else {
            functionsCategoryCombo.add(instantDBAll);
            functionsCategoryCombo.add(instantDBAggregate);
            functionsCategoryCombo.add(dbUDF);
        }
    }

    public static boolean isFunctionSupportingStar(String s) {
        List<String> funcList = Arrays.asList(functionsSupportingStar);
        return funcList.contains(s);
    }

    public static String[] getFunctionList(String category, boolean isColumn, SQLDomainModel domainModel) {
        if (category.equals(instantDBAll)) {
            if (!isColumn) {
                return UDFNamesAndSignatures.mergeTwoArrays(allFunctions, UDFNamesAndSignatures.getUDFNames(domainModel));
            }
            return UDFNamesAndSignatures.mergeTwoArrays(allColumnSupportedFunctions, UDFNamesAndSignatures.getUDFNames(domainModel));
        }
        if (category.equals(instantDBAggregate)) {
            return aggregateFunctions;
        }
        if (category.equals(dbUDF)) {
            return UDFNamesAndSignatures.getUDFNames(domainModel);
        }
        return UDFNamesAndSignatures.mergeTwoArrays(allFunctions, UDFNamesAndSignatures.getUDFNames(domainModel));
    }
}

