/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.preferences;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.preferences.AddConfigEntryDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jface.window.SameShellProvider;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.storage.file.FileBasedConfig;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.model.WorkbenchAdapter;
import org.eclipse.ui.model.WorkbenchContentProvider;

public class ConfigurationEditorComponent {
    private static final String DOT = ".";
    private StoredConfig editableConfig;
    private final IShellProvider shellProvider;
    private final Composite parent;
    private final boolean useDialogFont;
    private Composite contents;
    private Button newValue;
    private Button remove;
    private TreeViewer tv;
    private Text location;
    private boolean editable;

    public ConfigurationEditorComponent(Composite parent, StoredConfig config, boolean useDialogFont) {
        this.editableConfig = config;
        this.shellProvider = new SameShellProvider((Control)parent);
        this.parent = parent;
        this.useDialogFont = useDialogFont;
    }

    void setConfig(FileBasedConfig config) throws IOException {
        this.editableConfig = config;
        try {
            this.editableConfig.clear();
            this.editableConfig.load();
        }
        catch (ConfigInvalidException e) {
            throw new IOException(e.getMessage());
        }
        this.initControlsFromConfig();
    }

    public void save() throws IOException {
        this.editableConfig.save();
        this.setDirty(false);
        this.initControlsFromConfig();
    }

    public void restore() throws IOException {
        try {
            this.editableConfig.clear();
            this.editableConfig.load();
        }
        catch (ConfigInvalidException e) {
            throw new IOException(e.getMessage());
        }
        this.initControlsFromConfig();
    }

    public Control createContents() {
        Composite main = new Composite(this.parent, 0);
        main.setLayout((Layout)new GridLayout(2, false));
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)main);
        if (this.editableConfig instanceof FileBasedConfig) {
            Composite locationPanel = new Composite(main, 0);
            locationPanel.setLayout((Layout)new GridLayout(4, false));
            GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)locationPanel);
            Label locationLabel = new Label(locationPanel, 0);
            locationLabel.setText(UIText.ConfigurationEditorComponent_ConfigLocationLabel);
            int locationStyle = 2056;
            this.location = new Text(locationPanel, locationStyle);
            GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.location);
            Button openEditor = new Button(locationPanel, 8);
            openEditor.setText(UIText.ConfigurationEditorComponent_OpenEditorButton);
            openEditor.setToolTipText(UIText.ConfigurationEditorComponent_OpenEditorTooltip);
            openEditor.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    IFileStore store = EFS.getLocalFileSystem().getStore((IPath)new Path(((FileBasedConfig)ConfigurationEditorComponent.this.editableConfig).getFile().getAbsolutePath()));
                    try {
                        IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IEditorInput)new FileStoreEditorInput(store), (String)"org.eclipse.ui.DefaultTextEditor");
                    }
                    catch (PartInitException ex) {
                        Activator.handleError(ex.getMessage(), ex, true);
                    }
                }
            });
            openEditor.setEnabled(((FileBasedConfig)this.editableConfig).getFile() != null);
        }
        this.tv = new TreeViewer(main, 67588);
        Tree tree = this.tv.getTree();
        GridDataFactory.fillDefaults().hint(100, 60).grab(true, true).applyTo((Control)tree);
        TreeColumn key = new TreeColumn(tree, 0);
        key.setText(UIText.ConfigurationEditorComponent_KeyColumnHeader);
        key.setWidth(150);
        final TextCellEditor editor = new TextCellEditor((Composite)tree);
        editor.setValidator(new ICellEditorValidator(){

            public String isValid(Object value) {
                String editedValue = value.toString();
                return editedValue.length() > 0 ? null : UIText.ConfigurationEditorComponent_EmptyStringNotAllowed;
            }
        });
        editor.addListener(new ICellEditorListener(){

            public void editorValueChanged(boolean oldValidState, boolean newValidState) {
                ConfigurationEditorComponent.this.setErrorMessage(editor.getErrorMessage());
            }

            public void cancelEditor() {
                ConfigurationEditorComponent.this.setErrorMessage(null);
            }

            public void applyEditorValue() {
                ConfigurationEditorComponent.this.setErrorMessage(null);
            }
        });
        TreeColumn value = new TreeColumn(tree, 0);
        value.setText(UIText.ConfigurationEditorComponent_ValueColumnHeader);
        value.setWidth(250);
        new TreeViewerColumn(this.tv, value).setEditingSupport(new EditingSupport((ColumnViewer)this.tv){

            protected void setValue(Object element, Object newValue) {
                Entry entry = (Entry)((Object)element);
                if (!entry.value.equals(newValue)) {
                    entry.changeValue(newValue.toString());
                    ConfigurationEditorComponent.this.markDirty();
                }
            }

            protected Object getValue(Object element) {
                return ((Entry)((Object)element)).value;
            }

            protected CellEditor getCellEditor(Object element) {
                return editor;
            }

            protected boolean canEdit(Object element) {
                return ConfigurationEditorComponent.this.editable && element instanceof Entry;
            }
        });
        this.tv.setContentProvider((IContentProvider)new WorkbenchContentProvider());
        Font defaultFont = this.useDialogFont ? JFaceResources.getDialogFont() : JFaceResources.getDefaultFont();
        this.tv.setLabelProvider((IBaseLabelProvider)new ConfigEditorLabelProvider(defaultFont));
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        Composite buttonPanel = new Composite(main, 0);
        GridLayoutFactory.fillDefaults().applyTo(buttonPanel);
        GridDataFactory.fillDefaults().grab(false, false).applyTo((Control)buttonPanel);
        this.newValue = new Button(buttonPanel, 8);
        GridDataFactory.fillDefaults().applyTo((Control)this.newValue);
        this.newValue.setText(UIText.ConfigurationEditorComponent_AddButton);
        this.newValue.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String suggestedKey;
                IStructuredSelection sel = (IStructuredSelection)ConfigurationEditorComponent.this.tv.getSelection();
                Object first = sel.getFirstElement();
                if (first instanceof Section) {
                    suggestedKey = String.valueOf(((Section)((Object)first)).name) + ConfigurationEditorComponent.DOT;
                } else if (first instanceof SubSection) {
                    SubSection sub = (SubSection)((Object)first);
                    suggestedKey = String.valueOf(sub.parent.name) + ConfigurationEditorComponent.DOT + sub.name + ConfigurationEditorComponent.DOT;
                } else {
                    Entry entry;
                    suggestedKey = first instanceof Entry ? ((entry = (Entry)((Object)first)).sectionparent != null ? String.valueOf(entry.sectionparent.name) + ConfigurationEditorComponent.DOT : String.valueOf(entry.subsectionparent.parent.name) + ConfigurationEditorComponent.DOT + entry.subsectionparent.name + ConfigurationEditorComponent.DOT) : null;
                }
                AddConfigEntryDialog dlg = new AddConfigEntryDialog(ConfigurationEditorComponent.this.getShell(), suggestedKey);
                if (dlg.open() == 0) {
                    String result = dlg.getKey();
                    if (result == null) {
                        return;
                    }
                    StringTokenizer st = new StringTokenizer(result, ConfigurationEditorComponent.DOT);
                    if (st.countTokens() == 2) {
                        String sectionName = st.nextToken();
                        String entryName = st.nextToken();
                        Entry entry = ((GitConfig)((Object)ConfigurationEditorComponent.this.tv.getInput())).getEntry(sectionName, null, entryName);
                        if (entry == null) {
                            ConfigurationEditorComponent.this.editableConfig.setString(sectionName, null, entryName, dlg.getValue());
                        } else {
                            entry.addValue(dlg.getValue());
                        }
                        ConfigurationEditorComponent.this.markDirty();
                    } else if (st.countTokens() > 2) {
                        int n = st.countTokens();
                        String sectionName = st.nextToken();
                        StringBuilder b = new StringBuilder(st.nextToken());
                        int i = 0;
                        while (i < n - 3) {
                            b.append(ConfigurationEditorComponent.DOT);
                            b.append(st.nextToken());
                            ++i;
                        }
                        String subSectionName = b.toString();
                        String entryName = st.nextToken();
                        Entry entry = ((GitConfig)((Object)ConfigurationEditorComponent.this.tv.getInput())).getEntry(sectionName, subSectionName, entryName);
                        if (entry == null) {
                            ConfigurationEditorComponent.this.editableConfig.setString(sectionName, subSectionName, entryName, dlg.getValue());
                        } else {
                            entry.addValue(dlg.getValue());
                        }
                        ConfigurationEditorComponent.this.markDirty();
                    } else {
                        Activator.handleError(UIText.ConfigurationEditorComponent_WrongNumberOfTokensMessage, null, true);
                    }
                }
            }
        });
        this.remove = new Button(buttonPanel, 8);
        GridDataFactory.fillDefaults().applyTo((Control)this.remove);
        this.remove.setText(UIText.ConfigurationEditorComponent_RemoveButton);
        this.remove.setToolTipText(UIText.ConfigurationEditorComponent_RemoveTooltip);
        this.remove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection sel = (IStructuredSelection)ConfigurationEditorComponent.this.tv.getSelection();
                Object first = sel.getFirstElement();
                if (first instanceof Section) {
                    Section section = (Section)((Object)first);
                    if (MessageDialog.openConfirm((Shell)ConfigurationEditorComponent.this.getShell(), (String)UIText.ConfigurationEditorComponent_RemoveSectionTitle, (String)NLS.bind((String)UIText.ConfigurationEditorComponent_RemoveSectionMessage, (Object)section.name))) {
                        ConfigurationEditorComponent.this.editableConfig.unsetSection(section.name, null);
                        ConfigurationEditorComponent.this.markDirty();
                    }
                } else if (first instanceof SubSection) {
                    SubSection section = (SubSection)((Object)first);
                    if (MessageDialog.openConfirm((Shell)ConfigurationEditorComponent.this.getShell(), (String)UIText.ConfigurationEditorComponent_RemoveSubsectionTitle, (String)NLS.bind((String)UIText.ConfigurationEditorComponent_RemoveSubsectionMessage, (Object)(String.valueOf(section.parent.name) + ConfigurationEditorComponent.DOT + section.name)))) {
                        ConfigurationEditorComponent.this.editableConfig.unsetSection(section.parent.name, section.name);
                        ConfigurationEditorComponent.this.markDirty();
                    }
                } else if (first instanceof Entry) {
                    ((Entry)((Object)first)).removeValue();
                    ConfigurationEditorComponent.this.markDirty();
                } else {
                    Activator.handleError(UIText.ConfigurationEditorComponent_NoSectionSubsectionMessage, null, true);
                }
                super.widgetSelected(e);
            }
        });
        this.tv.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ConfigurationEditorComponent.this.updateEnablement();
            }
        });
        this.initControlsFromConfig();
        this.contents = main;
        return this.contents;
    }

    public Composite getContents() {
        return this.contents;
    }

    private boolean isWriteable(File f) {
        if (f.exists()) {
            if (f.isFile()) {
                return f.canWrite();
            }
            return false;
        }
        File d = f.getParentFile();
        while (d != null) {
            if (d.isDirectory()) {
                return d.canWrite();
            }
            if (d.exists()) {
                return false;
            }
            d = d.getParentFile();
        }
        return false;
    }

    private void initControlsFromConfig() {
        try {
            this.editableConfig.load();
            this.tv.setInput((Object)new GitConfig((Config)this.editableConfig));
            this.editable = true;
            if (this.editableConfig instanceof FileBasedConfig) {
                FileBasedConfig fileConfig = (FileBasedConfig)this.editableConfig;
                File configFile = fileConfig.getFile();
                if (configFile != null) {
                    if (this.isWriteable(configFile)) {
                        this.location.setText(configFile.getPath());
                    } else {
                        this.location.setText(NLS.bind((String)UIText.ConfigurationEditorComponent_ReadOnlyLocationFormat, (Object)configFile.getPath()));
                        this.editable = false;
                    }
                } else {
                    this.location.setText(UIText.ConfigurationEditorComponent_NoConfigLocationKnown);
                    this.editable = false;
                }
            }
        }
        catch (IOException e) {
            Activator.handleError(e.getMessage(), e, true);
        }
        catch (ConfigInvalidException e) {
            Activator.handleError(e.getMessage(), e, true);
        }
        this.tv.expandAll();
        this.updateEnablement();
    }

    protected void setErrorMessage(String message) {
    }

    protected void setDirty(boolean dirty) {
    }

    private void updateEnablement() {
        this.remove.setEnabled(this.editable);
        this.newValue.setEnabled(this.editable);
    }

    private void markDirty() {
        this.setDirty(true);
        ((GitConfig)((Object)this.tv.getInput())).refresh();
        this.tv.refresh();
    }

    private Shell getShell() {
        return this.shellProvider.getShell();
    }

    private static final class ConfigEditorLabelProvider
    extends BaseLabelProvider
    implements ITableLabelProvider,
    IFontProvider {
        private Font boldFont = null;
        private final Font defaultFont;

        public ConfigEditorLabelProvider(Font defaultFont) {
            this.defaultFont = defaultFont;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    if (element instanceof Section) {
                        return ((Section)((Object)element)).name;
                    }
                    if (element instanceof SubSection) {
                        return ((SubSection)((Object)element)).name;
                    }
                    if (element instanceof Entry) {
                        Entry entry = (Entry)((Object)element);
                        if (entry.index < 0) {
                            return entry.name;
                        }
                        return String.valueOf(entry.name) + "[" + entry.index + "]";
                    }
                    return null;
                }
                case 1: {
                    if (element instanceof Entry) {
                        return ((Entry)((Object)element)).value;
                    }
                    return null;
                }
            }
            return null;
        }

        public Font getFont(Object element) {
            if (element instanceof Section || element instanceof SubSection) {
                return this.getBoldFont();
            }
            return null;
        }

        private Font getBoldFont() {
            if (this.boldFont != null) {
                return this.boldFont;
            }
            FontData[] data = this.defaultFont.getFontData();
            int i = 0;
            while (i < data.length) {
                data[i].setStyle(data[i].getStyle() | 1);
                ++i;
            }
            this.boldFont = new Font((Device)Display.getDefault(), data);
            return this.boldFont;
        }

        public void dispose() {
            if (this.boldFont != null) {
                this.boldFont.dispose();
            }
            super.dispose();
        }
    }

    private static final class Entry
    extends WorkbenchAdapter {
        private final Section sectionparent;
        private final SubSection subsectionparent;
        private final String name;
        private final String value;
        private final int index;

        Entry(Section parent, String name, String value, int index) {
            this.sectionparent = parent;
            this.subsectionparent = null;
            this.name = name;
            this.value = value;
            this.index = index;
        }

        public void addValue(String newValue) {
            if (newValue.length() == 0) {
                throw new IllegalArgumentException(UIText.ConfigurationEditorComponent_EmptyStringNotAllowed);
            }
            Config config = this.getConfig();
            if (this.sectionparent != null) {
                ArrayList<String> entries = new ArrayList<String>(Arrays.asList(config.getStringList(this.sectionparent.name, null, this.name)));
                entries.add(Math.max(this.index, 0), newValue);
                config.setStringList(this.sectionparent.name, null, this.name, entries);
            } else {
                ArrayList<String> entries = new ArrayList<String>(Arrays.asList(config.getStringList(this.subsectionparent.parent.name, this.subsectionparent.name, this.name)));
                entries.add(Math.max(this.index, 0), newValue);
                config.setStringList(this.subsectionparent.parent.name, this.subsectionparent.name, this.name, entries);
            }
        }

        Entry(SubSection parent, String name, String value, int index) {
            this.sectionparent = null;
            this.subsectionparent = parent;
            this.name = name;
            this.value = value;
            this.index = index;
        }

        public void changeValue(String newValue) throws IllegalArgumentException {
            if (newValue.length() == 0) {
                throw new IllegalArgumentException(UIText.ConfigurationEditorComponent_EmptyStringNotAllowed);
            }
            Config config = this.getConfig();
            if (this.index < 0) {
                if (this.sectionparent != null) {
                    config.setString(this.sectionparent.name, null, this.name, newValue);
                } else {
                    config.setString(this.subsectionparent.parent.name, this.subsectionparent.name, this.name, newValue);
                }
            } else if (this.sectionparent != null) {
                String[] entries = config.getStringList(this.sectionparent.name, null, this.name);
                entries[this.index] = newValue;
                config.setStringList(this.sectionparent.name, null, this.name, Arrays.asList(entries));
            } else {
                String[] entries = config.getStringList(this.subsectionparent.parent.name, this.subsectionparent.name, this.name);
                entries[this.index] = newValue;
                config.setStringList(this.subsectionparent.parent.name, this.subsectionparent.name, this.name, Arrays.asList(entries));
            }
        }

        private Config getConfig() {
            Config config = this.sectionparent != null ? this.sectionparent.parent.config : this.subsectionparent.parent.parent.config;
            return config;
        }

        public void removeValue() {
            Config config = this.getConfig();
            if (this.index < 0) {
                if (this.sectionparent != null) {
                    config.unset(this.sectionparent.name, null, this.name);
                } else {
                    config.unset(this.subsectionparent.parent.name, this.subsectionparent.name, this.name);
                }
            } else if (this.sectionparent != null) {
                ArrayList<String> entries = new ArrayList<String>(Arrays.asList(config.getStringList(this.sectionparent.name, null, this.name)));
                entries.remove(this.index);
                config.setStringList(this.sectionparent.name, null, this.name, entries);
            } else {
                ArrayList<String> entries = new ArrayList<String>(Arrays.asList(config.getStringList(this.subsectionparent.parent.name, this.subsectionparent.name, this.name)));
                entries.remove(this.index);
                config.setStringList(this.subsectionparent.parent.name, this.subsectionparent.name, this.name, entries);
            }
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.index;
            result = 31 * result + this.name.hashCode();
            result = 31 * result + (this.sectionparent == null ? 0 : this.sectionparent.hashCode());
            result = 31 * result + (this.subsectionparent == null ? 0 : this.subsectionparent.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Entry other = (Entry)((Object)obj);
            if (this.index != other.index && (this.index > 0 || other.index > 0)) {
                return false;
            }
            if (!this.name.equals(other.name)) {
                return false;
            }
            if (this.sectionparent == null ? other.sectionparent != null : !this.sectionparent.equals((Object)other.sectionparent)) {
                return false;
            }
            return !(this.subsectionparent == null ? other.subsectionparent != null : !this.subsectionparent.equals((Object)other.subsectionparent));
        }
    }

    private static final class GitConfig
    extends WorkbenchAdapter {
        private final Config config;
        private Section[] children;

        GitConfig(Config config) {
            this.config = config;
        }

        GitConfig refresh() {
            this.children = null;
            return this;
        }

        public Object[] getChildren(Object o) {
            if (this.children == null) {
                if (this.config != null) {
                    ArrayList<Section> sections = new ArrayList<Section>();
                    Set sectionNames = this.config.getSections();
                    for (String sectionName : sectionNames) {
                        sections.add(new Section(this, sectionName));
                    }
                    Collections.sort(sections, new Comparator<Section>(){

                        @Override
                        public int compare(Section o1, Section o2) {
                            return o1.name.compareTo(o2.name);
                        }
                    });
                    this.children = sections.toArray(new Section[sections.size()]);
                } else {
                    this.children = new Section[0];
                }
            }
            return this.children;
        }

        public Entry getEntry(String sectionName, String subsectionName, String entryName) {
            Object[] objectArray = this.getChildren((Object)this);
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object child = objectArray[n2];
                Section section = (Section)((Object)child);
                if (sectionName.equals(section.name)) {
                    return section.getEntry(subsectionName, entryName);
                }
                ++n2;
            }
            return null;
        }
    }

    private static final class Section
    extends WorkbenchAdapter {
        private final String name;
        private final GitConfig parent;
        private Object[] children;

        Section(GitConfig parent, String name) {
            this.parent = parent;
            this.name = name;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.name.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Section other = (Section)((Object)obj);
            return this.name.equals(other.name);
        }

        public Object getParent(Object object) {
            return this.parent;
        }

        public Object[] getChildren(Object o) {
            if (this.children == null) {
                ArrayList<WorkbenchAdapter> allChildren = new ArrayList<WorkbenchAdapter>();
                Set subSectionNames = this.parent.config.getSubsections(this.name);
                for (String subSectionName : subSectionNames) {
                    allChildren.add(new SubSection(this.parent.config, this, subSectionName));
                }
                Set entryNames = this.parent.config.getNames(this.name);
                for (String entryName : entryNames) {
                    String[] values = this.parent.config.getStringList(this.name, null, entryName);
                    if (values.length == 1) {
                        allChildren.add(new Entry(this, entryName, values[0], -1));
                        continue;
                    }
                    int index = 0;
                    String[] stringArray = values;
                    int n = values.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String value = stringArray[n2];
                        allChildren.add(new Entry(this, entryName, value, index++));
                        ++n2;
                    }
                }
                this.children = allChildren.toArray();
            }
            return this.children;
        }

        public String getLabel(Object o) {
            return this.name;
        }

        public Entry getEntry(String subsectionName, String entryName) {
            if (subsectionName != null) {
                Object[] objectArray = this.getChildren((Object)this);
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object child = objectArray[n2];
                    if (child instanceof SubSection && ((SubSection)((Object)child)).name.equals(subsectionName)) {
                        return ((SubSection)((Object)child)).getEntry(entryName);
                    }
                    ++n2;
                }
            } else {
                Object[] objectArray = this.getChildren((Object)this);
                int n = objectArray.length;
                int n3 = 0;
                while (n3 < n) {
                    Object child = objectArray[n3];
                    if (child instanceof Entry && ((Entry)((Object)child)).name.equals(entryName)) {
                        return (Entry)((Object)child);
                    }
                    ++n3;
                }
            }
            return null;
        }
    }

    private static final class SubSection
    extends WorkbenchAdapter {
        private final Config config;
        private final Section parent;
        private final String name;
        private Entry[] children;

        SubSection(Config config, Section parent, String name) {
            this.config = config;
            this.parent = parent;
            this.name = name;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.name.hashCode();
            result = 31 * result + this.parent.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            SubSection other = (SubSection)((Object)obj);
            if (!this.name.equals(other.name)) {
                return false;
            }
            return this.parent.equals((Object)other.parent);
        }

        public Object[] getChildren(Object o) {
            if (this.children == null) {
                ArrayList<Entry> entries = new ArrayList<Entry>();
                Set entryNames = this.config.getNames(this.parent.name, this.name);
                for (String entryName : entryNames) {
                    String[] values = this.config.getStringList(this.parent.name, this.name, entryName);
                    if (values.length == 1) {
                        entries.add(new Entry(this, entryName, values[0], -1));
                        continue;
                    }
                    int index = 0;
                    String[] stringArray = values;
                    int n = values.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String value = stringArray[n2];
                        entries.add(new Entry(this, entryName, value, index++));
                        ++n2;
                    }
                }
                this.children = entries.toArray(new Entry[entries.size()]);
            }
            return this.children;
        }

        public String getLabel(Object o) {
            return this.name;
        }

        public Object getParent(Object object) {
            return this.parent;
        }

        public Entry getEntry(String entryName) {
            Object[] objectArray = this.getChildren((Object)this);
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object child = objectArray[n2];
                if (entryName.equals(((Entry)((Object)child)).name)) {
                    return (Entry)((Object)child);
                }
                ++n2;
            }
            return null;
        }
    }
}

