/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.js.gulp.internal.launch.ui;

import java.io.File;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.js.common.build.system.BuildSystemVisitor;
import org.eclipse.wst.jsdt.js.common.build.system.ITask;
import org.eclipse.wst.jsdt.js.common.build.system.launch.ui.GenericBuildSystemTab;
import org.eclipse.wst.jsdt.js.common.build.system.util.ASTUtil;
import org.eclipse.wst.jsdt.js.common.util.WorkbenchResourceUtil;
import org.eclipse.wst.jsdt.js.gulp.GulpPlugin;
import org.eclipse.wst.jsdt.js.gulp.internal.Messages;
import org.eclipse.wst.jsdt.js.gulp.internal.ui.ImageResource;
import org.eclipse.wst.jsdt.js.gulp.util.GulpVisitor;

public class GulpLaunchTab
extends GenericBuildSystemTab {
    public boolean isValid(ILaunchConfiguration launchConfig) {
        this.setErrorMessage(null);
        String buildFilePath = this.buildFileText.getText();
        File file = WorkbenchResourceUtil.getFile((String)buildFilePath);
        if (file == null) {
            this.setErrorMessage(Messages.GulpLaunchTab_ErrorNotExist);
            return false;
        }
        return true;
    }

    public Image getImage() {
        return ImageResource.getImage("gulp_16.png");
    }

    public void initializeFrom(ILaunchConfiguration lc) {
        String buildFileLocation = "";
        try {
            Set tasks;
            buildFileLocation = lc.getAttribute("org.eclipse.wst.jsdt.js.gulp.BUILD_FILE", null);
            this.buildFileText.setText(buildFileLocation != null ? buildFileLocation : "");
            File file = WorkbenchResourceUtil.getFile((String)buildFileLocation);
            IFile ifile = null;
            if (file != null) {
                ifile = WorkbenchResourceUtil.getFileForLocation((String)file.getAbsolutePath());
            }
            if (!(tasks = ASTUtil.getTasks((String)buildFileLocation, (BuildSystemVisitor)new GulpVisitor(ifile))).isEmpty()) {
                this.updateTasks(this.getTaskNames(tasks));
                String task = lc.getAttribute("org.eclipse.wst.jsdt.js.gulp.COMMAND", null);
                if (task != null && tasks.contains(task)) {
                    this.tasksCommbo.setText(task);
                } else {
                    this.tasksCommbo.setText(((ITask)tasks.iterator().next()).getName());
                }
            }
        }
        catch (CoreException e) {
            GulpPlugin.logError(e, e.getMessage());
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy wc) {
        IFile buildFile = this.getBuildFile();
        if (buildFile != null) {
            IProject project = buildFile.getProject();
            wc.setAttribute("org.eclipse.wst.jsdt.js.gulp.BUILD_FILE", buildFile.getLocation().toOSString());
            wc.setAttribute("org.eclipse.wst.jsdt.js.gulp.PROJECT", project.getName());
            wc.setAttribute("org.eclipse.wst.jsdt.js.gulp.DIR", buildFile.getParent().getLocation().toOSString());
            wc.setAttribute("org.eclipse.wst.jsdt.js.gulp.COMMAND", this.tasksCommbo.getText());
        }
    }

    protected String[] getTasksFromFile(IFile file) throws JavaScriptModelException {
        Set tasks = ASTUtil.getTasks((String)file.getLocation().toOSString(), (BuildSystemVisitor)new GulpVisitor(file));
        return this.getTaskNames(tasks);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy wc) {
    }
}

