/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.dom;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.BindingResolver;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclaration;
import org.eclipse.wst.jsdt.core.dom.FunctionInvocation;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IFunctionBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.VariableDeclaration;
import org.eclipse.wst.jsdt.internal.core.dom.binding.BindingBase;
import org.eclipse.wst.jsdt.internal.core.dom.binding.ClassBinding;
import org.eclipse.wst.jsdt.internal.core.dom.binding.ClassDeclaration;
import org.eclipse.wst.jsdt.internal.core.dom.binding.FunctionBinding;
import org.eclipse.wst.jsdt.internal.core.dom.binding.IDeclaration;
import org.eclipse.wst.jsdt.internal.core.dom.binding.IReference;
import org.eclipse.wst.jsdt.internal.core.dom.binding.SymbolCollector;
import org.eclipse.wst.jsdt.internal.core.dom.binding.VariableBinding;

class BindingResolverDom
extends BindingResolver {
    JavaScriptUnit unit;
    Map<ASTNode, BindingBase> ast2BindingsMap = new HashMap<ASTNode, BindingBase>();
    Map<String, BindingBase> key2BindingsMap = new HashMap<String, BindingBase>();
    private Map<ASTNode, BindingBase> classBindingsMap = new HashMap<ASTNode, BindingBase>();
    private Map<ASTNode, BindingBase> functionBindingsMap = new HashMap<ASTNode, BindingBase>();

    BindingResolverDom(JavaScriptUnit unit) {
        this.unit = unit;
    }

    void resolve() {
        SymbolCollector c = new SymbolCollector(this.unit);
        c.process();
        for (Map.Entry<IDeclaration, List<IReference>> x : c.getClassReferences().entrySet()) {
            this.processClassDeclaration((ClassDeclaration)x.getKey(), x.getValue());
        }
        for (Map.Entry<IDeclaration, List<IReference>> x : c.getFunctionReferences().entrySet()) {
            this.processFunctionDeclaration((org.eclipse.wst.jsdt.internal.core.dom.binding.FunctionDeclaration)x.getKey(), x.getValue());
        }
        for (Map.Entry<IDeclaration, List<IReference>> x : c.getVariableReferences().entrySet()) {
            this.processVariableDeclaration((org.eclipse.wst.jsdt.internal.core.dom.binding.VariableDeclaration)x.getKey(), x.getValue());
        }
        this.classBindingsMap.clear();
        this.functionBindingsMap.clear();
    }

    private void processClassDeclaration(ClassDeclaration decl, List<IReference> references) {
        ClassBinding cb = new ClassBinding(decl, references, 0);
        this.putClassBinding(cb);
        for (BindingBase b : cb.getReferences()) {
            this.putBinding(b);
        }
    }

    private void processFunctionDeclaration(org.eclipse.wst.jsdt.internal.core.dom.binding.FunctionDeclaration decl, List<IReference> references) {
        ASTNode clsDeclaration = decl.getScope().getClassDeclarationLocation();
        ITypeBinding clsBinding = (ITypeBinding)((Object)(clsDeclaration == null ? null : this.classBindingsMap.get(clsDeclaration)));
        FunctionBinding fb = new FunctionBinding(decl, references, clsBinding, 0);
        this.putFunctionBinding(fb);
        for (BindingBase b : fb.getReferences()) {
            this.putBinding(b);
        }
    }

    private void processVariableDeclaration(org.eclipse.wst.jsdt.internal.core.dom.binding.VariableDeclaration decl, List<IReference> references) {
        ASTNode fnDeclaration = decl.getScope().getFunctionDeclarationLocation();
        IFunctionBinding fnBinding = (IFunctionBinding)((Object)(fnDeclaration == null ? null : this.functionBindingsMap.get(fnDeclaration)));
        VariableBinding vb = new VariableBinding(decl, references, fnBinding, 0);
        this.putBinding(vb);
        for (BindingBase b : vb.getReferences()) {
            this.putBinding(b);
        }
    }

    private void putClassBinding(BindingBase binding) {
        this.classBindingsMap.put(binding.getNode(), binding);
        this.putBinding(binding);
    }

    private void putFunctionBinding(BindingBase binding) {
        this.functionBindingsMap.put(binding.getNode(), binding);
        this.putBinding(binding);
    }

    private void putBinding(BindingBase binding) {
        this.ast2BindingsMap.put(binding.getNode(), binding);
        this.key2BindingsMap.put(binding.getKey(), binding);
    }

    @Override
    ASTNode findDeclaringNode(IBinding binding) {
        if (binding instanceof BindingBase) {
            return ((BindingBase)binding).getNode();
        }
        return null;
    }

    @Override
    ASTNode findDeclaringNode(String bindingKey) {
        BindingBase binding;
        if (bindingKey != null && (binding = this.key2BindingsMap.get(bindingKey)) != null) {
            return binding.getNode();
        }
        return null;
    }

    @Override
    IBinding resolveName(Name name) {
        return this.ast2BindingsMap.get(name);
    }

    @Override
    IFunctionBinding resolveMethod(FunctionDeclaration method) {
        return (IFunctionBinding)((Object)this.ast2BindingsMap.get(method.getMethodName()));
    }

    @Override
    IFunctionBinding resolveMethod(FunctionInvocation method) {
        return (IFunctionBinding)((Object)this.ast2BindingsMap.get(method.getName()));
    }

    @Override
    ITypeBinding resolveType(TypeDeclaration type) {
        return (ITypeBinding)((Object)this.ast2BindingsMap.get(type.getName()));
    }

    @Override
    IVariableBinding resolveVariable(VariableDeclaration variable) {
        return (IVariableBinding)((Object)this.ast2BindingsMap.get(variable.getName()));
    }
}

