/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.dom.binding;

import java.util.List;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.Block;
import org.eclipse.wst.jsdt.core.dom.CatchClause;
import org.eclipse.wst.jsdt.core.dom.DoStatement;
import org.eclipse.wst.jsdt.core.dom.ForOfStatement;
import org.eclipse.wst.jsdt.core.dom.ForStatement;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclaration;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclarationStatement;
import org.eclipse.wst.jsdt.core.dom.FunctionExpression;
import org.eclipse.wst.jsdt.core.dom.IfStatement;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.LabeledStatement;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.Statement;
import org.eclipse.wst.jsdt.core.dom.SwitchCase;
import org.eclipse.wst.jsdt.core.dom.SwitchStatement;
import org.eclipse.wst.jsdt.core.dom.TryStatement;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.TypeDeclarationExpression;
import org.eclipse.wst.jsdt.core.dom.TypeDeclarationStatement;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationExpression;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationStatement;
import org.eclipse.wst.jsdt.core.dom.WhileStatement;
import org.eclipse.wst.jsdt.core.dom.WithStatement;
import org.eclipse.wst.jsdt.internal.core.dom.binding.NodeUtil;
import org.eclipse.wst.jsdt.internal.core.dom.binding.Scope;
import org.eclipse.wst.jsdt.internal.core.dom.binding.VariableDeclaration;

public class ScopeDeclarationScanner {
    public static void process(Scope scope) {
        new Visitor().process(scope);
    }

    private static class Visitor {
        private static final String ARGUMENTS = "arguments";
        private Scope rootScope;

        private Visitor() {
        }

        void process(Scope scope) {
            this.rootScope = scope;
            this.scanRoot(scope.getRootNode());
        }

        private void scanRoot(ASTNode n) {
            switch (n.getNodeType()) {
                case 84: {
                    FunctionDeclaration fd = ((FunctionExpression)n).getMethod();
                    SimpleName fNameNode = (SimpleName)fd.getMethodName();
                    if (fNameNode != null) {
                        this.declareFunction(fNameNode);
                    }
                    this.declareExpressions(this.rootScope, fd.parameters());
                    break;
                }
                case 109: {
                    FunctionDeclaration fd = ((FunctionDeclarationStatement)n).getDeclaration();
                    this.declareExpressions(this.rootScope, fd.parameters());
                    break;
                }
                case 31: {
                    FunctionDeclaration fd = (FunctionDeclaration)n;
                    SimpleName fNameNode = (SimpleName)fd.getMethodName();
                    if (fNameNode != null) {
                        this.declareFunction(fNameNode);
                    }
                    this.declareExpressions(this.rootScope, fd.parameters());
                    break;
                }
                case 108: {
                    AbstractTypeDeclaration cd = ((TypeDeclarationExpression)n).getDeclaration();
                    SimpleName cNameNode = cd.getName();
                    if (cNameNode == null) break;
                    this.declareClass(cNameNode);
                    break;
                }
                case 55: {
                    break;
                }
                default: {
                    this.scanDeclarations(n);
                }
            }
        }

        private void scanDeclarations(ASTNode n) {
            if (n == null) {
                return;
            }
            switch (n.getNodeType()) {
                case 60: {
                    VariableDeclarationStatement vd = (VariableDeclarationStatement)n;
                    switch (vd.getKind()) {
                        case VAR: {
                            Scope s = this.rootScope.getHoistScope();
                            for (VariableDeclarationFragment f : vd.fragments()) {
                                this.declareExpression(s, f);
                            }
                            break;
                        }
                        case LET: 
                        case CONST: {
                            if (!this.isAtCurrentLexicalScope(n)) {
                                return;
                            }
                            for (VariableDeclarationFragment f : vd.fragments()) {
                                this.declareExpression(this.rootScope, f);
                            }
                            break;
                        }
                    }
                    return;
                }
                case 58: {
                    VariableDeclarationExpression vd = (VariableDeclarationExpression)n;
                    switch (vd.getKind()) {
                        case VAR: {
                            Scope s = this.rootScope.getHoistScope();
                            for (VariableDeclarationFragment f : vd.fragments()) {
                                this.declareExpression(s, f);
                            }
                            break;
                        }
                        case LET: 
                        case CONST: {
                            if (!this.isAtCurrentLexicalScope(n)) {
                                return;
                            }
                            for (VariableDeclarationFragment f : vd.fragments()) {
                                this.declareExpression(this.rootScope, f);
                            }
                            break;
                        }
                    }
                    return;
                }
                case 84: {
                    return;
                }
                case 109: {
                    FunctionDeclaration fd = ((FunctionDeclarationStatement)n).getDeclaration();
                    SimpleName fNameNode = (SimpleName)fd.getMethodName();
                    if (fNameNode != null) {
                        this.declareFunction(fNameNode);
                    }
                    return;
                }
                case 31: {
                    SimpleName fNameNode = (SimpleName)((FunctionDeclaration)n).getMethodName();
                    if (fNameNode == null) break;
                    this.declareFunction(fNameNode);
                    break;
                }
                case 108: {
                    return;
                }
                case 56: {
                    TypeDeclaration td = (TypeDeclaration)((TypeDeclarationStatement)n).getDeclaration();
                    SimpleName cNameNode = td.getName();
                    if (cNameNode != null) {
                        this.declareClass(cNameNode);
                    }
                    return;
                }
                case 12: {
                    CatchClause cc = (CatchClause)n;
                    if (this.isAtCurrentLexicalScope(n)) {
                        this.declareExpression(this.rootScope, cc.getException());
                    }
                    this.scanDeclarations(cc.getBody());
                    return;
                }
            }
            switch (n.getNodeType()) {
                case 24: {
                    Statement fs = (ForStatement)n;
                    this.scanDeclarations(((ForStatement)fs).initializers());
                    this.scanDeclarations(((ForStatement)fs).getExpression());
                    this.scanDeclarations(((ForStatement)fs).updaters());
                    this.scanDeclarations(((ForStatement)fs).getBody());
                    break;
                }
                case 96: {
                    Statement fs = (ForOfStatement)n;
                    this.scanDeclarations(((ForOfStatement)fs).getIterationVariable());
                    this.scanDeclarations(((ForOfStatement)fs).getCollection());
                    this.scanDeclarations(((ForOfStatement)fs).getBody());
                    break;
                }
                case 19: {
                    Statement fs = (DoStatement)n;
                    this.scanDeclarations(((DoStatement)fs).getBody());
                    this.scanDeclarations(((DoStatement)fs).getExpression());
                    break;
                }
                case 61: {
                    Statement fs = (WhileStatement)n;
                    this.scanDeclarations(((WhileStatement)fs).getExpression());
                    this.scanDeclarations(((WhileStatement)fs).getBody());
                    break;
                }
                case 90: {
                    Statement fs = (WithStatement)n;
                    this.scanDeclarations(((WithStatement)fs).getExpression());
                    this.scanDeclarations(((WithStatement)fs).getBody());
                    break;
                }
                case 25: {
                    Statement fs = (IfStatement)n;
                    this.scanDeclarations(((IfStatement)fs).getExpression());
                    this.scanDeclarations(((IfStatement)fs).getThenStatement());
                    this.scanDeclarations(((IfStatement)fs).getElseStatement());
                    break;
                }
                case 30: {
                    Statement fs = (LabeledStatement)n;
                    this.scanDeclarations(((LabeledStatement)fs).getBody());
                    break;
                }
                case 54: {
                    TryStatement ts = (TryStatement)n;
                    this.scanDeclarations(ts.getBody());
                    this.scanDeclarations(ts.catchClauses());
                    this.scanDeclarations(ts.getFinally());
                    break;
                }
                case 50: {
                    ASTNode ss = (SwitchStatement)n;
                    this.scanDeclarations(((SwitchStatement)ss).getExpression());
                    this.scanDeclarations(((SwitchStatement)ss).statements());
                    break;
                }
                case 49: {
                    ASTNode ss = (SwitchCase)n;
                    this.scanDeclarations(((SwitchCase)ss).getExpression());
                    break;
                }
                case 8: {
                    ASTNode ss = (Block)n;
                    this.scanDeclarations(((Block)ss).statements());
                    break;
                }
                case 15: {
                    ASTNode ss = (JavaScriptUnit)n;
                    this.scanDeclarations(((JavaScriptUnit)ss).statements());
                }
            }
        }

        private void scanDeclarations(List<ASTNode> nodes) {
            if (nodes != null) {
                for (ASTNode node : nodes) {
                    this.scanDeclarations(node);
                }
            }
        }

        private void declareExpressions(Scope scope, List<ASTNode> lhs) {
            if (lhs != null) {
                for (ASTNode p : lhs) {
                    this.declareExpression(scope, p);
                }
            }
        }

        private void declareExpression(Scope scope, ASTNode lhs) {
            switch (lhs.getNodeType()) {
                case 42: {
                    this.declareVariable(scope, (SimpleName)lhs);
                    break;
                }
                case 44: {
                    this.declareVariable(scope, ((SingleVariableDeclaration)lhs).getName());
                    break;
                }
                case 59: {
                    this.declareVariable(scope, ((VariableDeclarationFragment)lhs).getName());
                    break;
                }
            }
        }

        /*
         * Unable to fully structure code
         */
        private boolean isAtCurrentLexicalScope(ASTNode n) {
            parent = n.getParent();
            grandparent = NodeUtil.grandParent(n);
            if (grandparent != null && grandparent.getNodeType() == 49) {
                switchNode = grandparent.getParent();
                return this.rootScope.getRootNode() == switchNode;
            }
            if (parent != this.rootScope.getRootNode() && parent.getNodeType() != 15 && (grandparent == null || grandparent.getNodeType() != 12 || (parent.getParent() != null ? parent.getParent() : null) != this.rootScope.getRootNode())) ** GOTO lbl11
            return true;
lbl-1000:
            // 1 sources

            {
                if (parent.getParent() == this.rootScope.getRootNode()) {
                    return true;
                }
                parent = parent.getParent();
lbl11:
                // 2 sources

                ** while (parent.getNodeType() == 30)
            }
lbl12:
            // 1 sources

            return false;
        }

        private void declareVariable(Scope s, SimpleName n) {
            String name = n.getIdentifier();
            if (this.checkRedeclaration(s, n, name)) {
                s.declareVariable(name, n, VariableDeclaration.VariableKind.VAR);
            }
        }

        private void declareFunction(Scope s, SimpleName n) {
            String name = n.getIdentifier();
            if (this.checkRedeclaration(s, n, name)) {
                s.declareFunction(name, n);
            }
        }

        private void declareFunction(SimpleName n) {
            this.declareFunction(this.rootScope, n);
        }

        private void declareClass(Scope s, SimpleName n) {
            String name = n.getIdentifier();
            if (this.checkRedeclaration(s, n, name)) {
                s.declareClass(name, n);
            }
        }

        private void declareClass(SimpleName n) {
            this.declareClass(this.rootScope, n);
        }

        private boolean checkRedeclaration(Scope s, SimpleName n, String name) {
            return !s.isDeclared(name, false) && (!s.isLocal() || !ARGUMENTS.equals(name));
        }
    }
}

